/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import sun.security.util.Debug;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public final class OAEPParameters
extends AlgorithmParametersSpi {
    private static ObjectIdentifier d;
    private static ObjectIdentifier e;
    private String a;
    private MGF1ParameterSpec b;
    private byte[] c;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            d = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 8});
        }
        catch (IOException iOException) {
            d = null;
        }
        try {
            e = new ObjectIdentifier(new int[]{1, 2, 840, 113549, 1, 1, 9});
            return;
        }
        catch (IOException iOException) {
            e = null;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String a(String string2) {
        if (string2.equals("SHA")) {
            return "SHA-1";
        }
        if (string2.equals("SHA256")) {
            return "SHA-256";
        }
        if (string2.equals("SHA384")) {
            return "SHA-384";
        }
        String string3 = string2;
        if (!string2.equals("SHA512")) return string3;
        return "SHA-512";
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerEncoder derEncoder;
        DerEncoder derEncoder2;
        DerOutputStream derOutputStream = new DerOutputStream();
        try {
            derEncoder2 = AlgorithmId.get(this.a);
            derEncoder = new DerOutputStream();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.a + " impl not found");
        }
        derEncoder2.derEncode((OutputStream)((Object)derEncoder));
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)0), (DerOutputStream)derEncoder);
        derEncoder2 = new DerOutputStream();
        derEncoder2.putOID(d);
        try {
            derEncoder = AlgorithmId.get(this.b.getDigestAlgorithm());
            ((AlgorithmId)derEncoder).encode((DerOutputStream)derEncoder2);
            derEncoder = new DerOutputStream();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("AlgorithmId " + this.b.getDigestAlgorithm() + " impl not found");
        }
        derEncoder.write((byte)48, (DerOutputStream)derEncoder2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)1), (DerOutputStream)derEncoder);
        derEncoder2 = new DerOutputStream();
        derEncoder2.putOID(e);
        derEncoder2.putOctetString(this.c);
        derEncoder = new DerOutputStream();
        derEncoder.write((byte)48, (DerOutputStream)derEncoder2);
        derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)2), (DerOutputStream)derEncoder);
        derEncoder2 = new DerOutputStream();
        derEncoder2.write((byte)48, derOutputStream);
        return ((ByteArrayOutputStream)((Object)derEncoder2)).toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string2) throws IOException {
        if (string2 != null && !string2.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (OAEPParameterSpec.class.isAssignableFrom(clazz)) {
            return new OAEPParameterSpec(this.a, "MGF1", this.b, new PSource.PSpecified(this.c));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec object) throws InvalidParameterSpecException {
        if (!(object instanceof OAEPParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        object = (OAEPParameterSpec)object;
        this.a = ((OAEPParameterSpec)object).getDigestAlgorithm();
        Object object2 = ((OAEPParameterSpec)object).getMGFAlgorithm();
        if (!((String)object2).equalsIgnoreCase("MGF1")) {
            throw new InvalidParameterSpecException("Unsupported mgf " + (String)object2 + "; MGF1 only");
        }
        object2 = ((OAEPParameterSpec)object).getMGFParameters();
        if (!(object2 instanceof MGF1ParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate mgf parameters; non-null MGF1ParameterSpec only");
        }
        this.b = (MGF1ParameterSpec)object2;
        if (((PSource)(object = ((OAEPParameterSpec)object).getPSource())).getAlgorithm().equals("PSpecified")) {
            this.c = ((PSource.PSpecified)object).getValue();
            return;
        }
        throw new InvalidParameterSpecException("Unsupported pSource " + ((PSource)object).getAlgorithm() + "; PSpecified only");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(byte[] object) throws IOException {
        object = new DerInputStream((byte[])object);
        this.a = "SHA-1";
        this.b = MGF1ParameterSpec.SHA1;
        this.c = new byte[0];
        object = ((DerInputStream)object).getSequence(3);
        int n2 = 0;
        while (true) {
            block11: {
                Object object2;
                block13: {
                    block14: {
                        block12: {
                            if (n2 >= ((Object)object).length) {
                                return;
                            }
                            object2 = object[n2];
                            if (!((DerValue)object2).isContextSpecific((byte)0)) break block12;
                            this.a = OAEPParameters.a(AlgorithmId.parse(((DerValue)object2).data.getDerValue()).getName());
                            break block11;
                        }
                        if (!((DerValue)object2).isContextSpecific((byte)1)) break block13;
                        object2 = AlgorithmId.parse(((DerValue)object2).data.getDerValue());
                        if (!((AlgorithmId)object2).getOID().equals(d)) {
                            throw new IOException("Only MGF1 mgf is supported");
                        }
                        if (!((String)(object2 = OAEPParameters.a(AlgorithmId.parse(new DerValue(((AlgorithmId)object2).getEncodedParams())).getName()))).equals("SHA-1")) break block14;
                        this.b = MGF1ParameterSpec.SHA1;
                        break block11;
                    }
                    if (((String)object2).equals("SHA-256")) {
                        this.b = MGF1ParameterSpec.SHA256;
                        break block11;
                    } else if (((String)object2).equals("SHA-384")) {
                        this.b = MGF1ParameterSpec.SHA384;
                        break block11;
                    } else {
                        if (!((String)object2).equals("SHA-512")) {
                            throw new IOException("Unrecognized message digest algorithm");
                        }
                        this.b = MGF1ParameterSpec.SHA512;
                    }
                    break block11;
                }
                if (!((DerValue)object2).isContextSpecific((byte)2)) {
                    throw new IOException("Invalid encoded OAEPParameters");
                }
                object2 = AlgorithmId.parse(((DerValue)object2).data.getDerValue());
                if (!((AlgorithmId)object2).getOID().equals(e)) {
                    throw new IOException("Wrong OID for pSpecified");
                }
                object2 = new DerInputStream(((AlgorithmId)object2).getEncodedParams());
                this.c = ((DerInputStream)object2).getOctetString();
                if (((DerInputStream)object2).available() != 0) {
                    throw new IOException("Extra data for pSpecified");
                }
            }
            ++n2;
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string2) throws IOException {
        if (string2 != null && !string2.equalsIgnoreCase("ASN.1")) {
            throw new IllegalArgumentException("Only support ASN.1 format");
        }
        this.engineInit(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MD: " + this.a + "\n");
        stringBuffer.append("MGF: MGF1" + this.b.getDigestAlgorithm() + "\n");
        StringBuilder stringBuilder = new StringBuilder().append("PSource: PSpecified ");
        String string2 = this.c.length == 0 ? "" : Debug.toHexString(new BigInteger(this.c));
        stringBuffer.append(stringBuilder.append(string2).append("\n").toString());
        return stringBuffer.toString();
    }
}

