/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class KeyGeneratorCore {
    private final String a;
    private final int b;
    private int c;
    private SecureRandom d;

    KeyGeneratorCore(String string2, int n2) {
        this.a = string2;
        this.b = n2;
        this.a(null);
    }

    SecretKey a() {
        if (this.d == null) {
            this.d = SunJCE.h;
        }
        byte[] byArray = new byte[this.c + 7 >> 3];
        this.d.nextBytes(byArray);
        return new SecretKeySpec(byArray, this.a);
    }

    void a(int n2, SecureRandom secureRandom) {
        if (n2 < 40) {
            throw new InvalidParameterException("Key length must be at least 40 bits");
        }
        this.c = n2;
        this.d = secureRandom;
    }

    void a(SecureRandom secureRandom) {
        this.c = this.b;
        this.d = secureRandom;
    }

    void a(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(this.a + " key generation does not take any parameters");
    }

    public static final class ARCFOURKeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore a;

        public ARCFOURKeyGenerator() {
            SunJCE.a(this.getClass());
            this.a = new KeyGeneratorCore("ARCFOUR", 128);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.a.a();
        }

        @Override
        protected void engineInit(int n2, SecureRandom secureRandom) {
            if (n2 < 40 || n2 > 1024) {
                throw new InvalidParameterException("Key length for ARCFOUR must be between 40 and 1024 bits");
            }
            this.a.a(n2, secureRandom);
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
            this.a.a(secureRandom);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.a.a(algorithmParameterSpec, secureRandom);
        }
    }

    public static final class HmacSHA256KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore a;

        public HmacSHA256KG() {
            SunJCE.a(this.getClass());
            this.a = new KeyGeneratorCore("HmacSHA256", 256);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.a.a();
        }

        @Override
        protected void engineInit(int n2, SecureRandom secureRandom) {
            this.a.a(n2, secureRandom);
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
            this.a.a(secureRandom);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.a.a(algorithmParameterSpec, secureRandom);
        }
    }

    public static final class HmacSHA384KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore a;

        public HmacSHA384KG() {
            SunJCE.a(this.getClass());
            this.a = new KeyGeneratorCore("HmacSHA384", 384);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.a.a();
        }

        @Override
        protected void engineInit(int n2, SecureRandom secureRandom) {
            this.a.a(n2, secureRandom);
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
            this.a.a(secureRandom);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.a.a(algorithmParameterSpec, secureRandom);
        }
    }

    public static final class HmacSHA512KG
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore a;

        public HmacSHA512KG() {
            SunJCE.a(this.getClass());
            this.a = new KeyGeneratorCore("HmacSHA512", 512);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.a.a();
        }

        @Override
        protected void engineInit(int n2, SecureRandom secureRandom) {
            this.a.a(n2, secureRandom);
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
            this.a.a(secureRandom);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.a.a(algorithmParameterSpec, secureRandom);
        }
    }

    public static final class RC2KeyGenerator
    extends KeyGeneratorSpi {
        private final KeyGeneratorCore a;

        public RC2KeyGenerator() {
            SunJCE.a(this.getClass());
            this.a = new KeyGeneratorCore("RC2", 128);
        }

        @Override
        protected SecretKey engineGenerateKey() {
            return this.a.a();
        }

        @Override
        protected void engineInit(int n2, SecureRandom secureRandom) {
            if (n2 < 40 || n2 > 1024) {
                throw new InvalidParameterException("Key length for RC2 must be between 40 and 1024 bits");
            }
            this.a.a(n2, secureRandom);
        }

        @Override
        protected void engineInit(SecureRandom secureRandom) {
            this.a.a(secureRandom);
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            this.a.a(algorithmParameterSpec, secureRandom);
        }
    }
}

