/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.nio.ByteBuffer;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;

final class HmacCore
implements Cloneable {
    private final MessageDigest a;
    private final byte[] b;
    private final byte[] c;
    private boolean d;
    private final int e;

    private HmacCore(HmacCore hmacCore) throws CloneNotSupportedException {
        this.a = (MessageDigest)hmacCore.a.clone();
        this.e = hmacCore.e;
        this.b = (byte[])hmacCore.b.clone();
        this.c = (byte[])hmacCore.c.clone();
        this.d = hmacCore.d;
    }

    HmacCore(String string2, int n2) throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance(string2), n2);
    }

    HmacCore(MessageDigest messageDigest, int n2) {
        this.a = messageDigest;
        this.e = n2;
        this.b = new byte[this.e];
        this.c = new byte[this.e];
        this.d = true;
    }

    int a() {
        return this.a.getDigestLength();
    }

    void a(byte by) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(by);
    }

    void a(ByteBuffer byteBuffer) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(byteBuffer);
    }

    /*
     * Enabled aggressive block sorting
     */
    void a(Key object, AlgorithmParameterSpec object2) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (object2 != null) {
            throw new InvalidAlgorithmParameterException("HMAC does not use parameters");
        }
        if (!(object instanceof SecretKey)) {
            throw new InvalidKeyException("Secret key expected");
        }
        if ((object = (Object)object.getEncoded()) == null || ((Object)object).length == 0) {
            throw new InvalidKeyException("Missing key data");
        }
        if (((Object)object).length > this.e) {
            object2 = this.a.digest((byte[])object);
            Arrays.fill((byte[])object, (byte)0);
            object = object2;
        }
        int n2 = 0;
        while (true) {
            if (n2 >= this.e) {
                Arrays.fill((byte[])object, (byte)0);
                this.c();
                return;
            }
            Object object3 = n2 < ((Object)object).length ? object[n2] : false;
            this.b[n2] = (byte)(object3 ^ 0x36);
            this.c[n2] = (byte)(object3 ^ 0x5C);
            ++n2;
        }
    }

    void a(byte[] byArray, int n2, int n3) {
        if (this.d) {
            this.a.update(this.b);
            this.d = false;
        }
        this.a.update(byArray, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] b() {
        if (this.d) {
            this.a.update(this.b);
        } else {
            this.d = true;
        }
        try {
            byte[] byArray = this.a.digest();
            this.a.update(this.c);
            this.a.update(byArray);
            this.a.digest(byArray, 0, byArray.length);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new ProviderException(digestException);
        }
    }

    void c() {
        if (!this.d) {
            this.a.reset();
            this.d = true;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return new HmacCore(this);
    }

    public static final class HmacSHA256
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA256() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-256", 64);
        }

        private HmacSHA256(HmacSHA256 hmacSHA256) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA256.a.clone();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA256(this);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        @Override
        protected int engineGetMacLength() {
            return this.a.a();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        @Override
        protected void engineReset() {
            this.a.c();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.a.a(byArray, n2, n3);
        }
    }

    public static final class HmacSHA384
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA384() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-384", 128);
        }

        private HmacSHA384(HmacSHA384 hmacSHA384) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA384.a.clone();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA384(this);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        @Override
        protected int engineGetMacLength() {
            return this.a.a();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        @Override
        protected void engineReset() {
            this.a.c();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.a.a(byArray, n2, n3);
        }
    }

    public static final class HmacSHA512
    extends MacSpi
    implements Cloneable {
        private final HmacCore a;

        public HmacSHA512() throws NoSuchAlgorithmException {
            SunJCE.a(this.getClass());
            this.a = new HmacCore("SHA-512", 128);
        }

        private HmacSHA512(HmacSHA512 hmacSHA512) throws CloneNotSupportedException {
            this.a = (HmacCore)hmacSHA512.a.clone();
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return new HmacSHA512(this);
        }

        @Override
        protected byte[] engineDoFinal() {
            return this.a.b();
        }

        @Override
        protected int engineGetMacLength() {
            return this.a.a();
        }

        @Override
        protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
            this.a.a(key, algorithmParameterSpec);
        }

        @Override
        protected void engineReset() {
            this.a.c();
        }

        @Override
        protected void engineUpdate(byte by) {
            this.a.a(by);
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            this.a.a(byteBuffer);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n2, int n3) {
            this.a.a(byArray, n2, n3);
        }
    }
}

