/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    static final long serialVersionUID = 7647557958927458271L;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private byte[] encodedKey;
    private BigInteger g;
    private byte[] key;
    private int l;
    private BigInteger p;
    private BigInteger y;

    DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        this.y = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
            return;
        }
        catch (IOException iOException) {
            throw new ProviderException("Cannot produce ASN.1 encoding", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DHPublicKey(byte[] byArray) throws InvalidKeyException {
        Object object;
        Object object2 = new ByteArrayInputStream(byArray);
        try {
            object2 = new DerValue((InputStream)object2);
            if (((DerValue)object2).tag != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            object = ((DerValue)object2).data.getDerValue();
            if (((DerValue)object).tag != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            object = ((DerValue)object).toDerInputStream();
            if (((DerInputStream)object).getOID() == null) {
                throw new InvalidKeyException("Null OID");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidKeyException("Private-value length too big");
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Error parsing key encoding: " + iOException.toString());
        }
        if (((DerInputStream)object).available() == 0) {
            throw new InvalidKeyException("Parameters missing");
        }
        object = ((DerInputStream)object).getDerValue();
        if (((DerValue)object).tag == 5) {
            throw new InvalidKeyException("Null parameters");
        }
        if (((DerValue)object).tag != 48) {
            throw new InvalidKeyException("Parameters not a SEQUENCE");
        }
        ((DerValue)object).data.reset();
        this.p = ((DerValue)object).data.getBigInteger();
        this.g = ((DerValue)object).data.getBigInteger();
        if (((DerValue)object).data.available() != 0) {
            this.l = ((DerValue)object).data.getInteger();
        }
        if (((DerValue)object).data.available() != 0) {
            throw new InvalidKeyException("Extra parameter data");
        }
        this.key = ((DerValue)object2).data.getBitString();
        this.parseKeyBits();
        if (((DerValue)object2).data.available() != 0) {
            throw new InvalidKeyException("Excess key data");
        }
        this.encodedKey = (byte[])byArray.clone();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            this.y = new DerInputStream(this.key).getBigInteger();
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Error parsing key encoding: " + iOException.toString());
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PublicKey)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((PublicKey)object).getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] getEncoded() {
        synchronized (this) {
            Object object = this.encodedKey;
            if (object != null) return (byte[])this.encodedKey.clone();
            try {
                object = new DerOutputStream();
                object.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream derOutputStream = new DerOutputStream();
                derOutputStream.putInteger(this.p);
                derOutputStream.putInteger(this.g);
                if (this.l != 0) {
                    derOutputStream.putInteger(this.l);
                }
                object.putDerValue(new DerValue(48, derOutputStream.toByteArray()));
                derOutputStream = new DerOutputStream();
                derOutputStream.write((byte)48, (DerOutputStream)object);
                derOutputStream.putBitString(this.key);
                object = new DerOutputStream();
                object.write((byte)48, derOutputStream);
                this.encodedKey = ((ByteArrayOutputStream)object).toByteArray();
            }
            catch (IOException iOException) {
                return null;
            }
            return (byte[])this.encodedKey.clone();
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public String toString() {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Public Key:" + string2 + "y:" + string2 + Debug.toHexString(this.y) + string2 + "p:" + string2 + Debug.toHexString(this.p) + string2 + "g:" + string2 + Debug.toHexString(this.g));
        if (this.l != 0) {
            stringBuffer.append(string2 + "l:" + string2 + "    " + this.l);
        }
        return stringBuffer.toString();
    }
}

