/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

final class DHPrivateKey
implements PrivateKey,
javax.crypto.interfaces.DHPrivateKey,
Serializable {
    private static final BigInteger PKCS8_VERSION = BigInteger.ZERO;
    static final long serialVersionUID = 7565477590005668886L;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
    private byte[] encodedKey;
    private BigInteger g;
    private byte[] key;
    private int l;
    private BigInteger p;
    private BigInteger x;

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        this(bigInteger, bigInteger2, bigInteger3, 0);
    }

    DHPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n2) {
        this.x = bigInteger;
        this.p = bigInteger2;
        this.g = bigInteger3;
        this.l = n2;
        try {
            this.key = new DerValue(2, this.x.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
            return;
        }
        catch (IOException iOException) {
            throw new ProviderException("Cannot produce ASN.1 encoding", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DHPrivateKey(byte[] byArray) throws InvalidKeyException {
        Object object;
        Object object2 = new ByteArrayInputStream(byArray);
        try {
            object2 = new DerValue((InputStream)object2);
            if (((DerValue)object2).tag != 48) {
                throw new InvalidKeyException("Key not a SEQUENCE");
            }
            object = ((DerValue)object2).data.getBigInteger();
            if (!((BigInteger)object).equals(PKCS8_VERSION)) {
                throw new IOException("version mismatch: (supported: " + PKCS8_VERSION + ", parsed: " + object);
            }
            object = ((DerValue)object2).data.getDerValue();
            if (((DerValue)object).tag != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
        }
        catch (NumberFormatException numberFormatException) {
            object2 = new InvalidKeyException("Private-value length too big");
            ((Throwable)object2).initCause(numberFormatException);
            throw object2;
        }
        catch (IOException iOException) {
            object2 = new InvalidKeyException("Error parsing key encoding: " + iOException.getMessage());
            ((Throwable)object2).initCause(iOException);
            throw object2;
        }
        if (((DerInputStream)(object = ((DerValue)object).toDerInputStream())).getOID() == null) {
            throw new InvalidKeyException("Null OID");
        }
        if (((DerInputStream)object).available() == 0) {
            throw new InvalidKeyException("Parameters missing");
        }
        object = ((DerInputStream)object).getDerValue();
        if (((DerValue)object).tag == 5) {
            throw new InvalidKeyException("Null parameters");
        }
        if (((DerValue)object).tag != 48) {
            throw new InvalidKeyException("Parameters not a SEQUENCE");
        }
        ((DerValue)object).data.reset();
        this.p = ((DerValue)object).data.getBigInteger();
        this.g = ((DerValue)object).data.getBigInteger();
        if (((DerValue)object).data.available() != 0) {
            this.l = ((DerValue)object).data.getInteger();
        }
        if (((DerValue)object).data.available() != 0) {
            throw new InvalidKeyException("Extra parameter data");
        }
        this.key = ((DerValue)object2).data.getOctetString();
        this.parseKeyBits();
        this.encodedKey = (byte[])byArray.clone();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            this.x = new DerInputStream(this.key).getBigInteger();
            return;
        }
        catch (IOException iOException) {
            InvalidKeyException invalidKeyException = new InvalidKeyException("Error parsing key encoding: " + iOException.getMessage());
            invalidKeyException.initCause(iOException);
            throw invalidKeyException;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PRIVATE, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return Arrays.equals(this.getEncoded(), ((PrivateKey)object).getEncoded());
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getEncoded() {
        synchronized (this) {
            void var1_5;
            block6: {
                byte[] byArray = this.encodedKey;
                if (byArray == null) {
                    try {
                        DerOutputStream derOutputStream = new DerOutputStream();
                        derOutputStream.putInteger(PKCS8_VERSION);
                        DerOutputStream derOutputStream2 = new DerOutputStream();
                        derOutputStream2.putOID(new ObjectIdentifier(this.DH_data));
                        DerOutputStream derOutputStream3 = new DerOutputStream();
                        derOutputStream3.putInteger(this.p);
                        derOutputStream3.putInteger(this.g);
                        if (this.l != 0) {
                            derOutputStream3.putInteger(this.l);
                        }
                        derOutputStream2.putDerValue(new DerValue(48, derOutputStream3.toByteArray()));
                        derOutputStream.write((byte)48, derOutputStream2);
                        derOutputStream.putOctetString(this.key);
                        derOutputStream2 = new DerOutputStream();
                        derOutputStream2.write((byte)48, derOutputStream);
                        this.encodedKey = derOutputStream2.toByteArray();
                    }
                    catch (IOException iOException) {
                        Object var1_7 = null;
                        break block6;
                    }
                }
                byte[] byArray2 = (byte[])this.encodedKey.clone();
            }
            return var1_5;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    @Override
    public BigInteger getX() {
        return this.x;
    }

    public int hashCode() {
        int n2 = 0;
        byte[] byArray = this.getEncoded();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            n2 += byArray[i2] * i2;
        }
        return n2;
    }

    public String toString() {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Private Key:" + string2 + "x:" + string2 + Debug.toHexString(this.x) + string2 + "p:" + string2 + Debug.toHexString(this.p) + string2 + "g:" + string2 + Debug.toHexString(this.g));
        if (this.l != 0) {
            stringBuffer.append(string2 + "l:" + string2 + "    " + this.l);
        }
        return stringBuffer.toString();
    }
}

