/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public final class DHParameters
extends AlgorithmParametersSpi {
    private BigInteger a = BigInteger.ZERO;
    private BigInteger b = BigInteger.ZERO;
    private int c = 0;

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.a);
        derOutputStream2.putInteger(this.b);
        if (this.c > 0) {
            derOutputStream2.putInteger(this.c);
        }
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String string2) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (DHParameterSpec.class.isAssignableFrom(clazz)) {
            return new DHParameterSpec(this.a, this.b, this.c);
        }
        throw new InvalidParameterSpecException("Inappropriate parameter Specification");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.a = ((DHParameterSpec)algorithmParameterSpec).getP();
        this.b = ((DHParameterSpec)algorithmParameterSpec).getG();
        this.c = ((DHParameterSpec)algorithmParameterSpec).getL();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(byte[] object) throws IOException {
        try {
            object = new DerValue((byte[])object);
            if (object.tag != 48) {
                throw new IOException("DH params parsing error");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Private-value length too big");
        }
        {
            object.data.reset();
            this.a = object.data.getBigInteger();
            this.b = object.data.getBigInteger();
            if (object.data.available() != 0) {
                this.c = object.data.getInteger();
            }
            if (object.data.available() != 0) {
                throw new IOException("DH parameter parsing error: Extra data");
            }
            return;
        }
    }

    @Override
    protected void engineInit(byte[] byArray, String string2) throws IOException {
        this.engineInit(byArray);
    }

    @Override
    protected String engineToString() {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("SunJCE Diffie-Hellman Parameters:" + string2 + "p:" + string2 + Debug.toHexString(this.a) + string2 + "g:" + string2 + Debug.toHexString(this.b));
        if (this.c != 0) {
            stringBuffer.append(string2 + "l:" + string2 + "    " + this.c);
        }
        return stringBuffer.toString();
    }
}

