/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public final class DHParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int a = 1024;
    private int b = 0;
    private SecureRandom c = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        if (this.b == 0) {
            this.b = this.a - 1;
        }
        if (this.c == null) {
            this.c = SunJCE.h;
        }
        try {
            Object object = AlgorithmParameterGenerator.getInstance("DSA");
            ((AlgorithmParameterGenerator)object).init(this.a, this.c);
            object = ((AlgorithmParameterGenerator)object).generateParameters().getParameterSpec(DSAParameterSpec.class);
            object = this.b > 0 ? new DHParameterSpec(((DSAParameterSpec)object).getP(), ((DSAParameterSpec)object).getG(), this.b) : new DHParameterSpec(((DSAParameterSpec)object).getP(), ((DSAParameterSpec)object).getG());
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DH", "SunJCE");
            algorithmParameters.init((AlgorithmParameterSpec)object);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException.getMessage());
        }
    }

    @Override
    protected void engineInit(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 1024 || n2 % 64 != 0) {
            throw new InvalidParameterException("Keysize must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.a = n2;
        this.c = secureRandom;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
        }
        algorithmParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
        this.a = ((DHGenParameterSpec)algorithmParameterSpec).getPrimeSize();
        if (this.a < 512 || this.a > 1024 || this.a % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Modulus size must be multiple of 64, and can only range from 512 to 1024 (inclusive)");
        }
        this.b = ((DHGenParameterSpec)algorithmParameterSpec).getExponentSize();
        if (this.b <= 0) {
            throw new InvalidAlgorithmParameterException("Exponent size must be greater than zero");
        }
        if (this.b >= this.a) {
            throw new InvalidAlgorithmParameterException("Exponent size must be less than modulus size");
        }
    }
}

