/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DHPrivateKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;

public final class DHKeyFactory
extends KeyFactorySpi {
    public DHKeyFactory() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec object) throws InvalidKeySpecException {
        try {
            if (object instanceof DHPrivateKeySpec) {
                object = (DHPrivateKeySpec)object;
                return new DHPrivateKey(((DHPrivateKeySpec)object).getX(), ((DHPrivateKeySpec)object).getP(), ((DHPrivateKeySpec)object).getG());
            }
            if (!(object instanceof PKCS8EncodedKeySpec)) throw new InvalidKeySpecException("Inappropriate key specification");
            return new DHPrivateKey(((PKCS8EncodedKeySpec)object).getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected PublicKey engineGeneratePublic(KeySpec object) throws InvalidKeySpecException {
        try {
            if (object instanceof DHPublicKeySpec) {
                object = (DHPublicKeySpec)object;
                return new DHPublicKey(((DHPublicKeySpec)object).getY(), ((DHPublicKeySpec)object).getP(), ((DHPublicKeySpec)object).getG());
            }
            if (!(object instanceof X509EncodedKeySpec)) throw new InvalidKeySpecException("Inappropriate key specification");
            return new DHPublicKey(((X509EncodedKeySpec)object).getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class object) throws InvalidKeySpecException {
        if (key instanceof javax.crypto.interfaces.DHPublicKey) {
            if (DHPublicKeySpec.class.isAssignableFrom((Class<?>)object)) {
                key = (javax.crypto.interfaces.DHPublicKey)key;
                object = key.getParams();
                return new DHPublicKeySpec(key.getY(), ((DHParameterSpec)object).getP(), ((DHParameterSpec)object).getG());
            }
            if (X509EncodedKeySpec.class.isAssignableFrom((Class<?>)object)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        if (key instanceof javax.crypto.interfaces.DHPrivateKey) {
            if (DHPrivateKeySpec.class.isAssignableFrom((Class<?>)object)) {
                key = (javax.crypto.interfaces.DHPrivateKey)key;
                object = key.getParams();
                return new DHPrivateKeySpec(key.getX(), ((DHParameterSpec)object).getP(), ((DHParameterSpec)object).getG());
            }
            if (PKCS8EncodedKeySpec.class.isAssignableFrom((Class<?>)object)) {
                return new PKCS8EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        throw new InvalidKeySpecException("Inappropriate key type");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof javax.crypto.interfaces.DHPublicKey) {
                if (!(key instanceof DHPublicKey)) return this.engineGeneratePublic((DHPublicKeySpec)this.engineGetKeySpec(key, DHPublicKeySpec.class));
                return key;
            }
            if (!(key instanceof javax.crypto.interfaces.DHPrivateKey)) throw new InvalidKeyException("Wrong algorithm type");
            if (key instanceof DHPrivateKey) return key;
            return this.engineGeneratePrivate((DHPrivateKeySpec)this.engineGetKeySpec(key, DHPrivateKeySpec.class));
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

