/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKey;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.DHPublicKey;
import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_d;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class DHKeyAgreement
extends KeyAgreementSpi {
    private boolean a = false;
    private BigInteger b = null;
    private BigInteger c = null;
    private BigInteger d = BigInteger.ZERO;
    private BigInteger e = BigInteger.ZERO;

    public DHKeyAgreement() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof javax.crypto.interfaces.DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        key = (javax.crypto.interfaces.DHPublicKey)key;
        if (this.b == null || this.c == null) {
            throw new IllegalStateException("Not initialized");
        }
        BigInteger bigInteger = key.getParams().getP();
        BigInteger bigInteger2 = key.getParams().getG();
        if (bigInteger != null && !this.b.equals(bigInteger)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (bigInteger2 != null && !this.c.equals(bigInteger2)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        this.e = key.getY();
        this.a = true;
        if (!bl) {
            return new DHPublicKey(new BigInteger(1, this.engineGenerateSecret()), this.b, this.c);
        }
        return null;
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (!this.a) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        if (byArray == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        BigInteger bigInteger = this.b;
        byte[] byArray2 = this.e.modPow(this.d, bigInteger).toByteArray();
        if (byArray2.length << 3 != bigInteger.bitLength()) {
            if (byArray.length - n2 < byArray2.length - 1) {
                throw new ShortBufferException("Buffer too short for shared secret");
            }
            System.arraycopy(byArray2, 1, byArray, n2, byArray2.length - 1);
            this.a = false;
            return byArray2.length - 1;
        }
        if (byArray.length - n2 < byArray2.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        this.a = false;
        return byArray2.length;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected SecretKey engineGenerateSecret(String object) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        int n2;
        void var5_5;
        int n3 = 56;
        if (object == null) {
            throw new NoSuchAlgorithmException("null algorithm");
        }
        byte[] byArray = this.engineGenerateSecret();
        if (((String)object).equalsIgnoreCase("DES")) {
            DESKey dESKey = new DESKey(byArray);
            return var5_5;
        }
        if (((String)object).equalsIgnoreCase("DESede")) return new DESedeKey(byArray);
        if (((String)object).equalsIgnoreCase("TripleDES")) {
            return new DESedeKey(byArray);
        }
        if (((String)object).equalsIgnoreCase("Blowfish")) {
            n2 = byArray.length;
            if (n2 >= 56) {
                return new SecretKeySpec(byArray, 0, n3, "Blowfish");
            }
        } else {
            if (!((String)object).equalsIgnoreCase("AES")) {
                if (!((String)object).equals("TlsPremasterSecret")) throw new NoSuchAlgorithmException("Unsupported secret key algorithm: " + (String)object);
                return new SecretKeySpec(byArray, "TlsPremasterSecret");
            }
            int n4 = byArray.length;
            n3 = SunJCE_d.b.length;
            object = null;
            --n3;
            while (object == null && n3 >= 0) {
                int n5 = n4;
                if (n4 >= SunJCE_d.b[n3]) {
                    n5 = SunJCE_d.b[n3];
                    object = new SecretKeySpec(byArray, 0, n5, "AES");
                }
                --n3;
                n4 = n5;
            }
            Object object2 = object;
            if (object != null) return var5_5;
            throw new InvalidKeyException("Key material is too short");
        }
        n3 = n2;
        return new SecretKeySpec(byArray, 0, n3, "Blowfish");
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.a) {
            throw new IllegalStateException("Key agreement has not been completed yet");
        }
        this.a = false;
        Object object = this.b;
        Object object2 = this.e.modPow(this.d, (BigInteger)object);
        object = ((BigInteger)object2).toByteArray();
        if (((BigInteger)object2).bitLength() % 8 == 0) {
            object2 = new byte[((Object)object).length - 1];
            System.arraycopy(object, 1, object2, 0, ((Object)object2).length);
            return object2;
        }
        return object;
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(key, null, secureRandom);
            return;
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            return;
        }
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec object, SecureRandom serializable) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a = false;
        this.b = null;
        this.c = null;
        if (object != null && !(object instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Diffie-Hellman parameters expected");
        }
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Diffie-Hellman private key expected");
        }
        key = (DHPrivateKey)key;
        if (object != null) {
            this.b = ((DHParameterSpec)object).getP();
            this.c = ((DHParameterSpec)object).getG();
        }
        object = key.getParams().getP();
        serializable = key.getParams().getG();
        if (this.b != null && object != null && !this.b.equals(object)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.c != null && serializable != null && !this.c.equals(serializable)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (this.b == null && object == null || this.c == null && serializable == null) {
            throw new InvalidKeyException("Missing parameters");
        }
        this.b = object;
        this.c = serializable;
        this.d = key.getX();
    }
}

