/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.SunJCE;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESedeKeySpec;

public final class DESedeKeyFactory
extends SecretKeyFactorySpi {
    public DESedeKeyFactory() {
        if (!SunJCE.b(this.getClass())) {
            throw new SecurityException("The SunJCE provider may have been tampered.");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof DESedeKeySpec) {
                return new DESedeKey(((DESedeKeySpec)keySpec).getKey());
            }
            throw new InvalidKeySpecException("Inappropriate key specification");
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        try {
            if (!(secretKey instanceof SecretKey) || !secretKey.getAlgorithm().equalsIgnoreCase("DESede") || !secretKey.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeySpecException("Inappropriate key format/algorithm");
            if (!DESedeKeySpec.class.isAssignableFrom(clazz)) throw new InvalidKeySpecException("Inappropriate key specification");
            return new DESedeKeySpec(secretKey.getEncoded());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        block3: {
            if (secretKey == null) throw new InvalidKeyException("Inappropriate key format/algorithm");
            try {
                if (!secretKey.getAlgorithm().equalsIgnoreCase("DESede") || !secretKey.getFormat().equalsIgnoreCase("RAW")) throw new InvalidKeyException("Inappropriate key format/algorithm");
                if (!(secretKey instanceof DESedeKey)) break block3;
                return secretKey;
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Cannot translate key");
            }
        }
        return this.engineGenerateSecret((DESedeKeySpec)this.engineGetKeySpec(secretKey, (Class)DESedeKeySpec.class));
    }
}

