/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESKeyGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.util.Arrays;
import javax.crypto.SecretKey;

final class DESedeKey
implements SecretKey {
    static final long serialVersionUID = 2463986565756745178L;
    private byte[] key;

    DESedeKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    DESedeKey(byte[] byArray, int n2) throws InvalidKeyException {
        if (byArray == null || byArray.length - n2 < 24) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[24];
        System.arraycopy(byArray, n2, this.key, 0, 24);
        DESKeyGenerator.a(this.key, 0);
        DESKeyGenerator.a(this.key, 8);
        DESKeyGenerator.a(this.key, 16);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.key = (byte[])this.key.clone();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string2 = ((SecretKey)object).getAlgorithm();
        if (!string2.equalsIgnoreCase("DESede") && !string2.equalsIgnoreCase("TripleDES")) {
            return false;
        }
        object = ((SecretKey)object).getEncoded();
        boolean bl = Arrays.equals(this.key, (byte[])object);
        Arrays.fill((byte[])object, (byte)0);
        return bl;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.key != null) {
                Arrays.fill(this.key, (byte)0);
                this.key = null;
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String getAlgorithm() {
        return "DESede";
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 1; i2 < this.key.length; ++i2) {
            n2 += this.key[i2] * i2;
        }
        return "desede".hashCode() ^ n2;
    }
}

