/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DigestChallenge;
import com.novell.sasl.client.ResponseAuth;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.RealmCallback;
import org.apache.harmony.javax.security.sasl.RealmChoiceCallback;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;

public class DigestMD5SaslClient
implements SaslClient {
    private static final String DIGEST_METHOD = "AUTHENTICATE";
    private static final int NONCE_BYTE_COUNT = 32;
    private static final int NONCE_HEX_COUNT = 64;
    private static final int STATE_DIGEST_RESPONSE_SENT = 1;
    private static final int STATE_DISPOSED = 4;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_INVALID_SERVER_RESPONSE = 3;
    private static final int STATE_VALID_SERVER_RESPONSE = 2;
    private char[] m_HA1 = null;
    private String m_authorizationId = "";
    private CallbackHandler m_cbh;
    private String m_clientNonce = "";
    private DigestChallenge m_dc;
    private String m_digestURI;
    private String m_name = "";
    private Map m_props;
    private String m_protocol = "";
    private String m_qopValue = "";
    private String m_realm = "";
    private String m_serverName = "";
    private int m_state;

    private DigestMD5SaslClient(String string2, String string3, String string4, Map map, CallbackHandler callbackHandler) {
        this.m_authorizationId = string2;
        this.m_protocol = string3;
        this.m_serverName = string4;
        this.m_props = map;
        this.m_cbh = callbackHandler;
        this.m_state = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createDigestResponse(byte[] objectArray) throws SaslException {
        Callback[] callbackArray;
        StringBuffer stringBuffer;
        block8: {
            block7: {
                stringBuffer = new StringBuffer(512);
                this.m_dc = new DigestChallenge((byte[])objectArray);
                this.m_digestURI = String.valueOf(this.m_protocol) + "/" + this.m_serverName;
                if ((this.m_dc.getQop() & 1) != 1) {
                    throw new SaslException("Client only supports qop of 'auth'");
                }
                this.m_qopValue = "auth";
                Object object = this.m_dc.getRealms();
                int n2 = ((ArrayList)object).size();
                callbackArray = new Callback[]{n2 == 0 ? new RealmCallback("Realm") : (n2 == 1 ? new RealmCallback("Realm", (String)((ArrayList)object).get(0)) : new RealmChoiceCallback("Realm", ((ArrayList)object).toArray(new String[n2]), 0, false)), new PasswordCallback("Password", false), this.m_authorizationId == null || this.m_authorizationId.length() == 0 ? new NameCallback("Name") : new NameCallback("Name", this.m_authorizationId)};
                try {
                    this.m_cbh.handle(callbackArray);
                    if (n2 <= 1) break block7;
                }
                catch (UnsupportedCallbackException unsupportedCallbackException) {
                    throw new SaslException("Handler does not support necessary callbacks", unsupportedCallbackException);
                }
                catch (IOException iOException) {
                    throw new SaslException("IO exception in CallbackHandler.", iOException);
                }
                object = ((RealmChoiceCallback)callbackArray[0]).getSelectedIndexes();
                this.m_realm = ((Object)object).length > 0 ? ((RealmChoiceCallback)callbackArray[0]).getChoices()[object[0]] : ((RealmChoiceCallback)callbackArray[0]).getChoices()[0];
                break block8;
            }
            this.m_realm = ((RealmCallback)callbackArray[0]).getText();
        }
        this.m_clientNonce = this.getClientNonce();
        this.m_name = ((NameCallback)callbackArray[2]).getName();
        if (this.m_name == null) {
            this.m_name = ((NameCallback)callbackArray[2]).getDefaultName();
        }
        if (this.m_name == null) {
            throw new SaslException("No user name was specified.");
        }
        this.m_HA1 = this.DigestCalcHA1(this.m_dc.getAlgorithm(), this.m_name, this.m_realm, new String(((PasswordCallback)callbackArray[1]).getPassword()), this.m_dc.getNonce(), this.m_clientNonce);
        char[] cArray = this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, true);
        stringBuffer.append("username=\"");
        stringBuffer.append(this.m_authorizationId);
        if (this.m_realm.length() != 0) {
            stringBuffer.append("\",realm=\"");
            stringBuffer.append(this.m_realm);
        }
        stringBuffer.append("\",cnonce=\"");
        stringBuffer.append(this.m_clientNonce);
        stringBuffer.append("\",nc=");
        stringBuffer.append("00000001");
        stringBuffer.append(",qop=");
        stringBuffer.append(this.m_qopValue);
        stringBuffer.append(",digest-uri=\"");
        stringBuffer.append(this.m_digestURI);
        stringBuffer.append("\",response=");
        stringBuffer.append(cArray);
        stringBuffer.append(",charset=utf-8,nonce=\"");
        stringBuffer.append(this.m_dc.getNonce());
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static SaslClient getClient(String string2, String string3, String string4, Map map, CallbackHandler callbackHandler) {
        String string5 = (String)map.get("javax.security.sasl.qop");
        String string6 = (String)map.get("javax.security.sasl.strength");
        string6 = (String)map.get("javax.security.sasl.server.authentication");
        if (string5 != null && !"auth".equals(string5) || string6 != null && !"false".equals(string6) || callbackHandler == null) {
            return null;
        }
        return new DigestMD5SaslClient(string2, string3, string4, map, callbackHandler);
    }

    private static char getHexChar(byte by) {
        switch (by) {
            default: {
                return 'Z';
            }
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: 
        }
        return 'f';
    }

    char[] DigestCalcHA1(String string2, String object, String object2, String string3, String string4, String string5) throws SaslException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.update(((String)object).getBytes("UTF-8"));
        messageDigest.update(":".getBytes("UTF-8"));
        messageDigest.update(((String)object2).getBytes("UTF-8"));
        messageDigest.update(":".getBytes("UTF-8"));
        messageDigest.update(string3.getBytes("UTF-8"));
        object = object2 = (Object)messageDigest.digest();
        try {
            if ("md5-sess".equals(string2)) {
                messageDigest.update((byte[])object2);
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string4.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(string5.getBytes("UTF-8"));
                object = messageDigest.digest();
            }
            return this.convertToHex((byte[])object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No provider found for MD5 hash", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("UTF-8 encoding not supported by platform.", unsupportedEncodingException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    char[] DigestCalcResponse(char[] objectArray, String string2, String string3, String string4, String string5, String object, String string6, boolean bl) throws SaslException {
        try {
            void var2_5;
            void var5_8;
            void var7_10;
            char[] cArray;
            void var8_11;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (var8_11 != false) {
                messageDigest.update(cArray.getBytes("UTF-8"));
            }
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(var7_10.getBytes("UTF-8"));
            if ("auth-int".equals(var5_8)) {
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update("00000000000000000000000000000000".getBytes("UTF-8"));
            }
            cArray = this.convertToHex(messageDigest.digest());
            messageDigest.update(new String((char[])objectArray).getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            messageDigest.update(var2_5.getBytes("UTF-8"));
            messageDigest.update(":".getBytes("UTF-8"));
            if (var5_8.length() > 0) {
                void var4_7;
                void var3_6;
                messageDigest.update(var3_6.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(var4_7.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
                messageDigest.update(var5_8.getBytes("UTF-8"));
                messageDigest.update(":".getBytes("UTF-8"));
            }
            messageDigest.update(new String(cArray).getBytes("UTF-8"));
            byte[] byArray = messageDigest.digest();
            return this.convertToHex(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No provider found for MD5 hash", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("UTF-8 encoding not supported by platform.", unsupportedEncodingException);
        }
    }

    boolean checkServerResponseAuth(byte[] object) throws SaslException {
        object = new ResponseAuth((byte[])object);
        return new String(this.DigestCalcResponse(this.m_HA1, this.m_dc.getNonce(), "00000001", this.m_clientNonce, this.m_qopValue, DIGEST_METHOD, this.m_digestURI, false)).equals(((ResponseAuth)object).getResponseValue());
    }

    char[] convertToHex(byte[] byArray) {
        char[] cArray = new char[32];
        int n2 = 0;
        while (n2 < 16) {
            cArray[n2 * 2] = DigestMD5SaslClient.getHexChar((byte)((byArray[n2] & 0xF0) >> 4));
            cArray[n2 * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)(byArray[n2] & 0xF));
            ++n2;
        }
        return cArray;
    }

    @Override
    public void dispose() throws SaslException {
        if (this.m_state != 4) {
            this.m_state = 4;
        }
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        byte[] byArray2 = null;
        switch (this.m_state) {
            default: {
                throw new SaslException("Unknown client state.");
            }
            case 0: {
                if (byArray.length == 0) {
                    throw new SaslException("response = byte[0]");
                }
                try {
                    byArray = this.createDigestResponse(byArray).getBytes("UTF-8");
                    this.m_state = 1;
                    return byArray;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SaslException("UTF-8 encoding not suppported by platform", unsupportedEncodingException);
                }
            }
            case 1: {
                if (this.checkServerResponseAuth(byArray)) {
                    this.m_state = 2;
                    return byArray2;
                }
                this.m_state = 3;
                throw new SaslException("Could not validate response-auth value from server");
            }
            case 2: 
            case 3: {
                throw new SaslException("Authentication sequence is complete");
            }
            case 4: 
        }
        throw new SaslException("Client has been disposed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getClientNonce() throws SaslException {
        byte[] byArray = new byte[32];
        char[] cArray = new char[64];
        try {
            SecureRandom.getInstance("SHA1PRNG").nextBytes(byArray);
            int n2 = 0;
            while (true) {
                if (n2 >= 32) {
                    return new String(cArray);
                }
                cArray[n2 * 2] = DigestMD5SaslClient.getHexChar((byte)(byArray[n2] & 0xF));
                cArray[n2 * 2 + 1] = DigestMD5SaslClient.getHexChar((byte)((byArray[n2] & 0xF0) >> 4));
                ++n2;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("No random number generator available", noSuchAlgorithmException);
        }
    }

    @Override
    public String getMechanismName() {
        return "DIGEST-MD5";
    }

    @Override
    public Object getNegotiatedProperty(String string2) {
        if (this.m_state != 2) {
            throw new IllegalStateException("getNegotiatedProperty: authentication exchange not complete.");
        }
        if ("javax.security.sasl.qop".equals(string2)) {
            return "auth";
        }
        return null;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public boolean isComplete() {
        return this.m_state == 2 || this.m_state == 3 || this.m_state == 4;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws SaslException {
        throw new IllegalStateException("unwrap: QOP has neither integrity nor privacy>");
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) throws SaslException {
        throw new IllegalStateException("wrap: QOP has neither integrity nor privacy>");
    }
}

