/*
 * Decompiled with CFR 0.152.
 */
package com.novell.sasl.client;

import com.novell.sasl.client.DirectiveList;
import com.novell.sasl.client.ParsedDirective;
import com.novell.sasl.client.TokenParser;
import java.util.ArrayList;
import org.apache.harmony.javax.security.sasl.SaslException;

class DigestChallenge {
    private static final int CIPHER_3DES = 1;
    private static final int CIPHER_DES = 2;
    private static final int CIPHER_RC4 = 8;
    private static final int CIPHER_RC4_40 = 4;
    private static final int CIPHER_RC4_56 = 16;
    private static final int CIPHER_RECOGNIZED_MASK = 31;
    private static final int CIPHER_UNRECOGNIZED = 32;
    public static final int QOP_AUTH = 1;
    public static final int QOP_AUTH_CONF = 4;
    public static final int QOP_AUTH_INT = 2;
    public static final int QOP_UNRECOGNIZED = 8;
    private String m_algorithm = null;
    private String m_characterSet = null;
    private int m_cipherOptions = 0;
    private int m_maxBuf = -1;
    private String m_nonce = null;
    private int m_qop = 0;
    private ArrayList m_realms = new ArrayList(5);
    private boolean m_staleFlag = false;

    DigestChallenge(byte[] object) throws SaslException {
        object = new DirectiveList((byte[])object);
        try {
            ((DirectiveList)object).parseDirectives();
            this.checkSemantics((DirectiveList)object);
            return;
        }
        catch (SaslException saslException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkSemantics(DirectiveList object) throws SaslException {
        object = ((DirectiveList)object).getIterator();
        while (true) {
            if (!object.hasNext()) {
                if (-1 == this.m_maxBuf) {
                    this.m_maxBuf = 65536;
                }
                if (this.m_qop != 0) break;
                this.m_qop = 1;
                return;
            }
            ParsedDirective parsedDirective = (ParsedDirective)object.next();
            String string2 = parsedDirective.getName();
            if (string2.equals("realm")) {
                this.handleRealm(parsedDirective);
                continue;
            }
            if (string2.equals("nonce")) {
                this.handleNonce(parsedDirective);
                continue;
            }
            if (string2.equals("qop")) {
                this.handleQop(parsedDirective);
                continue;
            }
            if (string2.equals("maxbuf")) {
                this.handleMaxbuf(parsedDirective);
                continue;
            }
            if (string2.equals("charset")) {
                this.handleCharset(parsedDirective);
                continue;
            }
            if (string2.equals("algorithm")) {
                this.handleAlgorithm(parsedDirective);
                continue;
            }
            if (string2.equals("cipher")) {
                this.handleCipher(parsedDirective);
                continue;
            }
            if (!string2.equals("stale")) continue;
            this.handleStale(parsedDirective);
        }
        if ((this.m_qop & 1) != 1) {
            throw new SaslException("Only qop-auth is supported by client");
        }
        if ((this.m_qop & 4) == 4 && (this.m_cipherOptions & 0x1F) == 0) {
            throw new SaslException("Invalid cipher options");
        }
        if (this.m_nonce == null) {
            throw new SaslException("Missing nonce directive");
        }
        if (this.m_staleFlag) {
            throw new SaslException("Unexpected stale flag");
        }
        if (this.m_algorithm != null) return;
        throw new SaslException("Missing algorithm directive");
    }

    public String getAlgorithm() {
        return this.m_algorithm;
    }

    public String getCharacterSet() {
        return this.m_characterSet;
    }

    public int getCipherOptions() {
        return this.m_cipherOptions;
    }

    public int getMaxBuf() {
        return this.m_maxBuf;
    }

    public String getNonce() {
        return this.m_nonce;
    }

    public int getQop() {
        return this.m_qop;
    }

    public ArrayList getRealms() {
        return this.m_realms;
    }

    public boolean getStaleFlag() {
        return this.m_staleFlag;
    }

    void handleAlgorithm(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_algorithm != null) {
            throw new SaslException("Too many algorithm directives.");
        }
        this.m_algorithm = parsedDirective.getValue();
        if (!"md5-sess".equals(this.m_algorithm)) {
            throw new SaslException("Invalid algorithm directive value: " + this.m_algorithm);
        }
    }

    void handleCharset(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_characterSet != null) {
            throw new SaslException("Too many charset directives.");
        }
        this.m_characterSet = parsedDirective.getValue();
        if (!this.m_characterSet.equals("utf-8")) {
            throw new SaslException("Invalid character encoding directive");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleCipher(ParsedDirective object) throws SaslException {
        if (this.m_cipherOptions != 0) {
            throw new SaslException("Too many cipher directives.");
        }
        TokenParser tokenParser = new TokenParser(((ParsedDirective)object).getValue());
        tokenParser.parseToken();
        object = tokenParser.parseToken();
        while (true) {
            if (object == null) {
                if (this.m_cipherOptions == 0) {
                    this.m_cipherOptions = 32;
                }
                return;
            }
            this.m_cipherOptions = "3des".equals(object) ? (this.m_cipherOptions |= 1) : ("des".equals(object) ? (this.m_cipherOptions |= 2) : ("rc4-40".equals(object) ? (this.m_cipherOptions |= 4) : ("rc4".equals(object) ? (this.m_cipherOptions |= 8) : ("rc4-56".equals(object) ? (this.m_cipherOptions |= 0x10) : (this.m_cipherOptions |= 0x20)))));
            object = tokenParser.parseToken();
        }
    }

    void handleMaxbuf(ParsedDirective parsedDirective) throws SaslException {
        if (-1 != this.m_maxBuf) {
            throw new SaslException("Too many maxBuf directives.");
        }
        this.m_maxBuf = Integer.parseInt(parsedDirective.getValue());
        if (this.m_maxBuf == 0) {
            throw new SaslException("Max buf value must be greater than zero.");
        }
    }

    void handleNonce(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_nonce != null) {
            throw new SaslException("Too many nonce values.");
        }
        this.m_nonce = parsedDirective.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    void handleQop(ParsedDirective object) throws SaslException {
        if (this.m_qop != 0) {
            throw new SaslException("Too many qop directives.");
        }
        TokenParser tokenParser = new TokenParser(((ParsedDirective)object).getValue());
        object = tokenParser.parseToken();
        while (object != null) {
            this.m_qop = ((String)object).equals("auth") ? (this.m_qop |= 1) : (((String)object).equals("auth-int") ? (this.m_qop |= 2) : (((String)object).equals("auth-conf") ? (this.m_qop |= 4) : (this.m_qop |= 8)));
            object = tokenParser.parseToken();
        }
        return;
    }

    void handleRealm(ParsedDirective parsedDirective) {
        this.m_realms.add(parsedDirective.getValue());
    }

    void handleStale(ParsedDirective parsedDirective) throws SaslException {
        if (this.m_staleFlag) {
            throw new SaslException("Too many stale directives.");
        }
        if ("true".equals(parsedDirective.getValue())) {
            this.m_staleFlag = true;
            return;
        }
        throw new SaslException("Invalid stale directive value: " + parsedDirective.getValue());
    }
}

