/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.content.Context;
import android.os.Environment;
import com.nostra13.universalimageloader.utils.L;
import java.io.File;
import java.io.IOException;

public final class StorageUtils {
    private static final String EXTERNAL_STORAGE_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    private static final String INDIVIDUAL_DIR_NAME = "uil-images";

    private StorageUtils() {
    }

    public static File getCacheDirectory(Context context) {
        return StorageUtils.getCacheDirectory(context, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getCacheDirectory(Context object, boolean bl) {
        Object object2;
        String string2 = null;
        try {
            object2 = Environment.getExternalStorageState();
        }
        catch (NullPointerException nullPointerException) {
            object2 = "";
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            object2 = "";
        }
        Object object3 = string2;
        if (bl) {
            object3 = string2;
            if ("mounted".equals(object2)) {
                object3 = string2;
                if (StorageUtils.hasExternalStoragePermission(object)) {
                    object3 = StorageUtils.getExternalCacheDir(object);
                }
            }
        }
        object2 = object3;
        if (object3 == null) {
            object2 = object.getCacheDir();
        }
        object3 = object2;
        if (object2 != null) return object3;
        object = "/data/data/" + object.getPackageName() + "/cache/";
        L.w("Can't define system cache directory! '%s' will be used.", object);
        return new File((String)object);
    }

    private static File getExternalCacheDir(Context object) {
        File file;
        block5: {
            block4: {
                file = new File(new File(new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data"), object.getPackageName()), "cache");
                object = file;
                if (file.exists()) break block4;
                if (file.mkdirs()) break block5;
                L.w("Unable to create external cache directory", new Object[0]);
                object = null;
            }
            return object;
        }
        try {
            new File(file, ".nomedia").createNewFile();
            return file;
        }
        catch (IOException iOException) {
            L.i("Can't create \".nomedia\" file in application external cache directory", new Object[0]);
            return file;
        }
    }

    public static File getIndividualCacheDirectory(Context context) {
        return StorageUtils.getIndividualCacheDirectory(context, INDIVIDUAL_DIR_NAME);
    }

    public static File getIndividualCacheDirectory(Context object, String object2) {
        File file = StorageUtils.getCacheDirectory(object);
        object2 = new File(file, (String)object2);
        object = object2;
        if (!((File)object2).exists()) {
            object = object2;
            if (!((File)object2).mkdir()) {
                object = file;
            }
        }
        return object;
    }

    public static File getOwnCacheDirectory(Context context, String object) {
        block6: {
            block5: {
                File file;
                File file2 = file = null;
                if ("mounted".equals(Environment.getExternalStorageState())) {
                    file2 = file;
                    if (StorageUtils.hasExternalStoragePermission(context)) {
                        file2 = new File(Environment.getExternalStorageDirectory(), (String)object);
                    }
                }
                if (file2 == null) break block5;
                object = file2;
                if (file2.exists()) break block6;
                object = file2;
                if (file2.mkdirs()) break block6;
            }
            object = context.getCacheDir();
        }
        return object;
    }

    public static File getOwnCacheDirectory(Context context, String object, boolean bl) {
        block7: {
            block6: {
                File file;
                File file2 = file = null;
                if (bl) {
                    file2 = file;
                    if ("mounted".equals(Environment.getExternalStorageState())) {
                        file2 = file;
                        if (StorageUtils.hasExternalStoragePermission(context)) {
                            file2 = new File(Environment.getExternalStorageDirectory(), (String)object);
                        }
                    }
                }
                if (file2 == null) break block6;
                object = file2;
                if (file2.exists()) break block7;
                object = file2;
                if (file2.mkdirs()) break block7;
            }
            object = context.getCacheDir();
        }
        return object;
    }

    private static boolean hasExternalStoragePermission(Context context) {
        return context.checkCallingOrSelfPermission(EXTERNAL_STORAGE_PERMISSION) == 0;
    }
}

