/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class MemoryCacheUtils {
    private static final String URI_AND_SIZE_SEPARATOR = "_";
    private static final String WIDTH_AND_HEIGHT_SEPARATOR = "x";

    private MemoryCacheUtils() {
    }

    public static Comparator<String> createFuzzyKeyComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                return string2.substring(0, string2.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR)).compareTo(string3.substring(0, string3.lastIndexOf(MemoryCacheUtils.URI_AND_SIZE_SEPARATOR)));
            }
        };
    }

    public static List<String> findCacheKeysForImageUri(String string2, MemoryCache object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : object.keys()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static List<Bitmap> findCachedBitmapsForImageUri(String string2, MemoryCache memoryCache) {
        ArrayList<Bitmap> arrayList = new ArrayList<Bitmap>();
        for (String string3 : memoryCache.keys()) {
            if (!string3.startsWith(string2)) continue;
            arrayList.add(memoryCache.get(string3));
        }
        return arrayList;
    }

    public static String generateKey(String string2, ImageSize imageSize) {
        return string2 + URI_AND_SIZE_SEPARATOR + imageSize.getWidth() + WIDTH_AND_HEIGHT_SEPARATOR + imageSize.getHeight();
    }

    public static void removeFromCache(String object, MemoryCache memoryCache) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : memoryCache.keys()) {
            if (!string2.startsWith((String)object)) continue;
            arrayList.add(string2);
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            memoryCache.remove((String)object.next());
        }
    }
}

