/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IoUtils {
    public static final int CONTINUE_LOADING_PERCENTAGE = 75;
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final int DEFAULT_IMAGE_TOTAL_SIZE = 512000;

    private IoUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void closeSilently(Closeable closeable) {
        if (closeable == null) return;
        try {
            closeable.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener) throws IOException {
        return IoUtils.copyStream(inputStream, outputStream, copyListener, 32768);
    }

    public static boolean copyStream(InputStream inputStream, OutputStream outputStream, CopyListener copyListener, int n2) throws IOException {
        int n3;
        int n4 = 0;
        int n5 = n3 = inputStream.available();
        if (n3 <= 0) {
            n5 = 512000;
        }
        byte[] byArray = new byte[n2];
        if (IoUtils.shouldStopLoading(copyListener, 0, n5)) {
            return false;
        }
        while ((n3 = inputStream.read(byArray, 0, n2)) != -1) {
            outputStream.write(byArray, 0, n3);
            n4 = n3 = n4 + n3;
            if (!IoUtils.shouldStopLoading(copyListener, n3, n5)) continue;
            return false;
        }
        outputStream.flush();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readAndCloseStream(InputStream inputStream) {
        byte[] byArray = new byte[32768];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, 32768)) != -1) {
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    private static boolean shouldStopLoading(CopyListener copyListener, int n2, int n3) {
        return copyListener != null && !copyListener.onBytesCopied(n2, n3) && n2 * 100 / n3 < 75;
    }

    public static interface CopyListener {
        public boolean onBytesCopied(int var1, int var2);
    }
}

