/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.utils;

import android.opengl.GLES10;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;

public final class ImageSizeUtils {
    private static final int DEFAULT_MAX_BITMAP_DIMENSION = 2048;
    private static ImageSize maxBitmapSize;

    static {
        int[] nArray = new int[1];
        GLES10.glGetIntegerv((int)3379, (int[])nArray, (int)0);
        int n2 = Math.max(nArray[0], 2048);
        maxBitmapSize = new ImageSize(n2, n2);
    }

    private ImageSizeUtils() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int computeImageSampleSize(ImageSize imageSize, ImageSize imageSize2, ViewScaleType viewScaleType, boolean bl) {
        int n2 = imageSize.getWidth();
        int n3 = imageSize.getHeight();
        int n4 = imageSize2.getWidth();
        int n5 = imageSize2.getHeight();
        int n6 = 1;
        int n7 = 1;
        int n8 = 1;
        block0 : switch (1.$SwitchMap$com$nostra13$universalimageloader$core$assist$ViewScaleType[viewScaleType.ordinal()]) {
            default: {
                n7 = n8;
                break;
            }
            case 1: {
                if (bl) {
                    n8 = n2 / 2;
                    int n9 = n3 / 2;
                    while (true) {
                        if (n8 / n6 <= n4) {
                            n7 = n6;
                            if (n9 / n6 <= n5) break block0;
                        }
                        n6 *= 2;
                    }
                }
                n7 = Math.max(n2 / n4, n3 / n5);
                break;
            }
            case 2: {
                if (bl) {
                    n8 = n2 / 2;
                    int n10 = n3 / 2;
                    n6 = n7;
                    while (true) {
                        n7 = n6;
                        if (n8 / n6 <= n4) break block0;
                        n7 = n6;
                        if (n10 / n6 <= n5) break block0;
                        n6 *= 2;
                    }
                }
                n7 = Math.min(n2 / n4, n3 / n5);
            }
        }
        n6 = n7;
        if (n7 < 1) {
            n6 = 1;
        }
        return ImageSizeUtils.considerMaxTextureSize(n2, n3, n6, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static float computeImageScale(ImageSize imageSize, ImageSize imageSize2, ViewScaleType viewScaleType, boolean bl) {
        int n2 = imageSize.getWidth();
        int n3 = imageSize.getHeight();
        int n4 = imageSize2.getWidth();
        int n5 = imageSize2.getHeight();
        float f2 = (float)n2 / (float)n4;
        float f3 = (float)n3 / (float)n5;
        if (viewScaleType == ViewScaleType.FIT_INSIDE && f2 >= f3 || viewScaleType == ViewScaleType.CROP && f2 < f3) {
            n5 = (int)((float)n3 / f2);
        } else {
            n4 = (int)((float)n2 / f3);
        }
        f3 = 1.0f;
        if (!bl && n4 < n2) {
            if (n5 < n3) return (float)n4 / (float)n2;
        }
        f2 = f3;
        if (!bl) return f2;
        f2 = f3;
        if (n4 == n2) return f2;
        f2 = f3;
        if (n5 == n3) return f2;
        return (float)n4 / (float)n2;
    }

    public static int computeMinImageSampleSize(ImageSize imageSize) {
        int n2 = imageSize.getWidth();
        int n3 = imageSize.getHeight();
        int n4 = maxBitmapSize.getWidth();
        int n5 = maxBitmapSize.getHeight();
        return Math.max((int)Math.ceil((float)n2 / (float)n4), (int)Math.ceil((float)n3 / (float)n5));
    }

    private static int considerMaxTextureSize(int n2, int n3, int n4, boolean bl) {
        int n5 = maxBitmapSize.getWidth();
        int n6 = maxBitmapSize.getHeight();
        while (n2 / n4 > n5 || n3 / n4 > n6) {
            if (bl) {
                n4 *= 2;
                continue;
            }
            ++n4;
        }
        return n4;
    }

    public static ImageSize defineTargetSizeForView(ImageAware imageAware, ImageSize imageSize) {
        int n2;
        int n3;
        int n4 = n3 = imageAware.getWidth();
        if (n3 <= 0) {
            n4 = imageSize.getWidth();
        }
        n3 = n2 = imageAware.getHeight();
        if (n2 <= 0) {
            n3 = imageSize.getHeight();
        }
        return new ImageSize(n4, n3);
    }
}

