/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.utils.L;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public abstract class ViewAware
implements ImageAware {
    public static final String WARN_CANT_SET_BITMAP = "Can't set a bitmap into view. You should call ImageLoader on UI thread for it.";
    public static final String WARN_CANT_SET_DRAWABLE = "Can't set a drawable into view. You should call ImageLoader on UI thread for it.";
    protected boolean checkActualViewSize;
    protected Reference<View> viewRef;

    public ViewAware(View view) {
        this(view, true);
    }

    public ViewAware(View view, boolean bl) {
        if (view == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.viewRef = new WeakReference<View>(view);
        this.checkActualViewSize = bl;
    }

    @Override
    public int getHeight() {
        View view = this.viewRef.get();
        if (view != null) {
            int n2;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            int n3 = n2 = 0;
            if (this.checkActualViewSize) {
                n3 = n2;
                if (layoutParams != null) {
                    n3 = n2;
                    if (layoutParams.height != -2) {
                        n3 = view.getHeight();
                    }
                }
            }
            n2 = n3;
            if (n3 <= 0) {
                n2 = n3;
                if (layoutParams != null) {
                    n2 = layoutParams.height;
                }
            }
            return n2;
        }
        return 0;
    }

    @Override
    public int getId() {
        View view = this.viewRef.get();
        if (view == null) {
            return super.hashCode();
        }
        return view.hashCode();
    }

    @Override
    public ViewScaleType getScaleType() {
        return ViewScaleType.CROP;
    }

    @Override
    public int getWidth() {
        View view = this.viewRef.get();
        if (view != null) {
            int n2;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            int n3 = n2 = 0;
            if (this.checkActualViewSize) {
                n3 = n2;
                if (layoutParams != null) {
                    n3 = n2;
                    if (layoutParams.width != -2) {
                        n3 = view.getWidth();
                    }
                }
            }
            n2 = n3;
            if (n3 <= 0) {
                n2 = n3;
                if (layoutParams != null) {
                    n2 = layoutParams.width;
                }
            }
            return n2;
        }
        return 0;
    }

    @Override
    public View getWrappedView() {
        return this.viewRef.get();
    }

    @Override
    public boolean isCollected() {
        return this.viewRef.get() == null;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        boolean bl = false;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageBitmapInto(bitmap, view);
                bl = true;
            }
            return bl;
        }
        L.w(WARN_CANT_SET_BITMAP, new Object[0]);
        return false;
    }

    protected abstract void setImageBitmapInto(Bitmap var1, View var2);

    @Override
    public boolean setImageDrawable(Drawable drawable2) {
        boolean bl = false;
        if (Looper.myLooper() == Looper.getMainLooper()) {
            View view = this.viewRef.get();
            if (view != null) {
                this.setImageDrawableInto(drawable2, view);
                bl = true;
            }
            return bl;
        }
        L.w(WARN_CANT_SET_DRAWABLE, new Object[0]);
        return false;
    }

    protected abstract void setImageDrawableInto(Drawable var1, View var2);
}

