/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;

public class NonViewAware
implements ImageAware {
    protected final ImageSize imageSize;
    protected final String imageUri;
    protected final ViewScaleType scaleType;

    public NonViewAware(ImageSize imageSize, ViewScaleType viewScaleType) {
        this(null, imageSize, viewScaleType);
    }

    public NonViewAware(String string2, ImageSize imageSize, ViewScaleType viewScaleType) {
        if (imageSize == null) {
            throw new IllegalArgumentException("imageSize must not be null");
        }
        if (viewScaleType == null) {
            throw new IllegalArgumentException("scaleType must not be null");
        }
        this.imageUri = string2;
        this.imageSize = imageSize;
        this.scaleType = viewScaleType;
    }

    @Override
    public int getHeight() {
        return this.imageSize.getHeight();
    }

    @Override
    public int getId() {
        if (TextUtils.isEmpty((CharSequence)this.imageUri)) {
            return super.hashCode();
        }
        return this.imageUri.hashCode();
    }

    @Override
    public ViewScaleType getScaleType() {
        return this.scaleType;
    }

    @Override
    public int getWidth() {
        return this.imageSize.getWidth();
    }

    @Override
    public View getWrappedView() {
        return null;
    }

    @Override
    public boolean isCollected() {
        return false;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        return true;
    }

    @Override
    public boolean setImageDrawable(Drawable drawable2) {
        return true;
    }
}

