/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.download;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.nostra13.universalimageloader.core.assist.ContentLengthInputStream;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.IoUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class BaseImageDownloader
implements ImageDownloader {
    protected static final String ALLOWED_URI_CHARS = "@#&=*+-_.,:!?()/~'%";
    protected static final int BUFFER_SIZE = 32768;
    protected static final String CONTENT_CONTACTS_URI_PREFIX = "content://com.android.contacts/";
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 5000;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 20000;
    private static final String ERROR_UNSUPPORTED_SCHEME = "UIL doesn't support scheme(protocol) by default [%s]. You should implement this support yourself (BaseImageDownloader.getStreamFromOtherSource(...))";
    protected static final int MAX_REDIRECT_COUNT = 5;
    protected final int connectTimeout;
    protected final Context context;
    protected final int readTimeout;

    public BaseImageDownloader(Context context) {
        this(context, 5000, 20000);
    }

    public BaseImageDownloader(Context context, int n2, int n3) {
        this.context = context.getApplicationContext();
        this.connectTimeout = n2;
        this.readTimeout = n3;
    }

    @TargetApi(value=8)
    private InputStream getVideoThumbnailStream(String string2) {
        if (Build.VERSION.SDK_INT >= 8 && (string2 = ThumbnailUtils.createVideoThumbnail((String)string2, (int)2)) != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            string2.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return null;
    }

    private boolean isVideoContentUri(Uri object) {
        object = this.context.getContentResolver().getType((Uri)object);
        return object != null && ((String)object).startsWith("video/");
    }

    private boolean isVideoFileUri(String string2) {
        string2 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
        return string2 != null && string2.startsWith("video/");
    }

    protected HttpURLConnection createConnection(String object, Object object2) throws IOException {
        object = (HttpURLConnection)new URL(Uri.encode((String)object, (String)ALLOWED_URI_CHARS)).openConnection();
        ((URLConnection)object).setConnectTimeout(this.connectTimeout);
        ((URLConnection)object).setReadTimeout(this.readTimeout);
        return object;
    }

    @TargetApi(value=14)
    protected InputStream getContactPhotoStream(Uri uri) {
        ContentResolver contentResolver = this.context.getContentResolver();
        if (Build.VERSION.SDK_INT >= 14) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
        return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri);
    }

    @Override
    public InputStream getStream(String string2, Object object) throws IOException {
        switch (ImageDownloader.Scheme.ofUri(string2)) {
            default: {
                return this.getStreamFromOtherSource(string2, object);
            }
            case HTTP: 
            case HTTPS: {
                return this.getStreamFromNetwork(string2, object);
            }
            case FILE: {
                return this.getStreamFromFile(string2, object);
            }
            case CONTENT: {
                return this.getStreamFromContent(string2, object);
            }
            case ASSETS: {
                return this.getStreamFromAssets(string2, object);
            }
            case DRAWABLE: 
        }
        return this.getStreamFromDrawable(string2, object);
    }

    protected InputStream getStreamFromAssets(String string2, Object object) throws IOException {
        string2 = ImageDownloader.Scheme.ASSETS.crop(string2);
        return this.context.getAssets().open(string2);
    }

    protected InputStream getStreamFromContent(String string2, Object object) throws FileNotFoundException {
        object = this.context.getContentResolver();
        Uri uri = Uri.parse((String)string2);
        if (this.isVideoContentUri(uri)) {
            string2 = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)object, (long)Long.valueOf(uri.getLastPathSegment()), (int)1, null);
            if (string2 != null) {
                object = new ByteArrayOutputStream();
                string2.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)object);
                return new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray());
            }
        } else if (string2.startsWith(CONTENT_CONTACTS_URI_PREFIX)) {
            return this.getContactPhotoStream(uri);
        }
        return object.openInputStream(uri);
    }

    protected InputStream getStreamFromDrawable(String string2, Object object) {
        int n2 = Integer.parseInt(ImageDownloader.Scheme.DRAWABLE.crop(string2));
        return this.context.getResources().openRawResource(n2);
    }

    protected InputStream getStreamFromFile(String string2, Object object) throws IOException {
        object = ImageDownloader.Scheme.FILE.crop(string2);
        if (this.isVideoFileUri(string2)) {
            return this.getVideoThumbnailStream((String)object);
        }
        return new ContentLengthInputStream(new BufferedInputStream(new FileInputStream((String)object), 32768), (int)new File((String)object).length());
    }

    protected InputStream getStreamFromNetwork(String object, Object object2) throws IOException {
        object = this.createConnection((String)object, object2);
        for (int i2 = 0; ((HttpURLConnection)object).getResponseCode() / 100 == 3 && i2 < 5; ++i2) {
            object = this.createConnection(((URLConnection)object).getHeaderField("Location"), object2);
        }
        try {
            object2 = ((URLConnection)object).getInputStream();
        }
        catch (IOException iOException) {
            IoUtils.readAndCloseStream(((HttpURLConnection)object).getErrorStream());
            throw iOException;
        }
        if (!this.shouldBeProcessed((HttpURLConnection)object)) {
            IoUtils.closeSilently((Closeable)object2);
            throw new IOException("Image request failed with response code " + ((HttpURLConnection)object).getResponseCode());
        }
        return new ContentLengthInputStream(new BufferedInputStream((InputStream)object2, 32768), ((URLConnection)object).getContentLength());
    }

    protected InputStream getStreamFromOtherSource(String string2, Object object) throws IOException {
        throw new UnsupportedOperationException(String.format(ERROR_UNSUPPORTED_SCHEME, string2));
    }

    protected boolean shouldBeProcessed(HttpURLConnection httpURLConnection) throws IOException {
        return httpURLConnection.getResponseCode() == 200;
    }
}

