/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.ComposeShader;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.display.RoundedBitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;

public class RoundedVignetteBitmapDisplayer
extends RoundedBitmapDisplayer {
    public RoundedVignetteBitmapDisplayer(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public void display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        if (!(imageAware instanceof ImageViewAware)) {
            throw new IllegalArgumentException("ImageAware should wrap ImageView. ImageViewAware is expected.");
        }
        imageAware.setImageDrawable(new RoundedVignetteDrawable(bitmap, this.cornerRadius, this.margin));
    }

    protected static class RoundedVignetteDrawable
    extends RoundedBitmapDisplayer.RoundedDrawable {
        RoundedVignetteDrawable(Bitmap bitmap, int n2, int n3) {
            super(bitmap, n2, n3);
        }

        @Override
        protected void onBoundsChange(Rect rect) {
            super.onBoundsChange(rect);
            float f2 = this.mRect.centerX();
            float f3 = this.mRect.centerY() * 1.0f / 0.7f;
            float f4 = this.mRect.centerX();
            rect = Shader.TileMode.CLAMP;
            rect = new RadialGradient(f2, f3, f4 * 1.3f, new int[]{0, 0, 0x7F000000}, new float[]{0.0f, 0.7f, 1.0f}, (Shader.TileMode)rect);
            Matrix matrix = new Matrix();
            matrix.setScale(1.0f, 0.7f);
            rect.setLocalMatrix(matrix);
            this.paint.setShader((Shader)new ComposeShader((Shader)this.bitmapShader, (Shader)rect, PorterDuff.Mode.SRC_OVER));
        }
    }
}

