/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.display;

import android.graphics.Bitmap;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;

public class FadeInBitmapDisplayer
implements BitmapDisplayer {
    private final boolean animateFromDisk;
    private final boolean animateFromMemory;
    private final boolean animateFromNetwork;
    private final int durationMillis;

    public FadeInBitmapDisplayer(int n2) {
        this(n2, true, true, true);
    }

    public FadeInBitmapDisplayer(int n2, boolean bl, boolean bl2, boolean bl3) {
        this.durationMillis = n2;
        this.animateFromNetwork = bl;
        this.animateFromDisk = bl2;
        this.animateFromMemory = bl3;
    }

    public static void animate(View view, int n2) {
        if (view != null) {
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
            alphaAnimation.setDuration((long)n2);
            alphaAnimation.setInterpolator((Interpolator)new DecelerateInterpolator());
            view.startAnimation((Animation)alphaAnimation);
        }
    }

    @Override
    public void display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        imageAware.setImageBitmap(bitmap);
        if (this.animateFromNetwork && loadedFrom == LoadedFrom.NETWORK || this.animateFromDisk && loadedFrom == LoadedFrom.DISC_CACHE || this.animateFromMemory && loadedFrom == LoadedFrom.MEMORY_CACHE) {
            FadeInBitmapDisplayer.animate(imageAware.getWrappedView(), this.durationMillis);
        }
    }
}

