/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;

public class CircleBitmapDisplayer
implements BitmapDisplayer {
    protected final Integer strokeColor;
    protected final float strokeWidth;

    public CircleBitmapDisplayer() {
        this(null);
    }

    public CircleBitmapDisplayer(Integer n2) {
        this(n2, 0.0f);
    }

    public CircleBitmapDisplayer(Integer n2, float f2) {
        this.strokeColor = n2;
        this.strokeWidth = f2;
    }

    @Override
    public void display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        if (!(imageAware instanceof ImageViewAware)) {
            throw new IllegalArgumentException("ImageAware should wrap ImageView. ImageViewAware is expected.");
        }
        imageAware.setImageDrawable(new CircleDrawable(bitmap, this.strokeColor, this.strokeWidth));
    }

    public static class CircleDrawable
    extends Drawable {
        protected final BitmapShader bitmapShader;
        protected final RectF mBitmapRect;
        protected final RectF mRect = new RectF();
        protected final Paint paint;
        protected float radius;
        protected final Paint strokePaint;
        protected float strokeRadius;
        protected final float strokeWidth;

        /*
         * Enabled aggressive block sorting
         */
        public CircleDrawable(Bitmap bitmap, Integer n2, float f2) {
            this.radius = Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2;
            this.bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            this.mBitmapRect = new RectF(0.0f, 0.0f, (float)bitmap.getWidth(), (float)bitmap.getHeight());
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            this.paint.setShader((Shader)this.bitmapShader);
            this.paint.setFilterBitmap(true);
            this.paint.setDither(true);
            if (n2 == null) {
                this.strokePaint = null;
            } else {
                this.strokePaint = new Paint();
                this.strokePaint.setStyle(Paint.Style.STROKE);
                this.strokePaint.setColor(n2.intValue());
                this.strokePaint.setStrokeWidth(f2);
                this.strokePaint.setAntiAlias(true);
            }
            this.strokeWidth = f2;
            this.strokeRadius = this.radius - f2 / 2.0f;
        }

        public void draw(Canvas canvas) {
            canvas.drawCircle(this.radius, this.radius, this.radius, this.paint);
            if (this.strokePaint != null) {
                canvas.drawCircle(this.radius, this.radius, this.strokeRadius, this.strokePaint);
            }
        }

        public int getOpacity() {
            return -3;
        }

        protected void onBoundsChange(Rect rect) {
            super.onBoundsChange(rect);
            this.mRect.set(0.0f, 0.0f, (float)rect.width(), (float)rect.height());
            this.radius = Math.min(rect.width(), rect.height()) / 2;
            this.strokeRadius = this.radius - this.strokeWidth / 2.0f;
            rect = new Matrix();
            rect.setRectToRect(this.mBitmapRect, this.mRect, Matrix.ScaleToFit.FILL);
            this.bitmapShader.setLocalMatrix((Matrix)rect);
        }

        public void setAlpha(int n2) {
            this.paint.setAlpha(n2);
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.paint.setColorFilter(colorFilter);
        }
    }
}

