/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.ImageSizeUtils;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.IOException;
import java.io.InputStream;

public class BaseImageDecoder
implements ImageDecoder {
    protected static final String ERROR_CANT_DECODE_IMAGE = "Image can't be decoded [%s]";
    protected static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    protected static final String LOG_FLIP_IMAGE = "Flip image horizontally [%s]";
    protected static final String LOG_ROTATE_IMAGE = "Rotate image on %1$d\u00b0 [%2$s]";
    protected static final String LOG_SCALE_IMAGE = "Scale subsampled image (%1$s) to %2$s (scale = %3$.5f) [%4$s]";
    protected static final String LOG_SUBSAMPLE_IMAGE = "Subsample original image (%1$s) to %2$s (scale = %3$d) [%4$s]";
    protected final boolean loggingEnabled;

    public BaseImageDecoder(boolean bl) {
        this.loggingEnabled = bl;
    }

    private boolean canDefineExifParams(String string2, String string3) {
        return "image/jpeg".equalsIgnoreCase(string3) && ImageDownloader.Scheme.ofUri(string2) == ImageDownloader.Scheme.FILE;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Bitmap considerExactScaleAndOrientatiton(Bitmap bitmap, ImageDecodingInfo imageDecodingInfo, int n2, boolean bl) {
        boolean bl2;
        ViewScaleType viewScaleType;
        ImageSize imageSize;
        ImageSize imageSize2;
        float f2;
        Matrix matrix = new Matrix();
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        if ((imageScaleType == ImageScaleType.EXACTLY || imageScaleType == ImageScaleType.EXACTLY_STRETCHED) && Float.compare(f2 = ImageSizeUtils.computeImageScale(imageSize2 = new ImageSize(bitmap.getWidth(), bitmap.getHeight(), n2), imageSize = imageDecodingInfo.getTargetSize(), viewScaleType = imageDecodingInfo.getViewScaleType(), bl2 = imageScaleType == ImageScaleType.EXACTLY_STRETCHED), 1.0f) != 0) {
            matrix.setScale(f2, f2);
            if (this.loggingEnabled) {
                L.d(LOG_SCALE_IMAGE, imageSize2, imageSize2.scale(f2), Float.valueOf(f2), imageDecodingInfo.getImageKey());
            }
        }
        if (bl) {
            matrix.postScale(-1.0f, 1.0f);
            if (this.loggingEnabled) {
                L.d(LOG_FLIP_IMAGE, imageDecodingInfo.getImageKey());
            }
        }
        if (n2 != 0) {
            matrix.postRotate((float)n2);
            if (this.loggingEnabled) {
                L.d(LOG_ROTATE_IMAGE, n2, imageDecodingInfo.getImageKey());
            }
        }
        if ((imageDecodingInfo = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true)) != bitmap) {
            bitmap.recycle();
        }
        return imageDecodingInfo;
    }

    @Override
    public Bitmap decode(ImageDecodingInfo imageDecodingInfo) throws IOException {
        ImageFileInfo imageFileInfo;
        InputStream inputStream = this.getImageStream(imageDecodingInfo);
        if (inputStream == null) {
            L.e(ERROR_NO_IMAGE_STREAM, imageDecodingInfo.getImageKey());
            return null;
        }
        InputStream inputStream2 = inputStream;
        try {
            imageFileInfo = this.defineImageSizeAndRotation(inputStream, imageDecodingInfo);
            inputStream2 = inputStream;
        }
        catch (Throwable throwable) {
            IoUtils.closeSilently(inputStream2);
            throw throwable;
        }
        inputStream2 = inputStream = this.resetStream(inputStream, imageDecodingInfo);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)this.prepareDecodingOptions(imageFileInfo.imageSize, imageDecodingInfo));
        IoUtils.closeSilently(inputStream);
        if (bitmap == null) {
            L.e(ERROR_CANT_DECODE_IMAGE, imageDecodingInfo.getImageKey());
            return bitmap;
        }
        return this.considerExactScaleAndOrientatiton(bitmap, imageDecodingInfo, imageFileInfo.exif.rotation, imageFileInfo.exif.flipHorizontal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ExifInfo defineExifOrientation(String string2) {
        int n2;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            n2 = new ExifInterface(ImageDownloader.Scheme.FILE.crop(string2)).getAttributeInt("Orientation", 1);
        }
        catch (IOException iOException) {
            L.w("Can't read EXIF tags from file [%s]", string2);
            bl = bl5;
            return new ExifInfo(n3, bl);
        }
        switch (n2) {
            default: {
                bl = bl5;
                return new ExifInfo(n3, bl);
            }
            case 2: {
                bl = true;
            }
            case 1: {
                n3 = 0;
                return new ExifInfo(n3, bl);
            }
            case 7: {
                bl2 = true;
            }
            case 6: {
                n3 = 90;
                bl = bl2;
                return new ExifInfo(n3, bl);
            }
            case 4: {
                bl3 = true;
            }
            case 3: {
                n3 = 180;
                bl = bl3;
                return new ExifInfo(n3, bl);
            }
            case 5: {
                bl4 = true;
            }
            case 8: 
        }
        n3 = 270;
        bl = bl4;
        return new ExifInfo(n3, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ImageFileInfo defineImageSizeAndRotation(InputStream object, ImageDecodingInfo imageDecodingInfo) throws IOException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)options);
        object = imageDecodingInfo.getImageUri();
        if (imageDecodingInfo.shouldConsiderExifParams() && this.canDefineExifParams((String)object, options.outMimeType)) {
            object = this.defineExifOrientation((String)object);
            return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, ((ExifInfo)object).rotation), (ExifInfo)object);
        }
        object = new ExifInfo();
        return new ImageFileInfo(new ImageSize(options.outWidth, options.outHeight, ((ExifInfo)object).rotation), (ExifInfo)object);
    }

    protected InputStream getImageStream(ImageDecodingInfo imageDecodingInfo) throws IOException {
        return imageDecodingInfo.getDownloader().getStream(imageDecodingInfo.getImageUri(), imageDecodingInfo.getExtraForDownloader());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected BitmapFactory.Options prepareDecodingOptions(ImageSize imageSize, ImageDecodingInfo imageDecodingInfo) {
        int n2;
        ImageScaleType imageScaleType = imageDecodingInfo.getImageScaleType();
        if (imageScaleType == ImageScaleType.NONE) {
            n2 = 1;
        } else if (imageScaleType == ImageScaleType.NONE_SAFE) {
            n2 = ImageSizeUtils.computeMinImageSampleSize(imageSize);
        } else {
            ImageSize imageSize2 = imageDecodingInfo.getTargetSize();
            boolean bl = imageScaleType == ImageScaleType.IN_SAMPLE_POWER_OF_2;
            n2 = ImageSizeUtils.computeImageSampleSize(imageSize, imageSize2, imageDecodingInfo.getViewScaleType(), bl);
        }
        if (n2 > 1 && this.loggingEnabled) {
            L.d(LOG_SUBSAMPLE_IMAGE, imageSize, imageSize.scaleDown(n2), n2, imageDecodingInfo.getImageKey());
        }
        imageSize = imageDecodingInfo.getDecodingOptions();
        ((BitmapFactory.Options)imageSize).inSampleSize = n2;
        return imageSize;
    }

    protected InputStream resetStream(InputStream inputStream, ImageDecodingInfo imageDecodingInfo) throws IOException {
        if (inputStream.markSupported()) {
            try {
                inputStream.reset();
                return inputStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IoUtils.closeSilently(inputStream);
        return this.getImageStream(imageDecodingInfo);
    }

    protected static class ExifInfo {
        public final boolean flipHorizontal;
        public final int rotation;

        protected ExifInfo() {
            this.rotation = 0;
            this.flipHorizontal = false;
        }

        protected ExifInfo(int n2, boolean bl) {
            this.rotation = n2;
            this.flipHorizontal = bl;
        }
    }

    protected static class ImageFileInfo {
        public final ExifInfo exif;
        public final ImageSize imageSize;

        protected ImageFileInfo(ImageSize imageSize, ExifInfo exifInfo) {
            this.imageSize = imageSize;
            this.exif = exifInfo;
        }
    }
}

