/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import com.nostra13.universalimageloader.core.DisplayBitmapTask;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecodingInfo;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.ImageLoadingProgressListener;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

final class LoadAndDisplayImageTask
implements Runnable,
IoUtils.CopyListener {
    private static final String ERROR_NO_IMAGE_STREAM = "No stream for image [%s]";
    private static final String ERROR_POST_PROCESSOR_NULL = "Post-processor returned null [%s]";
    private static final String ERROR_PRE_PROCESSOR_NULL = "Pre-processor returned null [%s]";
    private static final String ERROR_PROCESSOR_FOR_DISK_CACHE_NULL = "Bitmap processor for disk cache returned null [%s]";
    private static final String LOG_CACHE_IMAGE_IN_MEMORY = "Cache image in memory [%s]";
    private static final String LOG_CACHE_IMAGE_ON_DISK = "Cache image on disk [%s]";
    private static final String LOG_DELAY_BEFORE_LOADING = "Delay %d ms before loading...  [%s]";
    private static final String LOG_GET_IMAGE_FROM_MEMORY_CACHE_AFTER_WAITING = "...Get cached bitmap from memory after waiting. [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_DISK_CACHE = "Load image from disk cache [%s]";
    private static final String LOG_LOAD_IMAGE_FROM_NETWORK = "Load image from network [%s]";
    private static final String LOG_POSTPROCESS_IMAGE = "PostProcess image before displaying [%s]";
    private static final String LOG_PREPROCESS_IMAGE = "PreProcess image before caching in memory [%s]";
    private static final String LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISK = "Process image before cache on disk [%s]";
    private static final String LOG_RESIZE_CACHED_IMAGE_FILE = "Resize image in disk cache [%s]";
    private static final String LOG_RESUME_AFTER_PAUSE = ".. Resume loading [%s]";
    private static final String LOG_START_DISPLAY_IMAGE_TASK = "Start display image task [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED = "ImageAware was collected by GC. Task is cancelled. [%s]";
    private static final String LOG_TASK_CANCELLED_IMAGEAWARE_REUSED = "ImageAware is reused for another image. Task is cancelled. [%s]";
    private static final String LOG_TASK_INTERRUPTED = "Task was interrupted [%s]";
    private static final String LOG_WAITING_FOR_IMAGE_LOADED = "Image already is loading. Waiting... [%s]";
    private static final String LOG_WAITING_FOR_RESUME = "ImageLoader is paused. Waiting...  [%s]";
    private final ImageLoaderConfiguration configuration;
    private final ImageDecoder decoder;
    private final ImageDownloader downloader;
    private final ImageLoaderEngine engine;
    private final Handler handler;
    final ImageAware imageAware;
    private final ImageLoadingInfo imageLoadingInfo;
    final ImageLoadingListener listener;
    private LoadedFrom loadedFrom = LoadedFrom.NETWORK;
    private final String memoryCacheKey;
    private final ImageDownloader networkDeniedDownloader;
    final DisplayImageOptions options;
    final ImageLoadingProgressListener progressListener;
    private final ImageDownloader slowNetworkDownloader;
    private final boolean syncLoading;
    private final ImageSize targetSize;
    final String uri;

    public LoadAndDisplayImageTask(ImageLoaderEngine imageLoaderEngine, ImageLoadingInfo imageLoadingInfo, Handler handler) {
        this.engine = imageLoaderEngine;
        this.imageLoadingInfo = imageLoadingInfo;
        this.handler = handler;
        this.configuration = imageLoaderEngine.configuration;
        this.downloader = this.configuration.downloader;
        this.networkDeniedDownloader = this.configuration.networkDeniedDownloader;
        this.slowNetworkDownloader = this.configuration.slowNetworkDownloader;
        this.decoder = this.configuration.decoder;
        this.uri = imageLoadingInfo.uri;
        this.memoryCacheKey = imageLoadingInfo.memoryCacheKey;
        this.imageAware = imageLoadingInfo.imageAware;
        this.targetSize = imageLoadingInfo.targetSize;
        this.options = imageLoadingInfo.options;
        this.listener = imageLoadingInfo.listener;
        this.progressListener = imageLoadingInfo.progressListener;
        this.syncLoading = this.options.isSyncLoading();
    }

    private void checkTaskInterrupted() throws TaskCancelledException {
        if (this.isTaskInterrupted()) {
            throw new TaskCancelledException();
        }
    }

    private void checkTaskNotActual() throws TaskCancelledException {
        this.checkViewCollected();
        this.checkViewReused();
    }

    private void checkViewCollected() throws TaskCancelledException {
        if (this.isViewCollected()) {
            throw new TaskCancelledException();
        }
    }

    private void checkViewReused() throws TaskCancelledException {
        if (this.isViewReused()) {
            throw new TaskCancelledException();
        }
    }

    private Bitmap decodeImage(String object) throws IOException {
        ViewScaleType viewScaleType = this.imageAware.getScaleType();
        object = new ImageDecodingInfo(this.memoryCacheKey, (String)object, this.uri, this.targetSize, viewScaleType, this.getDownloader(), this.options);
        return this.decoder.decode((ImageDecodingInfo)object);
    }

    private boolean delayIfNeed() {
        if (this.options.shouldDelayBeforeLoading()) {
            L.d(LOG_DELAY_BEFORE_LOADING, this.options.getDelayBeforeLoading(), this.memoryCacheKey);
            try {
                Thread.sleep(this.options.getDelayBeforeLoading());
                return this.isTaskNotActual();
            }
            catch (InterruptedException interruptedException) {
                L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                return true;
            }
        }
        return false;
    }

    private boolean downloadImage() throws IOException {
        InputStream inputStream = this.getDownloader().getStream(this.uri, this.options.getExtraForDownloader());
        if (inputStream == null) {
            L.e(ERROR_NO_IMAGE_STREAM, this.memoryCacheKey);
            return false;
        }
        try {
            boolean bl = this.configuration.diskCache.save(this.uri, inputStream, this);
            return bl;
        }
        finally {
            IoUtils.closeSilently(inputStream);
        }
    }

    private void fireCancelEvent() {
        if (this.syncLoading || this.isTaskInterrupted()) {
            return;
        }
        LoadAndDisplayImageTask.runTask(new Runnable(){

            @Override
            public void run() {
                LoadAndDisplayImageTask.this.listener.onLoadingCancelled(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView());
            }
        }, false, this.handler, this.engine);
    }

    private void fireFailEvent(final FailReason.FailType failType, final Throwable throwable) {
        if (this.syncLoading || this.isTaskInterrupted() || this.isTaskNotActual()) {
            return;
        }
        LoadAndDisplayImageTask.runTask(new Runnable(){

            @Override
            public void run() {
                if (LoadAndDisplayImageTask.this.options.shouldShowImageOnFail()) {
                    LoadAndDisplayImageTask.this.imageAware.setImageDrawable(LoadAndDisplayImageTask.this.options.getImageOnFail(((LoadAndDisplayImageTask)LoadAndDisplayImageTask.this).configuration.resources));
                }
                LoadAndDisplayImageTask.this.listener.onLoadingFailed(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), new FailReason(failType, throwable));
            }
        }, false, this.handler, this.engine);
    }

    private boolean fireProgressEvent(final int n2, final int n3) {
        if (this.isTaskInterrupted() || this.isTaskNotActual()) {
            return false;
        }
        if (this.progressListener != null) {
            LoadAndDisplayImageTask.runTask(new Runnable(){

                @Override
                public void run() {
                    LoadAndDisplayImageTask.this.progressListener.onProgressUpdate(LoadAndDisplayImageTask.this.uri, LoadAndDisplayImageTask.this.imageAware.getWrappedView(), n2, n3);
                }
            }, false, this.handler, this.engine);
        }
        return true;
    }

    private ImageDownloader getDownloader() {
        if (this.engine.isNetworkDenied()) {
            return this.networkDeniedDownloader;
        }
        if (this.engine.isSlowNetwork()) {
            return this.slowNetworkDownloader;
        }
        return this.downloader;
    }

    private boolean isTaskInterrupted() {
        if (Thread.interrupted()) {
            L.d(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
            return true;
        }
        return false;
    }

    private boolean isTaskNotActual() {
        return this.isViewCollected() || this.isViewReused();
    }

    private boolean isViewCollected() {
        if (this.imageAware.isCollected()) {
            L.d(LOG_TASK_CANCELLED_IMAGEAWARE_COLLECTED, this.memoryCacheKey);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isViewReused() {
        String string2 = this.engine.getLoadingUriForView(this.imageAware);
        if (this.memoryCacheKey.equals(string2)) return false;
        boolean bl = true;
        if (!bl) return false;
        L.d(LOG_TASK_CANCELLED_IMAGEAWARE_REUSED, this.memoryCacheKey);
        return true;
    }

    private boolean resizeAndSaveImage(int n2, int n3) throws IOException {
        boolean bl = false;
        Object object = this.configuration.diskCache.get(this.uri);
        boolean bl2 = bl;
        if (object != null) {
            bl2 = bl;
            if (((File)object).exists()) {
                ImageSize imageSize = new ImageSize(n2, n3);
                DisplayImageOptions displayImageOptions = new DisplayImageOptions.Builder().cloneFrom(this.options).imageScaleType(ImageScaleType.IN_SAMPLE_INT).build();
                object = new ImageDecodingInfo(this.memoryCacheKey, ImageDownloader.Scheme.FILE.wrap(((File)object).getAbsolutePath()), this.uri, imageSize, ViewScaleType.FIT_INSIDE, this.getDownloader(), displayImageOptions);
                imageSize = this.decoder.decode((ImageDecodingInfo)object);
                object = imageSize;
                if (imageSize != null) {
                    object = imageSize;
                    if (this.configuration.processorForDiskCache != null) {
                        L.d(LOG_PROCESS_IMAGE_BEFORE_CACHE_ON_DISK, this.memoryCacheKey);
                        imageSize = this.configuration.processorForDiskCache.process((Bitmap)imageSize);
                        object = imageSize;
                        if (imageSize == null) {
                            L.e(ERROR_PROCESSOR_FOR_DISK_CACHE_NULL, this.memoryCacheKey);
                            object = imageSize;
                        }
                    }
                }
                bl2 = bl;
                if (object != null) {
                    bl2 = this.configuration.diskCache.save(this.uri, (Bitmap)object);
                    object.recycle();
                }
            }
        }
        return bl2;
    }

    static void runTask(Runnable runnable, boolean bl, Handler handler, ImageLoaderEngine imageLoaderEngine) {
        if (bl) {
            runnable.run();
            return;
        }
        if (handler == null) {
            imageLoaderEngine.fireCallback(runnable);
            return;
        }
        handler.post(runnable);
    }

    private boolean tryCacheImageOnDisk() throws TaskCancelledException {
        boolean bl;
        block4: {
            L.d(LOG_CACHE_IMAGE_ON_DISK, this.memoryCacheKey);
            try {
                bl = this.downloadImage();
                if (!bl) break block4;
            }
            catch (IOException iOException) {
                L.e(iOException);
                return false;
            }
            int n2 = this.configuration.maxImageWidthForDiskCache;
            int n3 = this.configuration.maxImageHeightForDiskCache;
            if (n2 <= 0 && n3 <= 0) break block4;
            L.d(LOG_RESIZE_CACHED_IMAGE_FILE, this.memoryCacheKey);
            this.resizeAndSaveImage(n2, n3);
        }
        return bl;
    }

    private Bitmap tryLoadBitmap() throws TaskCancelledException {
        String string2;
        block29: {
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            block31: {
                block30: {
                    Object object;
                    String string8;
                    block28: {
                        block27: {
                            string8 = null;
                            object = null;
                            String string9 = null;
                            String string10 = null;
                            string2 = null;
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            File file = this.configuration.diskCache.get(this.uri);
                            string3 = string2;
                            if (file == null) break block27;
                            string3 = string2;
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            if (!file.exists()) break block27;
                            string3 = string2;
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            if (file.length() <= 0L) break block27;
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            L.d(LOG_LOAD_IMAGE_FROM_DISK_CACHE, this.memoryCacheKey);
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            this.loadedFrom = LoadedFrom.DISC_CACHE;
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            this.checkTaskNotActual();
                            string7 = string8;
                            string6 = object;
                            string5 = string9;
                            string4 = string10;
                            string3 = this.decodeImage(ImageDownloader.Scheme.FILE.wrap(file.getAbsolutePath()));
                        }
                        if (string3 != null) {
                            string7 = string3;
                            string6 = string3;
                            string5 = string3;
                            string4 = string3;
                            if (string3.getWidth() <= 0) break block28;
                            string2 = string3;
                            string7 = string3;
                            string6 = string3;
                            string5 = string3;
                            string4 = string3;
                            if (string3.getHeight() > 0) break block29;
                        }
                    }
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    L.d(LOG_LOAD_IMAGE_FROM_NETWORK, this.memoryCacheKey);
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    this.loadedFrom = LoadedFrom.NETWORK;
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    string2 = string8 = this.uri;
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    if (!this.options.isCacheOnDisk()) break block30;
                    string2 = string8;
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    if (!this.tryCacheImageOnDisk()) break block30;
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    object = this.configuration.diskCache.get(this.uri);
                    string2 = string8;
                    if (object == null) break block30;
                    string7 = string3;
                    string6 = string3;
                    string5 = string3;
                    string4 = string3;
                    string2 = ImageDownloader.Scheme.FILE.wrap(((File)object).getAbsolutePath());
                }
                string7 = string3;
                string6 = string3;
                string5 = string3;
                string4 = string3;
                this.checkTaskNotActual();
                string7 = string3;
                string6 = string3;
                string5 = string3;
                string4 = string3;
                string3 = this.decodeImage(string2);
                if (string3 == null) break block31;
                string7 = string3;
                string6 = string3;
                string5 = string3;
                string4 = string3;
                if (string3.getWidth() <= 0) break block31;
                string2 = string3;
                string7 = string3;
                string6 = string3;
                string5 = string3;
                string4 = string3;
                if (string3.getHeight() > 0) break block29;
            }
            string7 = string3;
            string6 = string3;
            string5 = string3;
            string4 = string3;
            try {
                this.fireFailEvent(FailReason.FailType.DECODING_ERROR, null);
                string2 = string3;
            }
            catch (IllegalStateException illegalStateException) {
                this.fireFailEvent(FailReason.FailType.NETWORK_DENIED, null);
                return string7;
            }
            catch (TaskCancelledException taskCancelledException) {
                throw taskCancelledException;
            }
            catch (IOException iOException) {
                L.e(iOException);
                this.fireFailEvent(FailReason.FailType.IO_ERROR, iOException);
                return string6;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                L.e(outOfMemoryError);
                this.fireFailEvent(FailReason.FailType.OUT_OF_MEMORY, outOfMemoryError);
                return string5;
            }
            catch (Throwable throwable) {
                L.e(throwable);
                this.fireFailEvent(FailReason.FailType.UNKNOWN, throwable);
                return string4;
            }
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitIfPaused() {
        AtomicBoolean atomicBoolean = this.engine.getPause();
        if (atomicBoolean.get()) {
            Object object = this.engine.getPauseLock();
            synchronized (object) {
                if (atomicBoolean.get()) {
                    L.d(LOG_WAITING_FOR_RESUME, this.memoryCacheKey);
                    try {
                        this.engine.getPauseLock().wait();
                    }
                    catch (InterruptedException interruptedException) {
                        L.e(LOG_TASK_INTERRUPTED, this.memoryCacheKey);
                        return true;
                    }
                    L.d(LOG_RESUME_AFTER_PAUSE, this.memoryCacheKey);
                }
            }
        }
        return this.isTaskNotActual();
    }

    String getLoadingUri() {
        return this.uri;
    }

    @Override
    public boolean onBytesCopied(int n2, int n3) {
        return this.syncLoading || this.fireProgressEvent(n2, n3);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.waitIfPaused()) {
            return;
        }
        if (this.delayIfNeed() != false) return;
        var3_1 = this.imageLoadingInfo.loadFromUriLock;
        L.d("Start display image task [%s]", new Object[]{this.memoryCacheKey});
        if (var3_1.isLocked()) {
            L.d("Image already is loading. Waiting... [%s]", new Object[]{this.memoryCacheKey});
        }
        var3_1.lock();
        try {
            this.checkTaskNotActual();
            var2_2 = this.configuration.memoryCache.get(this.memoryCacheKey);
            if (var2_2 == null || var2_2.isRecycled()) {
                var2_2 = this.tryLoadBitmap();
                if (var2_2 == null) {
                    var3_1.unlock();
                    return;
                }
            }
            ** GOTO lbl-1000
        }
        catch (TaskCancelledException var1_4) {
            this.fireCancelEvent();
            return;
        }
        catch (Throwable var1_5) {
            throw var1_5;
        }
        ** try [egrp 1[TRYBLOCK] [6, 7 : 112->320)] { 
lbl25:
        // 1 sources

        this.checkTaskNotActual();
        this.checkTaskInterrupted();
        var1_3 = var2_2;
        if (this.options.shouldPreProcess()) {
            L.d("PreProcess image before caching in memory [%s]", new Object[]{this.memoryCacheKey});
            var1_3 = var2_2 = this.options.getPreProcessor().process(var2_2);
            if (var2_2 == null) {
                L.e("Pre-processor returned null [%s]", new Object[]{this.memoryCacheKey});
                var1_3 = var2_2;
            }
        }
        var2_2 = var1_3;
        if (var1_3 != null) {
            var2_2 = var1_3;
            if (this.options.isCacheInMemory()) {
                L.d("Cache image in memory [%s]", new Object[]{this.memoryCacheKey});
                this.configuration.memoryCache.put(this.memoryCacheKey, var1_3);
                var2_2 = var1_3;
            }
        }
lbl42:
        // 6 sources

        while (true) {
            var1_3 = var2_2;
            if (var2_2 != null) {
                var1_3 = var2_2;
                if (this.options.shouldPostProcess()) {
                    L.d("PostProcess image before displaying [%s]", new Object[]{this.memoryCacheKey});
                    var1_3 = var2_2 = this.options.getPostProcessor().process(var2_2);
                    if (var2_2 == null) {
                        L.e("Post-processor returned null [%s]", new Object[]{this.memoryCacheKey});
                        var1_3 = var2_2;
                    }
                }
            }
            this.checkTaskNotActual();
            this.checkTaskInterrupted();
            LoadAndDisplayImageTask.runTask(new DisplayBitmapTask(var1_3, this.imageLoadingInfo, this.engine, this.loadedFrom), this.syncLoading, this.handler, this.engine);
            return;
        }
lbl-1000:
        // 1 sources

        {
            this.loadedFrom = LoadedFrom.MEMORY_CACHE;
            L.d("...Get cached bitmap from memory after waiting. [%s]", new Object[]{this.memoryCacheKey});
            ** continue;
        }
lbl59:
        // 1 sources

        finally {
            var3_1.unlock();
        }
    }

    class TaskCancelledException
    extends Exception {
        TaskCancelledException() {
        }
    }
}

