/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

class ImageLoaderEngine {
    private final Map<Integer, String> cacheKeysForImageAwares = Collections.synchronizedMap(new HashMap());
    final ImageLoaderConfiguration configuration;
    private final AtomicBoolean networkDenied;
    private final Object pauseLock;
    private final AtomicBoolean paused;
    private final AtomicBoolean slowNetwork;
    private Executor taskDistributor;
    private Executor taskExecutor;
    private Executor taskExecutorForCachedImages;
    private final Map<String, ReentrantLock> uriLocks = new WeakHashMap<String, ReentrantLock>();

    ImageLoaderEngine(ImageLoaderConfiguration imageLoaderConfiguration) {
        this.paused = new AtomicBoolean(false);
        this.networkDenied = new AtomicBoolean(false);
        this.slowNetwork = new AtomicBoolean(false);
        this.pauseLock = new Object();
        this.configuration = imageLoaderConfiguration;
        this.taskExecutor = imageLoaderConfiguration.taskExecutor;
        this.taskExecutorForCachedImages = imageLoaderConfiguration.taskExecutorForCachedImages;
        this.taskDistributor = DefaultConfigurationFactory.createTaskDistributor();
    }

    private Executor createTaskExecutor() {
        return DefaultConfigurationFactory.createExecutor(this.configuration.threadPoolSize, this.configuration.threadPriority, this.configuration.tasksProcessingType);
    }

    private void initExecutorsIfNeed() {
        if (!this.configuration.customExecutor && ((ExecutorService)this.taskExecutor).isShutdown()) {
            this.taskExecutor = this.createTaskExecutor();
        }
        if (!this.configuration.customExecutorForCachedImages && ((ExecutorService)this.taskExecutorForCachedImages).isShutdown()) {
            this.taskExecutorForCachedImages = this.createTaskExecutor();
        }
    }

    void cancelDisplayTaskFor(ImageAware imageAware) {
        this.cacheKeysForImageAwares.remove(imageAware.getId());
    }

    void denyNetworkDownloads(boolean bl) {
        this.networkDenied.set(bl);
    }

    void fireCallback(Runnable runnable) {
        this.taskDistributor.execute(runnable);
    }

    String getLoadingUriForView(ImageAware imageAware) {
        return this.cacheKeysForImageAwares.get(imageAware.getId());
    }

    ReentrantLock getLockForUri(String string2) {
        ReentrantLock reentrantLock;
        ReentrantLock reentrantLock2 = reentrantLock = this.uriLocks.get(string2);
        if (reentrantLock == null) {
            reentrantLock2 = new ReentrantLock();
            this.uriLocks.put(string2, reentrantLock2);
        }
        return reentrantLock2;
    }

    AtomicBoolean getPause() {
        return this.paused;
    }

    Object getPauseLock() {
        return this.pauseLock;
    }

    void handleSlowNetwork(boolean bl) {
        this.slowNetwork.set(bl);
    }

    boolean isNetworkDenied() {
        return this.networkDenied.get();
    }

    boolean isSlowNetwork() {
        return this.slowNetwork.get();
    }

    void pause() {
        this.paused.set(true);
    }

    void prepareDisplayTaskFor(ImageAware imageAware, String string2) {
        this.cacheKeysForImageAwares.put(imageAware.getId(), string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resume() {
        this.paused.set(false);
        Object object = this.pauseLock;
        synchronized (object) {
            this.pauseLock.notifyAll();
            return;
        }
    }

    void stop() {
        if (!this.configuration.customExecutor) {
            ((ExecutorService)this.taskExecutor).shutdownNow();
        }
        if (!this.configuration.customExecutorForCachedImages) {
            ((ExecutorService)this.taskExecutorForCachedImages).shutdownNow();
        }
        this.cacheKeysForImageAwares.clear();
        this.uriLocks.clear();
    }

    void submit(final LoadAndDisplayImageTask loadAndDisplayImageTask) {
        this.taskDistributor.execute(new Runnable(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                File file = ImageLoaderEngine.this.configuration.diskCache.get(loadAndDisplayImageTask.getLoadingUri());
                boolean bl = file != null && file.exists();
                ImageLoaderEngine.this.initExecutorsIfNeed();
                if (bl) {
                    ImageLoaderEngine.this.taskExecutorForCachedImages.execute(loadAndDisplayImageTask);
                    return;
                }
                ImageLoaderEngine.this.taskExecutor.execute(loadAndDisplayImageTask);
            }
        });
    }

    void submit(ProcessAndDisplayImageTask processAndDisplayImageTask) {
        this.initExecutorsIfNeed();
        this.taskExecutorForCachedImages.execute(processAndDisplayImageTask);
    }
}

