/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.ImageLoaderEngine;
import com.nostra13.universalimageloader.core.ImageLoadingInfo;
import com.nostra13.universalimageloader.core.LoadAndDisplayImageTask;
import com.nostra13.universalimageloader.core.ProcessAndDisplayImageTask;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.LoadedFrom;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.nostra13.universalimageloader.core.imageaware.NonViewAware;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.ImageLoadingProgressListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;
import com.nostra13.universalimageloader.utils.ImageSizeUtils;
import com.nostra13.universalimageloader.utils.L;
import com.nostra13.universalimageloader.utils.MemoryCacheUtils;

public class ImageLoader {
    private static final String ERROR_INIT_CONFIG_WITH_NULL = "ImageLoader configuration can not be initialized with null";
    private static final String ERROR_NOT_INIT = "ImageLoader must be init with configuration before using";
    private static final String ERROR_WRONG_ARGUMENTS = "Wrong arguments were passed to displayImage() method (ImageView reference must not be null)";
    static final String LOG_DESTROY = "Destroy ImageLoader";
    static final String LOG_INIT_CONFIG = "Initialize ImageLoader with configuration";
    static final String LOG_LOAD_IMAGE_FROM_MEMORY_CACHE = "Load image from memory cache [%s]";
    public static final String TAG = ImageLoader.class.getSimpleName();
    private static final String WARNING_RE_INIT_CONFIG = "Try to initialize ImageLoader which had already been initialized before. To re-init ImageLoader with new configuration call ImageLoader.destroy() at first.";
    private static volatile ImageLoader instance;
    private ImageLoaderConfiguration configuration;
    private ImageLoadingListener defaultListener = new SimpleImageLoadingListener();
    private ImageLoaderEngine engine;

    protected ImageLoader() {
    }

    private void checkConfiguration() {
        if (this.configuration == null) {
            throw new IllegalStateException(ERROR_NOT_INIT);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Handler defineHandler(DisplayImageOptions displayImageOptions) {
        Handler handler = displayImageOptions.getHandler();
        if (displayImageOptions.isSyncLoading()) {
            return null;
        }
        displayImageOptions = handler;
        if (handler != null) return displayImageOptions;
        displayImageOptions = handler;
        if (Looper.myLooper() != Looper.getMainLooper()) return displayImageOptions;
        return new Handler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageLoader getInstance() {
        if (instance == null) {
            synchronized (ImageLoader.class) {
                if (instance == null) {
                    instance = new ImageLoader();
                }
            }
        }
        return instance;
    }

    public void cancelDisplayTask(ImageView imageView) {
        this.engine.cancelDisplayTaskFor(new ImageViewAware(imageView));
    }

    public void cancelDisplayTask(ImageAware imageAware) {
        this.engine.cancelDisplayTaskFor(imageAware);
    }

    @Deprecated
    public void clearDiscCache() {
        this.clearDiskCache();
    }

    public void clearDiskCache() {
        this.checkConfiguration();
        this.configuration.diskCache.clear();
    }

    public void clearMemoryCache() {
        this.checkConfiguration();
        this.configuration.memoryCache.clear();
    }

    public void denyNetworkDownloads(boolean bl) {
        this.engine.denyNetworkDownloads(bl);
    }

    public void destroy() {
        if (this.configuration != null) {
            L.d(LOG_DESTROY, new Object[0]);
        }
        this.stop();
        this.configuration.diskCache.close();
        this.engine = null;
        this.configuration = null;
    }

    public void displayImage(String string2, ImageView imageView) {
        this.displayImage(string2, new ImageViewAware(imageView), null, null, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, new ImageViewAware(imageView), displayImageOptions, null, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageView, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageView imageView, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string2, new ImageViewAware(imageView), displayImageOptions, imageLoadingListener, imageLoadingProgressListener);
    }

    public void displayImage(String string2, ImageView imageView, ImageSize imageSize) {
        this.displayImage(string2, new ImageViewAware(imageView), null, imageSize, null, null);
    }

    public void displayImage(String string2, ImageView imageView, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, new ImageViewAware(imageView), null, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageAware imageAware) {
        this.displayImage(string2, imageAware, null, null, null);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions) {
        this.displayImage(string2, imageAware, displayImageOptions, null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void displayImage(String object, ImageAware imageAware, DisplayImageOptions object2, ImageSize imageSize, ImageLoadingListener object3, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        if (imageAware == null) {
            throw new IllegalArgumentException(ERROR_WRONG_ARGUMENTS);
        }
        Object object4 = object3;
        if (object3 == null) {
            object4 = this.defaultListener;
        }
        object3 = object2;
        if (object2 == null) {
            object3 = this.configuration.defaultDisplayImageOptions;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            this.engine.cancelDisplayTaskFor(imageAware);
            object4.onLoadingStarted((String)object, imageAware.getWrappedView());
            if (((DisplayImageOptions)object3).shouldShowImageForEmptyUri()) {
                imageAware.setImageDrawable(((DisplayImageOptions)object3).getImageForEmptyUri(this.configuration.resources));
            } else {
                imageAware.setImageDrawable(null);
            }
            object4.onLoadingComplete((String)object, imageAware.getWrappedView(), null);
            return;
        }
        object2 = imageSize;
        if (imageSize == null) {
            object2 = ImageSizeUtils.defineTargetSizeForView(imageAware, this.configuration.getMaxImageSize());
        }
        String string2 = MemoryCacheUtils.generateKey((String)object, (ImageSize)object2);
        this.engine.prepareDisplayTaskFor(imageAware, string2);
        object4.onLoadingStarted((String)object, imageAware.getWrappedView());
        imageSize = this.configuration.memoryCache.get(string2);
        if (imageSize != null && !imageSize.isRecycled()) {
            L.d(LOG_LOAD_IMAGE_FROM_MEMORY_CACHE, string2);
            if (!((DisplayImageOptions)object3).shouldPostProcess()) {
                ((DisplayImageOptions)object3).getDisplayer().display((Bitmap)imageSize, imageAware, LoadedFrom.MEMORY_CACHE);
                object4.onLoadingComplete((String)object, imageAware.getWrappedView(), (Bitmap)imageSize);
                return;
            }
            object = new ImageLoadingInfo((String)object, imageAware, (ImageSize)object2, string2, (DisplayImageOptions)object3, (ImageLoadingListener)object4, imageLoadingProgressListener, this.engine.getLockForUri((String)object));
            object = new ProcessAndDisplayImageTask(this.engine, (Bitmap)imageSize, (ImageLoadingInfo)object, ImageLoader.defineHandler((DisplayImageOptions)object3));
            if (((DisplayImageOptions)object3).isSyncLoading()) {
                ((ProcessAndDisplayImageTask)object).run();
                return;
            }
            this.engine.submit((ProcessAndDisplayImageTask)object);
            return;
        }
        if (((DisplayImageOptions)object3).shouldShowImageOnLoading()) {
            imageAware.setImageDrawable(((DisplayImageOptions)object3).getImageOnLoading(this.configuration.resources));
        } else if (((DisplayImageOptions)object3).isResetViewBeforeLoading()) {
            imageAware.setImageDrawable(null);
        }
        object = new ImageLoadingInfo((String)object, imageAware, (ImageSize)object2, string2, (DisplayImageOptions)object3, (ImageLoadingListener)object4, imageLoadingProgressListener, this.engine.getLockForUri((String)object));
        object = new LoadAndDisplayImageTask(this.engine, (ImageLoadingInfo)object, ImageLoader.defineHandler((DisplayImageOptions)object3));
        if (((DisplayImageOptions)object3).isSyncLoading()) {
            ((LoadAndDisplayImageTask)object).run();
            return;
        }
        this.engine.submit((LoadAndDisplayImageTask)object);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageAware, displayImageOptions, imageLoadingListener, null);
    }

    public void displayImage(String string2, ImageAware imageAware, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.displayImage(string2, imageAware, displayImageOptions, null, imageLoadingListener, imageLoadingProgressListener);
    }

    public void displayImage(String string2, ImageAware imageAware, ImageLoadingListener imageLoadingListener) {
        this.displayImage(string2, imageAware, null, imageLoadingListener, null);
    }

    @Deprecated
    public DiskCache getDiscCache() {
        return this.getDiskCache();
    }

    public DiskCache getDiskCache() {
        this.checkConfiguration();
        return this.configuration.diskCache;
    }

    public String getLoadingUriForView(ImageView imageView) {
        return this.engine.getLoadingUriForView(new ImageViewAware(imageView));
    }

    public String getLoadingUriForView(ImageAware imageAware) {
        return this.engine.getLoadingUriForView(imageAware);
    }

    public MemoryCache getMemoryCache() {
        this.checkConfiguration();
        return this.configuration.memoryCache;
    }

    public void handleSlowNetwork(boolean bl) {
        this.engine.handleSlowNetwork(bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(ImageLoaderConfiguration imageLoaderConfiguration) {
        synchronized (this) {
            if (imageLoaderConfiguration == null) {
                throw new IllegalArgumentException(ERROR_INIT_CONFIG_WITH_NULL);
            }
            if (this.configuration == null) {
                L.d(LOG_INIT_CONFIG, new Object[0]);
                this.engine = new ImageLoaderEngine(imageLoaderConfiguration);
                this.configuration = imageLoaderConfiguration;
            } else {
                L.w(WARNING_RE_INIT_CONFIG, new Object[0]);
            }
            return;
        }
    }

    public boolean isInited() {
        return this.configuration != null;
    }

    public void loadImage(String string2, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, displayImageOptions, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageSize object, DisplayImageOptions displayImageOptions, ImageLoadingListener imageLoadingListener, ImageLoadingProgressListener imageLoadingProgressListener) {
        this.checkConfiguration();
        ImageSize imageSize = object;
        if (object == null) {
            imageSize = this.configuration.getMaxImageSize();
        }
        object = displayImageOptions;
        if (displayImageOptions == null) {
            object = this.configuration.defaultDisplayImageOptions;
        }
        this.displayImage(string2, new NonViewAware(string2, imageSize, ViewScaleType.CROP), (DisplayImageOptions)object, imageLoadingListener, imageLoadingProgressListener);
    }

    public void loadImage(String string2, ImageSize imageSize, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, imageSize, null, imageLoadingListener, null);
    }

    public void loadImage(String string2, ImageLoadingListener imageLoadingListener) {
        this.loadImage(string2, null, null, imageLoadingListener, null);
    }

    public Bitmap loadImageSync(String string2) {
        return this.loadImageSync(string2, null, null);
    }

    public Bitmap loadImageSync(String string2, DisplayImageOptions displayImageOptions) {
        return this.loadImageSync(string2, null, displayImageOptions);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize) {
        return this.loadImageSync(string2, imageSize, null);
    }

    public Bitmap loadImageSync(String string2, ImageSize imageSize, DisplayImageOptions displayImageOptions) {
        Object object = displayImageOptions;
        if (displayImageOptions == null) {
            object = this.configuration.defaultDisplayImageOptions;
        }
        displayImageOptions = new DisplayImageOptions.Builder().cloneFrom((DisplayImageOptions)object).syncLoading(true).build();
        object = new SyncImageLoadingListener();
        this.loadImage(string2, imageSize, displayImageOptions, (ImageLoadingListener)object);
        return ((SyncImageLoadingListener)object).getLoadedBitmap();
    }

    public void pause() {
        this.engine.pause();
    }

    public void resume() {
        this.engine.resume();
    }

    public void setDefaultLoadingListener(ImageLoadingListener imageLoadingListener) {
        ImageLoadingListener imageLoadingListener2 = imageLoadingListener;
        if (imageLoadingListener == null) {
            imageLoadingListener2 = new SimpleImageLoadingListener();
        }
        this.defaultListener = imageLoadingListener2;
    }

    public void stop() {
        this.engine.stop();
    }

    private static class SyncImageLoadingListener
    extends SimpleImageLoadingListener {
        private Bitmap loadedImage;

        private SyncImageLoadingListener() {
        }

        public Bitmap getLoadedBitmap() {
            return this.loadedImage;
        }

        @Override
        public void onLoadingComplete(String string2, View view, Bitmap bitmap) {
            this.loadedImage = bitmap;
        }
    }
}

