/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.core.assist.ImageScaleType;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.process.BitmapProcessor;

public final class DisplayImageOptions {
    private final boolean cacheInMemory;
    private final boolean cacheOnDisk;
    private final boolean considerExifParams;
    private final BitmapFactory.Options decodingOptions;
    private final int delayBeforeLoading;
    private final BitmapDisplayer displayer;
    private final Object extraForDownloader;
    private final Handler handler;
    private final Drawable imageForEmptyUri;
    private final Drawable imageOnFail;
    private final Drawable imageOnLoading;
    private final int imageResForEmptyUri;
    private final int imageResOnFail;
    private final int imageResOnLoading;
    private final ImageScaleType imageScaleType;
    private final boolean isSyncLoading;
    private final BitmapProcessor postProcessor;
    private final BitmapProcessor preProcessor;
    private final boolean resetViewBeforeLoading;

    private DisplayImageOptions(Builder builder) {
        this.imageResOnLoading = builder.imageResOnLoading;
        this.imageResForEmptyUri = builder.imageResForEmptyUri;
        this.imageResOnFail = builder.imageResOnFail;
        this.imageOnLoading = builder.imageOnLoading;
        this.imageForEmptyUri = builder.imageForEmptyUri;
        this.imageOnFail = builder.imageOnFail;
        this.resetViewBeforeLoading = builder.resetViewBeforeLoading;
        this.cacheInMemory = builder.cacheInMemory;
        this.cacheOnDisk = builder.cacheOnDisk;
        this.imageScaleType = builder.imageScaleType;
        this.decodingOptions = builder.decodingOptions;
        this.delayBeforeLoading = builder.delayBeforeLoading;
        this.considerExifParams = builder.considerExifParams;
        this.extraForDownloader = builder.extraForDownloader;
        this.preProcessor = builder.preProcessor;
        this.postProcessor = builder.postProcessor;
        this.displayer = builder.displayer;
        this.handler = builder.handler;
        this.isSyncLoading = builder.isSyncLoading;
    }

    public static DisplayImageOptions createSimple() {
        return new Builder().build();
    }

    public BitmapFactory.Options getDecodingOptions() {
        return this.decodingOptions;
    }

    public int getDelayBeforeLoading() {
        return this.delayBeforeLoading;
    }

    public BitmapDisplayer getDisplayer() {
        return this.displayer;
    }

    public Object getExtraForDownloader() {
        return this.extraForDownloader;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Drawable getImageForEmptyUri(Resources resources) {
        if (this.imageResForEmptyUri != 0) {
            return resources.getDrawable(this.imageResForEmptyUri);
        }
        return this.imageForEmptyUri;
    }

    public Drawable getImageOnFail(Resources resources) {
        if (this.imageResOnFail != 0) {
            return resources.getDrawable(this.imageResOnFail);
        }
        return this.imageOnFail;
    }

    public Drawable getImageOnLoading(Resources resources) {
        if (this.imageResOnLoading != 0) {
            return resources.getDrawable(this.imageResOnLoading);
        }
        return this.imageOnLoading;
    }

    public ImageScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    public BitmapProcessor getPostProcessor() {
        return this.postProcessor;
    }

    public BitmapProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public boolean isCacheInMemory() {
        return this.cacheInMemory;
    }

    public boolean isCacheOnDisk() {
        return this.cacheOnDisk;
    }

    public boolean isConsiderExifParams() {
        return this.considerExifParams;
    }

    public boolean isResetViewBeforeLoading() {
        return this.resetViewBeforeLoading;
    }

    boolean isSyncLoading() {
        return this.isSyncLoading;
    }

    public boolean shouldDelayBeforeLoading() {
        return this.delayBeforeLoading > 0;
    }

    public boolean shouldPostProcess() {
        return this.postProcessor != null;
    }

    public boolean shouldPreProcess() {
        return this.preProcessor != null;
    }

    public boolean shouldShowImageForEmptyUri() {
        return this.imageForEmptyUri != null || this.imageResForEmptyUri != 0;
    }

    public boolean shouldShowImageOnFail() {
        return this.imageOnFail != null || this.imageResOnFail != 0;
    }

    public boolean shouldShowImageOnLoading() {
        return this.imageOnLoading != null || this.imageResOnLoading != 0;
    }

    public static class Builder {
        private boolean cacheInMemory = false;
        private boolean cacheOnDisk = false;
        private boolean considerExifParams = false;
        private BitmapFactory.Options decodingOptions;
        private int delayBeforeLoading = 0;
        private BitmapDisplayer displayer;
        private Object extraForDownloader = null;
        private Handler handler = null;
        private Drawable imageForEmptyUri = null;
        private Drawable imageOnFail = null;
        private Drawable imageOnLoading = null;
        private int imageResForEmptyUri = 0;
        private int imageResOnFail = 0;
        private int imageResOnLoading = 0;
        private ImageScaleType imageScaleType = ImageScaleType.IN_SAMPLE_POWER_OF_2;
        private boolean isSyncLoading = false;
        private BitmapProcessor postProcessor = null;
        private BitmapProcessor preProcessor = null;
        private boolean resetViewBeforeLoading = false;

        public Builder() {
            this.decodingOptions = new BitmapFactory.Options();
            this.displayer = DefaultConfigurationFactory.createBitmapDisplayer();
        }

        public Builder bitmapConfig(Bitmap.Config config) {
            if (config == null) {
                throw new IllegalArgumentException("bitmapConfig can't be null");
            }
            this.decodingOptions.inPreferredConfig = config;
            return this;
        }

        public DisplayImageOptions build() {
            return new DisplayImageOptions(this);
        }

        @Deprecated
        public Builder cacheInMemory() {
            this.cacheInMemory = true;
            return this;
        }

        public Builder cacheInMemory(boolean bl) {
            this.cacheInMemory = bl;
            return this;
        }

        @Deprecated
        public Builder cacheOnDisc() {
            return this.cacheOnDisk(true);
        }

        @Deprecated
        public Builder cacheOnDisc(boolean bl) {
            return this.cacheOnDisk(bl);
        }

        public Builder cacheOnDisk(boolean bl) {
            this.cacheOnDisk = bl;
            return this;
        }

        public Builder cloneFrom(DisplayImageOptions displayImageOptions) {
            this.imageResOnLoading = displayImageOptions.imageResOnLoading;
            this.imageResForEmptyUri = displayImageOptions.imageResForEmptyUri;
            this.imageResOnFail = displayImageOptions.imageResOnFail;
            this.imageOnLoading = displayImageOptions.imageOnLoading;
            this.imageForEmptyUri = displayImageOptions.imageForEmptyUri;
            this.imageOnFail = displayImageOptions.imageOnFail;
            this.resetViewBeforeLoading = displayImageOptions.resetViewBeforeLoading;
            this.cacheInMemory = displayImageOptions.cacheInMemory;
            this.cacheOnDisk = displayImageOptions.cacheOnDisk;
            this.imageScaleType = displayImageOptions.imageScaleType;
            this.decodingOptions = displayImageOptions.decodingOptions;
            this.delayBeforeLoading = displayImageOptions.delayBeforeLoading;
            this.considerExifParams = displayImageOptions.considerExifParams;
            this.extraForDownloader = displayImageOptions.extraForDownloader;
            this.preProcessor = displayImageOptions.preProcessor;
            this.postProcessor = displayImageOptions.postProcessor;
            this.displayer = displayImageOptions.displayer;
            this.handler = displayImageOptions.handler;
            this.isSyncLoading = displayImageOptions.isSyncLoading;
            return this;
        }

        public Builder considerExifParams(boolean bl) {
            this.considerExifParams = bl;
            return this;
        }

        public Builder decodingOptions(BitmapFactory.Options options) {
            if (options == null) {
                throw new IllegalArgumentException("decodingOptions can't be null");
            }
            this.decodingOptions = options;
            return this;
        }

        public Builder delayBeforeLoading(int n2) {
            this.delayBeforeLoading = n2;
            return this;
        }

        public Builder displayer(BitmapDisplayer bitmapDisplayer) {
            if (bitmapDisplayer == null) {
                throw new IllegalArgumentException("displayer can't be null");
            }
            this.displayer = bitmapDisplayer;
            return this;
        }

        public Builder extraForDownloader(Object object) {
            this.extraForDownloader = object;
            return this;
        }

        public Builder handler(Handler handler) {
            this.handler = handler;
            return this;
        }

        public Builder imageScaleType(ImageScaleType imageScaleType) {
            this.imageScaleType = imageScaleType;
            return this;
        }

        public Builder postProcessor(BitmapProcessor bitmapProcessor) {
            this.postProcessor = bitmapProcessor;
            return this;
        }

        public Builder preProcessor(BitmapProcessor bitmapProcessor) {
            this.preProcessor = bitmapProcessor;
            return this;
        }

        public Builder resetViewBeforeLoading() {
            this.resetViewBeforeLoading = true;
            return this;
        }

        public Builder resetViewBeforeLoading(boolean bl) {
            this.resetViewBeforeLoading = bl;
            return this;
        }

        public Builder showImageForEmptyUri(int n2) {
            this.imageResForEmptyUri = n2;
            return this;
        }

        public Builder showImageForEmptyUri(Drawable drawable2) {
            this.imageForEmptyUri = drawable2;
            return this;
        }

        public Builder showImageOnFail(int n2) {
            this.imageResOnFail = n2;
            return this;
        }

        public Builder showImageOnFail(Drawable drawable2) {
            this.imageOnFail = drawable2;
            return this;
        }

        public Builder showImageOnLoading(int n2) {
            this.imageResOnLoading = n2;
            return this;
        }

        public Builder showImageOnLoading(Drawable drawable2) {
            this.imageOnLoading = drawable2;
            return this;
        }

        @Deprecated
        public Builder showStubImage(int n2) {
            this.imageResOnLoading = n2;
            return this;
        }

        Builder syncLoading(boolean bl) {
            this.isSyncLoading = bl;
            return this;
        }
    }
}

