/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.UnlimitedDiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.ext.LruDiskCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.cache.disc.naming.HashCodeFileNameGenerator;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import com.nostra13.universalimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.universalimageloader.core.assist.QueueProcessingType;
import com.nostra13.universalimageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import com.nostra13.universalimageloader.core.decode.BaseImageDecoder;
import com.nostra13.universalimageloader.core.decode.ImageDecoder;
import com.nostra13.universalimageloader.core.display.BitmapDisplayer;
import com.nostra13.universalimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.universalimageloader.core.download.BaseImageDownloader;
import com.nostra13.universalimageloader.core.download.ImageDownloader;
import com.nostra13.universalimageloader.utils.L;
import com.nostra13.universalimageloader.utils.StorageUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultConfigurationFactory {
    public static BitmapDisplayer createBitmapDisplayer() {
        return new SimpleBitmapDisplayer();
    }

    public static DiskCache createDiskCache(Context context, FileNameGenerator fileNameGenerator, long l2, int n2) {
        File file = DefaultConfigurationFactory.createReserveDiskCacheDir(context);
        if (l2 > 0L || n2 > 0) {
            Object object = StorageUtils.getIndividualCacheDirectory(context);
            try {
                object = new LruDiskCache((File)object, file, fileNameGenerator, l2, n2);
                return object;
            }
            catch (IOException iOException) {
                L.e(iOException);
            }
        }
        return new UnlimitedDiskCache(StorageUtils.getCacheDirectory(context), file, fileNameGenerator);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static Executor createExecutor(int n2, int n3, QueueProcessingType object) {
        void var2_4;
        boolean bl = object == QueueProcessingType.LIFO;
        if (bl) {
            LIFOLinkedBlockingDeque lIFOLinkedBlockingDeque = new LIFOLinkedBlockingDeque();
        } else {
            LinkedBlockingQueue linkedBlockingQueue = new LinkedBlockingQueue();
        }
        BlockingQueue blockingQueue = (BlockingQueue)var2_4;
        return new ThreadPoolExecutor(n2, n2, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)blockingQueue, DefaultConfigurationFactory.createThreadFactory(n3, "uil-pool-"));
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new HashCodeFileNameGenerator();
    }

    public static ImageDecoder createImageDecoder(boolean bl) {
        return new BaseImageDecoder(bl);
    }

    public static ImageDownloader createImageDownloader(Context context) {
        return new BaseImageDownloader(context);
    }

    public static MemoryCache createMemoryCache(Context context, int n2) {
        int n3 = n2;
        if (n2 == 0) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            n2 = n3 = activityManager.getMemoryClass();
            if (DefaultConfigurationFactory.hasHoneycomb()) {
                n2 = n3;
                if (DefaultConfigurationFactory.isLargeHeap(context)) {
                    n2 = DefaultConfigurationFactory.getLargeMemoryClass(activityManager);
                }
            }
            n3 = 0x100000 * n2 / 8;
        }
        return new LruMemoryCache(n3);
    }

    private static File createReserveDiskCacheDir(Context object) {
        File file = new File((File)(object = StorageUtils.getCacheDirectory(object, false)), "uil-images");
        if (file.exists() || file.mkdir()) {
            object = file;
        }
        return object;
    }

    public static Executor createTaskDistributor() {
        return Executors.newCachedThreadPool(DefaultConfigurationFactory.createThreadFactory(5, "uil-pool-d-"));
    }

    private static ThreadFactory createThreadFactory(int n2, String string2) {
        return new DefaultThreadFactory(n2, string2);
    }

    @TargetApi(value=11)
    private static int getLargeMemoryClass(ActivityManager activityManager) {
        return activityManager.getLargeMemoryClass();
    }

    private static boolean hasHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    @TargetApi(value=11)
    private static boolean isLargeHeap(Context context) {
        return (context.getApplicationInfo().flags & 0x100000) != 0;
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final int threadPriority;

        DefaultThreadFactory(int n2, String string2) {
            this.threadPriority = n2;
            this.group = Thread.currentThread().getThreadGroup();
            this.namePrefix = string2 + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            if (((Thread)(runnable = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L))).isDaemon()) {
                ((Thread)runnable).setDaemon(false);
            }
            ((Thread)runnable).setPriority(this.threadPriority);
            return runnable;
        }
    }
}

