/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.LimitedMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UsingFreqLimitedMemoryCache
extends LimitedMemoryCache {
    private final Map<Bitmap, Integer> usingCounts = Collections.synchronizedMap(new HashMap());

    public UsingFreqLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public void clear() {
        this.usingCounts.clear();
        super.clear();
    }

    @Override
    protected Reference<Bitmap> createReference(Bitmap bitmap) {
        return new WeakReference<Bitmap>(bitmap);
    }

    @Override
    public Bitmap get(String string2) {
        Integer n2;
        if ((string2 = super.get(string2)) != null && (n2 = this.usingCounts.get(string2)) != null) {
            this.usingCounts.put((Bitmap)string2, n2 + 1);
        }
        return string2;
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        boolean bl = false;
        if (super.put(string2, bitmap)) {
            this.usingCounts.put(bitmap, 0);
            bl = true;
        }
        return bl;
    }

    @Override
    public Bitmap remove(String string2) {
        Bitmap bitmap = super.get(string2);
        if (bitmap != null) {
            this.usingCounts.remove(bitmap);
        }
        return super.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Bitmap removeNext() {
        Object object = null;
        Bitmap bitmap = null;
        Object object2 = this.usingCounts.entrySet();
        Map<Bitmap, Integer> map = this.usingCounts;
        synchronized (map) {
            Iterator<Map.Entry<Bitmap, Integer>> iterator = object2.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 5] lbl9 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.usingCounts.remove(bitmap);
                    return bitmap;
                }
                Map.Entry<Bitmap, Integer> entry = iterator.next();
                if (bitmap == null) {
                    bitmap = entry.getKey();
                    object = entry.getValue();
                    continue;
                }
                object2 = entry.getValue();
                if ((Integer)object2 >= (Integer)object) continue;
                object = object2;
                bitmap = entry.getKey();
            }
        }
    }
}

