/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;

public class LruMemoryCache
implements MemoryCache {
    private final LinkedHashMap<String, Bitmap> map;
    private final int maxSize;
    private int size;

    public LruMemoryCache(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = n2;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    private int sizeOf(String string2, Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void trimToSize(int n2) {
        while (true) {
            synchronized (this) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= n2 || this.map.isEmpty()) {
                    return;
                }
                Bitmap bitmap = this.map.entrySet().iterator().next();
                if (bitmap == null) {
                    return;
                }
                String string2 = bitmap.getKey();
                bitmap = bitmap.getValue();
                this.map.remove(string2);
                this.size -= this.sizeOf(string2, bitmap);
            }
        }
    }

    @Override
    public void clear() {
        this.trimToSize(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Bitmap get(String string2) {
        if (string2 == null) {
            throw new NullPointerException("key == null");
        }
        synchronized (this) {
            return this.map.get(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> keys() {
        synchronized (this) {
            return new HashSet<String>(this.map.keySet());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean put(String string2, Bitmap bitmap) {
        if (string2 == null || bitmap == null) {
            throw new NullPointerException("key == null || value == null");
        }
        synchronized (this) {
            this.size += this.sizeOf(string2, bitmap);
            bitmap = this.map.put(string2, bitmap);
            if (bitmap != null) {
                this.size -= this.sizeOf(string2, bitmap);
            }
        }
        this.trimToSize(this.maxSize);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Bitmap remove(String string2) {
        if (string2 == null) {
            throw new NullPointerException("key == null");
        }
        synchronized (this) {
            Bitmap bitmap = (Bitmap)this.map.remove(string2);
            if (bitmap != null) {
                this.size -= this.sizeOf(string2, bitmap);
            }
            return bitmap;
        }
    }

    public final String toString() {
        synchronized (this) {
            String string2 = String.format("LruCache[maxSize=%d]", this.maxSize);
            return string2;
        }
    }
}

