/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeMemoryCache
implements MemoryCache {
    private final MemoryCache cache;
    private final Map<String, Long> loadingDates = Collections.synchronizedMap(new HashMap());
    private final long maxAge;

    public LimitedAgeMemoryCache(MemoryCache memoryCache, long l2) {
        this.cache = memoryCache;
        this.maxAge = 1000L * l2;
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.loadingDates.clear();
    }

    @Override
    public Bitmap get(String string2) {
        Long l2 = this.loadingDates.get(string2);
        if (l2 != null && System.currentTimeMillis() - l2 > this.maxAge) {
            this.cache.remove(string2);
            this.loadingDates.remove(string2);
        }
        return this.cache.get(string2);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        boolean bl = this.cache.put(string2, bitmap);
        if (bl) {
            this.loadingDates.put(string2, System.currentTimeMillis());
        }
        return bl;
    }

    @Override
    public Bitmap remove(String string2) {
        this.loadingDates.remove(string2);
        return this.cache.remove(string2);
    }
}

