/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.MemoryCache;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public class FuzzyKeyMemoryCache
implements MemoryCache {
    private final MemoryCache cache;
    private final Comparator<String> keyComparator;

    public FuzzyKeyMemoryCache(MemoryCache memoryCache, Comparator<String> comparator) {
        this.cache = memoryCache;
        this.keyComparator = comparator;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Bitmap get(String string2) {
        return this.cache.get(string2);
    }

    @Override
    public Collection<String> keys() {
        return this.cache.keys();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean put(String string2, Bitmap bitmap) {
        MemoryCache memoryCache = this.cache;
        synchronized (memoryCache) {
            String string3;
            String string4 = null;
            Iterator<String> iterator = this.cache.keys().iterator();
            do {
                string3 = string4;
            } while (iterator.hasNext() && this.keyComparator.compare(string2, string3 = iterator.next()) != 0);
            if (string3 != null) {
                this.cache.remove(string3);
            }
            return this.cache.put(string2, bitmap);
        }
    }

    @Override
    public Bitmap remove(String string2) {
        return this.cache.remove(string2);
    }
}

