/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.LimitedMemoryCache;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class FIFOLimitedMemoryCache
extends LimitedMemoryCache {
    private final List<Bitmap> queue = Collections.synchronizedList(new LinkedList());

    public FIFOLimitedMemoryCache(int n2) {
        super(n2);
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }

    @Override
    protected Reference<Bitmap> createReference(Bitmap bitmap) {
        return new WeakReference<Bitmap>(bitmap);
    }

    @Override
    protected int getSize(Bitmap bitmap) {
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        if (super.put(string2, bitmap)) {
            this.queue.add(bitmap);
            return true;
        }
        return false;
    }

    @Override
    public Bitmap remove(String string2) {
        Bitmap bitmap = super.get(string2);
        if (bitmap != null) {
            this.queue.remove(bitmap);
        }
        return super.remove(string2);
    }

    @Override
    protected Bitmap removeNext() {
        return this.queue.remove(0);
    }
}

