/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.memory;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.memory.BaseMemoryCache;
import com.nostra13.universalimageloader.utils.L;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class LimitedMemoryCache
extends BaseMemoryCache {
    private static final int MAX_NORMAL_CACHE_SIZE = 0x1000000;
    private static final int MAX_NORMAL_CACHE_SIZE_IN_MB = 16;
    private final AtomicInteger cacheSize;
    private final List<Bitmap> hardCache = Collections.synchronizedList(new LinkedList());
    private final int sizeLimit;

    public LimitedMemoryCache(int n2) {
        this.sizeLimit = n2;
        this.cacheSize = new AtomicInteger();
        if (n2 > 0x1000000) {
            L.w("You set too large memory cache size (more than %1$d Mb)", 16);
        }
    }

    @Override
    public void clear() {
        this.hardCache.clear();
        this.cacheSize.set(0);
        super.clear();
    }

    protected abstract int getSize(Bitmap var1);

    protected int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public boolean put(String string2, Bitmap bitmap) {
        boolean bl = false;
        int n2 = this.getSize(bitmap);
        int n3 = this.getSizeLimit();
        int n4 = this.cacheSize.get();
        if (n2 < n3) {
            while (n4 + n2 > n3) {
                Bitmap bitmap2 = this.removeNext();
                if (!this.hardCache.remove(bitmap2)) continue;
                n4 = this.cacheSize.addAndGet(-this.getSize(bitmap2));
            }
            this.hardCache.add(bitmap);
            this.cacheSize.addAndGet(n2);
            bl = true;
        }
        super.put(string2, bitmap);
        return bl;
    }

    @Override
    public Bitmap remove(String string2) {
        Bitmap bitmap = super.get(string2);
        if (bitmap != null && this.hardCache.remove(bitmap)) {
            this.cacheSize.addAndGet(-this.getSize(bitmap));
        }
        return super.remove(string2);
    }

    protected abstract Bitmap removeNext();
}

