/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl.ext;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.impl.ext.DiskLruCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.utils.IoUtils;
import com.nostra13.universalimageloader.utils.L;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LruDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NEGATIVE = " argument must be positive number";
    private static final String ERROR_ARG_NULL = " argument must be not null";
    protected int bufferSize = 32768;
    protected DiskLruCache cache;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;
    protected final FileNameGenerator fileNameGenerator;
    private File reserveCacheDir;

    public LruDiskCache(File file, FileNameGenerator fileNameGenerator, long l2) throws IOException {
        this(file, null, fileNameGenerator, l2, 0);
    }

    public LruDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2, int n2) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("cacheMaxSize argument must be positive number");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("cacheMaxFileCount argument must be positive number");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        long l3 = l2;
        if (l2 == 0L) {
            l3 = Long.MAX_VALUE;
        }
        int n3 = n2;
        if (n2 == 0) {
            n3 = Integer.MAX_VALUE;
        }
        this.reserveCacheDir = file2;
        this.fileNameGenerator = fileNameGenerator;
        this.initCache(file, file2, l3, n3);
    }

    private String getKey(String string2) {
        return this.fileNameGenerator.generate(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCache(File file, File file2, long l2, int n2) throws IOException {
        try {
            this.cache = DiskLruCache.open(file, 1, 1, l2, n2);
            return;
        }
        catch (IOException iOException) {
            L.e(iOException);
            if (file2 != null) {
                this.initCache(file2, null, l2, n2);
            }
            if (this.cache != null) return;
            throw iOException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clear() {
        try {
            this.cache.delete();
        }
        catch (IOException iOException) {
            L.e(iOException);
        }
        try {
            this.initCache(this.cache.getDirectory(), this.reserveCacheDir, this.cache.getMaxSize(), this.cache.getMaxFileCount());
            return;
        }
        catch (IOException iOException) {
            L.e(iOException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        try {
            this.cache.close();
        }
        catch (IOException iOException) {
            L.e(iOException);
        }
        this.cache = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public File get(String object) {
        Object var4_4 = null;
        File file = null;
        Object object2 = null;
        Object object3 = null;
        try {
            object = this.cache.get(this.getKey((String)object));
            if (object == null) {
                object3 = file;
            } else {
                object3 = object;
                object2 = object;
                file = ((DiskLruCache.Snapshot)object).getFile(0);
                object3 = file;
            }
            object2 = object3;
            if (object == null) return object2;
            ((DiskLruCache.Snapshot)object).close();
            return object3;
            catch (IOException iOException) {
                object2 = object3;
                L.e(iOException);
                object2 = var4_4;
                if (object3 == null) return object2;
                ((DiskLruCache.Snapshot)object3).close();
                return null;
            }
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            ((DiskLruCache.Snapshot)object2).close();
            throw throwable;
        }
    }

    @Override
    public File getDirectory() {
        return this.cache.getDirectory();
    }

    @Override
    public boolean remove(String string2) {
        try {
            boolean bl = this.cache.remove(this.getKey(string2));
            return bl;
        }
        catch (IOException iOException) {
            L.e(iOException);
            return false;
        }
    }

    @Override
    public boolean save(String object, Bitmap bitmap) throws IOException {
        boolean bl;
        DiskLruCache.Editor editor = this.cache.edit(this.getKey((String)object));
        if (editor == null) {
            return false;
        }
        object = new BufferedOutputStream(editor.newOutputStream(0), this.bufferSize);
        try {
            bl = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)object);
            if (bl) {
                editor.commit();
                return bl;
            }
        }
        finally {
            IoUtils.closeSilently((Closeable)object);
        }
        editor.abort();
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean save(String object, InputStream inputStream, IoUtils.CopyListener copyListener) throws IOException {
        boolean bl;
        if ((object = this.cache.edit(this.getKey((String)object))) == null) {
            return false;
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(((DiskLruCache.Editor)object).newOutputStream(0), this.bufferSize);
        try {
            bl = IoUtils.copyStream(inputStream, bufferedOutputStream, copyListener, this.bufferSize);
        }
        catch (Throwable throwable) {
            IoUtils.closeSilently(bufferedOutputStream);
            if (false) {
                ((DiskLruCache.Editor)object).commit();
                throw throwable;
            }
            ((DiskLruCache.Editor)object).abort();
            throw throwable;
        }
        IoUtils.closeSilently(bufferedOutputStream);
        if (bl) {
            ((DiskLruCache.Editor)object).commit();
            return bl;
        }
        ((DiskLruCache.Editor)object).abort();
        return bl;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int n2) {
        this.compressQuality = n2;
    }
}

