/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl.ext;

import com.nostra13.universalimageloader.cache.disc.impl.ext.StrictLineReader;
import com.nostra13.universalimageloader.cache.disc.impl.ext.Util;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

final class DiskLruCache
implements Closeable {
    static final long ANY_SEQUENCE_NUMBER = -1L;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static final String JOURNAL_FILE = "journal";
    static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    static final String JOURNAL_FILE_TEMP = "journal.tmp";
    static final Pattern LEGAL_KEY_PATTERN = Pattern.compile("[a-z0-9_-]{1,64}");
    static final String MAGIC = "libcore.io.DiskLruCache";
    private static final OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int n2) throws IOException {
        }
    };
    private static final String READ = "READ";
    private static final String REMOVE = "REMOVE";
    static final String VERSION_1 = "1";
    private final int appVersion;
    private final Callable<Void> cleanupCallable;
    private final File directory;
    final ThreadPoolExecutor executorService;
    private int fileCount = 0;
    private final File journalFile;
    private final File journalFileBackup;
    private final File journalFileTmp;
    private Writer journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries = new LinkedHashMap(0, 0.75f, true);
    private int maxFileCount;
    private long maxSize;
    private long nextSequenceNumber = 0L;
    private int redundantOpCount;
    private long size = 0L;
    private final int valueCount;

    private DiskLruCache(File file, int n2, int n3, long l2, int n4) {
        this.executorService = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.cleanupCallable = new Callable<Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Void call() throws Exception {
                DiskLruCache diskLruCache = DiskLruCache.this;
                synchronized (diskLruCache) {
                    if (DiskLruCache.this.journalWriter == null) {
                        return null;
                    }
                    DiskLruCache.this.trimToSize();
                    DiskLruCache.this.trimToFileCount();
                    if (DiskLruCache.this.journalRebuildRequired()) {
                        DiskLruCache.this.rebuildJournal();
                        DiskLruCache.access$502(DiskLruCache.this, 0);
                    }
                    return null;
                }
            }
        };
        this.directory = file;
        this.appVersion = n2;
        this.journalFile = new File(file, JOURNAL_FILE);
        this.journalFileTmp = new File(file, JOURNAL_FILE_TEMP);
        this.journalFileBackup = new File(file, JOURNAL_FILE_BACKUP);
        this.valueCount = n3;
        this.maxSize = l2;
        this.maxFileCount = n4;
    }

    static /* synthetic */ int access$502(DiskLruCache diskLruCache, int n2) {
        diskLruCache.redundantOpCount = n2;
        return n2;
    }

    private void checkNotClosed() {
        if (this.journalWriter == null) {
            throw new IllegalStateException("cache is closed");
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void completeEdit(Editor var1_1, boolean var2_2) throws IOException {
        synchronized (this) {
            block16: {
                var8_3 = Editor.access$1500((Editor)var1_1);
                if (Entry.access$800(var8_3) != var1_1) {
                    throw new IllegalStateException();
                }
                if (var2_2 && !Entry.access$700(var8_3)) {
                    block15: {
                        for (var3_4 = 0; var3_4 < this.valueCount; ++var3_4) {
                            if (!Editor.access$1600((Editor)var1_1)[var3_4]) {
                                var1_1.abort();
                                throw new IllegalStateException("Newly created entry didn't create value for index " + var3_4);
                            }
                            if (var8_3.getDirtyFile(var3_4).exists()) continue;
                            var1_1.abort();
                            break block15;
                        }
                        break block16;
                    }
lbl15:
                    // 3 sources

                    return;
                }
            }
            var3_4 = 0;
            while (true) {
                block18: {
                    block17: {
                        if (var3_4 >= this.valueCount) break block17;
                        var1_1 = var8_3.getDirtyFile(var3_4);
                        if (var2_2) {
                            if (var1_1.exists()) {
                                var9_7 = var8_3.getCleanFile(var3_4);
                                var1_1.renameTo(var9_7);
                                var4_5 = Entry.access$1100(var8_3)[var3_4];
                                Entry.access$1100((Entry)var8_3)[var3_4] = var6_6 = var9_7.length();
                                this.size = this.size - var4_5 + var6_6;
                                ++this.fileCount;
                            }
                            break block18;
                        } else {
                            DiskLruCache.deleteIfExists((File)var1_1);
                        }
                        break block18;
                    }
                    ++this.redundantOpCount;
                    Entry.access$802(var8_3, null);
                    if (Entry.access$700(var8_3) | var2_2) {
                        Entry.access$702(var8_3, true);
                        this.journalWriter.write("CLEAN " + Entry.access$1200(var8_3) + var8_3.getLengths() + '\n');
                        if (var2_2) {
                            var4_5 = this.nextSequenceNumber;
                            this.nextSequenceNumber = 1L + var4_5;
                            Entry.access$1302(var8_3, var4_5);
                        }
                    } else {
                        this.lruEntries.remove(Entry.access$1200(var8_3));
                        this.journalWriter.write("REMOVE " + Entry.access$1200(var8_3) + '\n');
                    }
                    this.journalWriter.flush();
                    if (this.size <= this.maxSize && this.fileCount <= this.maxFileCount && !this.journalRebuildRequired()) ** GOTO lbl15
                    this.executorService.submit(this.cleanupCallable);
                    ** continue;
                }
                ++var3_4;
            }
        }
    }

    private static void deleteIfExists(File file) throws IOException {
        if (file.exists() && !file.delete()) {
            throw new IOException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Editor edit(String string2, long l2) throws IOException {
        Object object = null;
        synchronized (this) {
            Object object2;
            this.checkNotClosed();
            this.validateKey(string2);
            Entry entry = this.lruEntries.get(string2);
            if (l2 != -1L) {
                object2 = object;
                if (entry == null) return object2;
                long l3 = entry.sequenceNumber;
                if (l3 != l2) {
                    return object;
                }
            }
            if (entry == null) {
                object2 = new Entry(string2);
                this.lruEntries.put(string2, (Entry)object2);
            } else {
                Editor editor = entry.currentEditor;
                object2 = entry;
                if (editor != null) {
                    return object;
                }
            }
            object = new Editor(this, (Entry)object2);
            Entry.access$802((Entry)object2, (Editor)object);
            this.journalWriter.write("DIRTY " + string2 + '\n');
            this.journalWriter.flush();
            return object;
        }
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        return Util.readFully(new InputStreamReader(inputStream, Util.UTF_8));
    }

    private boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DiskLruCache open(File object, int n2, int n3, long l2, int n4) throws IOException {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("maxFileCount <= 0");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("valueCount <= 0");
        }
        Object object2 = new File((File)object, JOURNAL_FILE_BACKUP);
        if (((File)object2).exists()) {
            File file = new File((File)object, JOURNAL_FILE);
            if (file.exists()) {
                ((File)object2).delete();
            } else {
                DiskLruCache.renameTo((File)object2, file, false);
            }
        }
        object2 = new DiskLruCache((File)object, n2, n3, l2, n4);
        if (((DiskLruCache)object2).journalFile.exists()) {
            try {
                super.readJournal();
                super.processJournal();
                ((DiskLruCache)object2).journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(((DiskLruCache)object2).journalFile, true), Util.US_ASCII));
                return object2;
            }
            catch (IOException iOException) {
                System.out.println("DiskLruCache " + object + " is corrupt: " + iOException.getMessage() + ", removing");
                ((DiskLruCache)object2).delete();
            }
        }
        ((File)object).mkdirs();
        object = new DiskLruCache((File)object, n2, n3, l2, n4);
        super.rebuildJournal();
        return object;
    }

    private void processJournal() throws IOException {
        DiskLruCache.deleteIfExists(this.journalFileTmp);
        Iterator<Entry> iterator = this.lruEntries.values().iterator();
        while (iterator.hasNext()) {
            int n2;
            Entry entry = iterator.next();
            if (entry.currentEditor == null) {
                for (n2 = 0; n2 < this.valueCount; ++n2) {
                    this.size += entry.lengths[n2];
                    ++this.fileCount;
                }
                continue;
            }
            Entry.access$802(entry, null);
            for (n2 = 0; n2 < this.valueCount; ++n2) {
                DiskLruCache.deleteIfExists(entry.getCleanFile(n2));
                DiskLruCache.deleteIfExists(entry.getDirtyFile(n2));
            }
            iterator.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readJournal() throws IOException {
        StrictLineReader strictLineReader;
        block8: {
            strictLineReader = new StrictLineReader(new FileInputStream(this.journalFile), Util.US_ASCII);
            String string2 = strictLineReader.readLine();
            String string3 = strictLineReader.readLine();
            String string4 = strictLineReader.readLine();
            String string5 = strictLineReader.readLine();
            String string6 = strictLineReader.readLine();
            if (!MAGIC.equals(string2)) throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            if (!VERSION_1.equals(string3)) throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            if (!Integer.toString(this.appVersion).equals(string4)) throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            if (!Integer.toString(this.valueCount).equals(string5)) throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            if (!"".equals(string6)) {
                throw new IOException("unexpected journal header: [" + string2 + ", " + string3 + ", " + string5 + ", " + string6 + "]");
            }
            break block8;
            finally {
                Util.closeQuietly(strictLineReader);
            }
        }
        int n2 = 0;
        try {
            while (true) {
                this.readJournalLine(strictLineReader.readLine());
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            this.redundantOpCount = n2 - this.lruEntries.size();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readJournalLine(String stringArray) throws IOException {
        String string2;
        Object object;
        int n2 = stringArray.indexOf(32);
        if (n2 == -1) {
            throw new IOException("unexpected journal line: " + (String)stringArray);
        }
        int n3 = n2 + 1;
        int n4 = stringArray.indexOf(32, n3);
        if (n4 == -1) {
            object = stringArray.substring(n3);
            string2 = object;
            if (n2 == REMOVE.length()) {
                string2 = object;
                if (stringArray.startsWith(REMOVE)) {
                    this.lruEntries.remove(object);
                    return;
                }
            }
        } else {
            string2 = stringArray.substring(n3, n4);
        }
        Entry entry = this.lruEntries.get(string2);
        object = entry;
        if (entry == null) {
            object = new Entry(string2);
            this.lruEntries.put(string2, (Entry)object);
        }
        if (n4 != -1 && n2 == CLEAN.length() && stringArray.startsWith(CLEAN)) {
            stringArray = stringArray.substring(n4 + 1).split(" ");
            Entry.access$702((Entry)object, true);
            Entry.access$802((Entry)object, null);
            ((Entry)object).setLengths(stringArray);
            return;
        }
        if (n4 == -1 && n2 == DIRTY.length() && stringArray.startsWith(DIRTY)) {
            Entry.access$802((Entry)object, new Editor(this, (Entry)object));
            return;
        }
        if (n4 == -1 && n2 == READ.length() && stringArray.startsWith(READ)) return;
        throw new IOException("unexpected journal line: " + (String)stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rebuildJournal() throws IOException {
        synchronized (this) {
            if (this.journalWriter != null) {
                this.journalWriter.close();
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFileTmp), Util.US_ASCII));
            try {
                bufferedWriter.write(MAGIC);
                bufferedWriter.write("\n");
                bufferedWriter.write(VERSION_1);
                bufferedWriter.write("\n");
                bufferedWriter.write(Integer.toString(this.appVersion));
                bufferedWriter.write("\n");
                bufferedWriter.write(Integer.toString(this.valueCount));
                bufferedWriter.write("\n");
                bufferedWriter.write("\n");
                for (Entry entry : this.lruEntries.values()) {
                    if (entry.currentEditor != null) {
                        bufferedWriter.write("DIRTY " + entry.key + '\n');
                        continue;
                    }
                    bufferedWriter.write("CLEAN " + entry.key + entry.getLengths() + '\n');
                }
            }
            finally {
                ((Writer)bufferedWriter).close();
            }
            if (this.journalFile.exists()) {
                DiskLruCache.renameTo(this.journalFile, this.journalFileBackup, true);
            }
            DiskLruCache.renameTo(this.journalFileTmp, this.journalFile, false);
            this.journalFileBackup.delete();
            this.journalWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.journalFile, true), Util.US_ASCII));
            return;
        }
    }

    private static void renameTo(File file, File file2, boolean bl) throws IOException {
        if (bl) {
            DiskLruCache.deleteIfExists(file2);
        }
        if (!file.renameTo(file2)) {
            throw new IOException();
        }
    }

    private void trimToFileCount() throws IOException {
        while (this.fileCount > this.maxFileCount) {
            this.remove(this.lruEntries.entrySet().iterator().next().getKey());
        }
    }

    private void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            this.remove(this.lruEntries.entrySet().iterator().next().getKey());
        }
    }

    private void validateKey(String string2) {
        if (!LEGAL_KEY_PATTERN.matcher(string2).matches()) {
            throw new IllegalArgumentException("keys must match regex [a-z0-9_-]{1,64}: \"" + string2 + "\"");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        synchronized (this) {
            Writer writer = this.journalWriter;
            if (writer != null) {
                for (Entry entry : new ArrayList<Entry>(this.lruEntries.values())) {
                    if (entry.currentEditor == null) continue;
                    entry.currentEditor.abort();
                }
                this.trimToSize();
                this.trimToFileCount();
                this.journalWriter.close();
                this.journalWriter = null;
            }
            return;
        }
    }

    public void delete() throws IOException {
        this.close();
        Util.deleteContents(this.directory);
    }

    public Editor edit(String string2) throws IOException {
        return this.edit(string2, -1L);
    }

    public long fileCount() {
        synchronized (this) {
            int n2 = this.fileCount;
            long l2 = n2;
            return l2;
        }
    }

    public void flush() throws IOException {
        synchronized (this) {
            this.checkNotClosed();
            this.trimToSize();
            this.trimToFileCount();
            this.journalWriter.flush();
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Snapshot get(String var1_1) throws IOException {
        var4_4 = null;
        synchronized (this) {
            block16: {
                block15: {
                    this.checkNotClosed();
                    this.validateKey(var1_1);
                    var6_5 = this.lruEntries.get(var1_1);
                    if (var6_5 != null) break block15;
                    var3_6 /* !! */  = var4_4;
lbl9:
                    // 5 sources

                    return var3_6 /* !! */ ;
                }
                var3_6 /* !! */  = var4_4;
                if (!Entry.access$700(var6_5)) ** GOTO lbl9
                var3_6 /* !! */  = new File[this.valueCount];
                var5_7 = new InputStream[this.valueCount];
                var2_8 = 0;
                while (true) {
                    if (var2_8 >= this.valueCount) break block16;
                    var3_6 /* !! */ [var2_8] = var7_9 = var6_5.getCleanFile(var2_8);
                    var5_7[var2_8] = new FileInputStream(var7_9);
                    ++var2_8;
                    continue;
                    break;
                }
                catch (FileNotFoundException var1_2) {
                    var2_8 = 0;
                    while (true) {
                        var3_6 /* !! */  = var4_4;
                        if (var2_8 >= this.valueCount) ** GOTO lbl9
                        var3_6 /* !! */  = var4_4;
                        if (var5_7[var2_8] == null) ** GOTO lbl9
                        Util.closeQuietly(var5_7[var2_8]);
                        ++var2_8;
                        continue;
                        break;
                    }
                }
            }
            ++this.redundantOpCount;
            this.journalWriter.append("READ " + var1_1 + '\n');
            if (this.journalRebuildRequired()) {
                this.executorService.submit(this.cleanupCallable);
            }
            var3_6 /* !! */  = new Snapshot(var1_1, Entry.access$1300(var6_5), var3_6 /* !! */ , var5_7, Entry.access$1100(var6_5));
            ** continue;
            {
                catch (Throwable var1_3) {
                    throw var1_3;
                }
            }
            finally {
            }
        }
    }

    public File getDirectory() {
        return this.directory;
    }

    public int getMaxFileCount() {
        synchronized (this) {
            int n2 = this.maxFileCount;
            return n2;
        }
    }

    public long getMaxSize() {
        synchronized (this) {
            long l2 = this.maxSize;
            return l2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isClosed() {
        synchronized (this) {
            Writer writer = this.journalWriter;
            if (writer != null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(String string2) throws IOException {
        synchronized (this) {
            this.checkNotClosed();
            this.validateKey(string2);
            Entry entry = this.lruEntries.get(string2);
            if (entry == null) return false;
            Object object = entry.currentEditor;
            if (object != null) {
                return false;
            }
            for (int i2 = 0; i2 < this.valueCount; this.size -= entry.lengths[i2], --this.fileCount, ++i2) {
                object = entry.getCleanFile(i2);
                if (((File)object).exists() && !((File)object).delete()) {
                    throw new IOException("failed to delete " + object);
                }
                ((Entry)entry).lengths[i2] = 0L;
            }
            ++this.redundantOpCount;
            this.journalWriter.append("REMOVE " + string2 + '\n');
            this.lruEntries.remove(string2);
            if (!this.journalRebuildRequired()) return true;
            this.executorService.submit(this.cleanupCallable);
            return true;
        }
    }

    public void setMaxSize(long l2) {
        synchronized (this) {
            this.maxSize = l2;
            this.executorService.submit(this.cleanupCallable);
            return;
        }
    }

    public long size() {
        synchronized (this) {
            long l2 = this.size;
            return l2;
        }
    }

    public static final class Editor {
        private boolean committed;
        private final Entry entry;
        private boolean hasErrors;
        final /* synthetic */ DiskLruCache this$0;
        private final boolean[] written;

        /*
         * Enabled aggressive block sorting
         */
        private Editor(DiskLruCache object, Entry entry) {
            this.this$0 = object;
            this.entry = entry;
            object = entry.readable ? null : (Object)new boolean[((DiskLruCache)object).valueCount];
            this.written = (boolean[])object;
        }

        static /* synthetic */ Entry access$1500(Editor editor) {
            return editor.entry;
        }

        static /* synthetic */ boolean[] access$1600(Editor editor) {
            return editor.written;
        }

        static /* synthetic */ boolean access$2402(Editor editor, boolean bl) {
            editor.hasErrors = bl;
            return bl;
        }

        public void abort() throws IOException {
            this.this$0.completeEdit(this, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void abortUnlessCommitted() {
            if (this.committed) return;
            try {
                this.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void commit() throws IOException {
            if (this.hasErrors) {
                this.this$0.completeEdit(this, false);
                this.this$0.remove(this.entry.key);
            } else {
                this.this$0.completeEdit(this, true);
            }
            this.committed = true;
        }

        public String getString(int n2) throws IOException {
            InputStream inputStream = this.newInputStream(n2);
            if (inputStream != null) {
                return DiskLruCache.inputStreamToString(inputStream);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public InputStream newInputStream(int n2) throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    return null;
                }
                try {
                    return new FileInputStream(this.entry.getCleanFile(n2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public OutputStream newOutputStream(int n2) throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            synchronized (diskLruCache) {
                OutputStream outputStream;
                if (this.entry.currentEditor != this) {
                    throw new IllegalStateException();
                }
                if (!this.entry.readable) {
                    this.written[n2] = true;
                }
                File file = this.entry.getDirtyFile(n2);
                try {
                    outputStream = new FileOutputStream(file);
                    return new FaultHidingOutputStream(outputStream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.this$0.directory.mkdirs();
                    try {
                        outputStream = new FileOutputStream(file);
                        return new FaultHidingOutputStream(outputStream);
                    }
                    catch (FileNotFoundException fileNotFoundException2) {
                        return NULL_OUTPUT_STREAM;
                    }
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void set(int n2, String object) throws IOException {
            Object var4_3 = null;
            Object object2 = new OutputStreamWriter(this.newOutputStream(n2), Util.UTF_8);
            ((Writer)object2).write((String)object);
            Util.closeQuietly((Closeable)object2);
            return;
            catch (Throwable throwable) {
                block4: {
                    object = var4_3;
                    break block4;
                    catch (Throwable throwable2) {
                        object = object2;
                        object2 = throwable2;
                    }
                }
                Util.closeQuietly((Closeable)object);
                throw object2;
            }
        }

        private class FaultHidingOutputStream
        extends FilterOutputStream {
            private FaultHidingOutputStream(OutputStream outputStream) {
                super(outputStream);
            }

            @Override
            public void close() {
                try {
                    this.out.close();
                    return;
                }
                catch (IOException iOException) {
                    Editor.access$2402(Editor.this, true);
                    return;
                }
            }

            @Override
            public void flush() {
                try {
                    this.out.flush();
                    return;
                }
                catch (IOException iOException) {
                    Editor.access$2402(Editor.this, true);
                    return;
                }
            }

            @Override
            public void write(int n2) {
                try {
                    this.out.write(n2);
                    return;
                }
                catch (IOException iOException) {
                    Editor.access$2402(Editor.this, true);
                    return;
                }
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) {
                try {
                    this.out.write(byArray, n2, n3);
                    return;
                }
                catch (IOException iOException) {
                    Editor.access$2402(Editor.this, true);
                    return;
                }
            }
        }
    }

    private final class Entry {
        private Editor currentEditor;
        private final String key;
        private final long[] lengths;
        private boolean readable;
        private long sequenceNumber;

        private Entry(String string2) {
            this.key = string2;
            this.lengths = new long[DiskLruCache.this.valueCount];
        }

        static /* synthetic */ long access$1302(Entry entry, long l2) {
            entry.sequenceNumber = l2;
            return l2;
        }

        static /* synthetic */ boolean access$702(Entry entry, boolean bl) {
            entry.readable = bl;
            return bl;
        }

        static /* synthetic */ Editor access$802(Entry entry, Editor editor) {
            entry.currentEditor = editor;
            return editor;
        }

        private IOException invalidLengths(String[] stringArray) throws IOException {
            throw new IOException("unexpected journal line: " + Arrays.toString(stringArray));
        }

        private void setLengths(String[] stringArray) throws IOException {
            if (stringArray.length != DiskLruCache.this.valueCount) {
                throw this.invalidLengths(stringArray);
            }
            int n2 = 0;
            while (true) {
                try {
                    if (n2 >= stringArray.length) break;
                    this.lengths[n2] = Long.parseLong(stringArray[n2]);
                    ++n2;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.invalidLengths(stringArray);
                }
            }
        }

        public File getCleanFile(int n2) {
            return new File(DiskLruCache.this.directory, this.key + "" + n2);
        }

        public File getDirtyFile(int n2) {
            return new File(DiskLruCache.this.directory, this.key + "" + n2 + ".tmp");
        }

        public String getLengths() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            for (long l2 : this.lengths) {
                stringBuilder.append(' ').append(l2);
            }
            return stringBuilder.toString();
        }
    }

    public final class Snapshot
    implements Closeable {
        private File[] files;
        private final InputStream[] ins;
        private final String key;
        private final long[] lengths;
        private final long sequenceNumber;

        private Snapshot(String string2, long l2, File[] fileArray, InputStream[] inputStreamArray, long[] lArray) {
            this.key = string2;
            this.sequenceNumber = l2;
            this.files = fileArray;
            this.ins = inputStreamArray;
            this.lengths = lArray;
        }

        @Override
        public void close() {
            InputStream[] inputStreamArray = this.ins;
            int n2 = inputStreamArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Util.closeQuietly(inputStreamArray[i2]);
            }
        }

        public Editor edit() throws IOException {
            return DiskLruCache.this.edit(this.key, this.sequenceNumber);
        }

        public File getFile(int n2) {
            return this.files[n2];
        }

        public InputStream getInputStream(int n2) {
            return this.ins[n2];
        }

        public long getLength(int n2) {
            return this.lengths[n2];
        }

        public String getString(int n2) throws IOException {
            return DiskLruCache.inputStreamToString(this.getInputStream(n2));
        }
    }
}

