/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.disc.impl.BaseDiskCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.utils.IoUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class LimitedAgeDiskCache
extends BaseDiskCache {
    private final Map<File, Long> loadingDates = Collections.synchronizedMap(new HashMap());
    private final long maxFileAge;

    public LimitedAgeDiskCache(File file, long l2) {
        this(file, null, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, long l2) {
        this(file, file2, DefaultConfigurationFactory.createFileNameGenerator(), l2);
    }

    public LimitedAgeDiskCache(File file, File file2, FileNameGenerator fileNameGenerator, long l2) {
        super(file, file2, fileNameGenerator);
        this.maxFileAge = 1000L * l2;
    }

    private void rememberUsage(String object) {
        object = this.getFile((String)object);
        long l2 = System.currentTimeMillis();
        ((File)object).setLastModified(l2);
        this.loadingDates.put((File)object, l2);
    }

    @Override
    public void clear() {
        super.clear();
        this.loadingDates.clear();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public File get(String object) {
        boolean bl;
        File file = super.get((String)object);
        if (file == null || !file.exists()) return file;
        object = this.loadingDates.get(file);
        if (object == null) {
            bl = false;
            object = file.lastModified();
        } else {
            bl = true;
        }
        if (System.currentTimeMillis() - (Long)object > this.maxFileAge) {
            file.delete();
            this.loadingDates.remove(file);
            return file;
        } else {
            if (bl) return file;
            this.loadingDates.put(file, (Long)object);
            return file;
        }
    }

    @Override
    public boolean remove(String string2) {
        this.loadingDates.remove(this.getFile(string2));
        return super.remove(string2);
    }

    @Override
    public boolean save(String string2, Bitmap bitmap) throws IOException {
        boolean bl = super.save(string2, bitmap);
        this.rememberUsage(string2);
        return bl;
    }

    @Override
    public boolean save(String string2, InputStream inputStream, IoUtils.CopyListener copyListener) throws IOException {
        boolean bl = super.save(string2, inputStream, copyListener);
        this.rememberUsage(string2);
        return bl;
    }
}

