/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.cache.disc.impl;

import android.graphics.Bitmap;
import com.nostra13.universalimageloader.cache.disc.DiskCache;
import com.nostra13.universalimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.universalimageloader.core.DefaultConfigurationFactory;
import com.nostra13.universalimageloader.utils.IoUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseDiskCache
implements DiskCache {
    public static final int DEFAULT_BUFFER_SIZE = 32768;
    public static final Bitmap.CompressFormat DEFAULT_COMPRESS_FORMAT = Bitmap.CompressFormat.PNG;
    public static final int DEFAULT_COMPRESS_QUALITY = 100;
    private static final String ERROR_ARG_NULL = " argument must be not null";
    private static final String TEMP_IMAGE_POSTFIX = ".tmp";
    protected int bufferSize = 32768;
    protected final File cacheDir;
    protected Bitmap.CompressFormat compressFormat = DEFAULT_COMPRESS_FORMAT;
    protected int compressQuality = 100;
    protected final FileNameGenerator fileNameGenerator;
    protected final File reserveCacheDir;

    public BaseDiskCache(File file) {
        this(file, null);
    }

    public BaseDiskCache(File file, File file2) {
        this(file, file2, DefaultConfigurationFactory.createFileNameGenerator());
    }

    public BaseDiskCache(File file, File file2, FileNameGenerator fileNameGenerator) {
        if (file == null) {
            throw new IllegalArgumentException("cacheDir argument must be not null");
        }
        if (fileNameGenerator == null) {
            throw new IllegalArgumentException("fileNameGenerator argument must be not null");
        }
        this.cacheDir = file;
        this.reserveCacheDir = file2;
        this.fileNameGenerator = fileNameGenerator;
    }

    @Override
    public void clear() {
        File[] fileArray = this.cacheDir.listFiles();
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                fileArray[i2].delete();
            }
        }
    }

    @Override
    public void close() {
    }

    @Override
    public File get(String string2) {
        return this.getFile(string2);
    }

    @Override
    public File getDirectory() {
        return this.cacheDir;
    }

    protected File getFile(String object) {
        String string2;
        block2: {
            block3: {
                string2 = this.fileNameGenerator.generate((String)object);
                File file = this.cacheDir;
                object = file;
                if (this.cacheDir.exists()) break block2;
                object = file;
                if (this.cacheDir.mkdirs()) break block2;
                object = file;
                if (this.reserveCacheDir == null) break block2;
                if (this.reserveCacheDir.exists()) break block3;
                object = file;
                if (!this.reserveCacheDir.mkdirs()) break block2;
            }
            object = this.reserveCacheDir;
        }
        return new File((File)object, string2);
    }

    @Override
    public boolean remove(String string2) {
        return this.getFile(string2).delete();
    }

    @Override
    public boolean save(String object, Bitmap bitmap) throws IOException {
        boolean bl;
        object = this.getFile((String)object);
        File file = new File(((File)object).getAbsolutePath() + TEMP_IMAGE_POSTFIX);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
        try {
            bl = bitmap.compress(this.compressFormat, this.compressQuality, (OutputStream)bufferedOutputStream);
        }
        catch (Throwable throwable) {
            IoUtils.closeSilently(bufferedOutputStream);
            if (!false || !file.renameTo((File)object)) {
                // empty if block
            }
            if (!false) {
                file.delete();
            }
            throw throwable;
        }
        IoUtils.closeSilently(bufferedOutputStream);
        boolean bl2 = bl;
        if (bl) {
            bl2 = bl;
            if (!file.renameTo((File)object)) {
                bl2 = false;
            }
        }
        if (!bl2) {
            file.delete();
        }
        bitmap.recycle();
        return bl2;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean save(String object, InputStream inputStream, IoUtils.CopyListener copyListener) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        boolean bl;
        boolean bl2;
        block12: {
            object = this.getFile((String)object);
            File file = new File(((File)object).getAbsolutePath() + TEMP_IMAGE_POSTFIX);
            bl = bl2 = false;
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file), this.bufferSize);
            {
                catch (Throwable throwable) {
                    bl2 = bl;
                    if (bl) {
                        bl2 = bl;
                        if (!file.renameTo((File)object)) {
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        file.delete();
                    }
                    throw throwable;
                }
            }
            bl = bl2 = (bl = IoUtils.copyStream(inputStream, bufferedOutputStream, copyListener, this.bufferSize));
            IoUtils.closeSilently(bufferedOutputStream);
            bl = bl2;
            if (bl2) {
                bl = bl2;
                if (!file.renameTo((File)object)) {
                    bl = false;
                }
            }
            if (bl) break block12;
            file.delete();
        }
        return bl;
        catch (Throwable throwable) {
            bl = bl2;
            IoUtils.closeSilently(bufferedOutputStream);
            bl = bl2;
            throw throwable;
        }
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public void setCompressFormat(Bitmap.CompressFormat compressFormat) {
        this.compressFormat = compressFormat;
    }

    public void setCompressQuality(int n2) {
        this.compressQuality = n2;
    }
}

