/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.virtualdisk;

import com.mob.tools.virtualdisk.VirtualDisk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class RamDisk
extends VirtualDisk {
    private byte[][] bbBlocks;
    private ByteBuffer bbNode;
    private int size;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void addFileToDirectory(int n2, String string2, int n3) throws Throwable {
        byte[] byArray = this.readDirectoryData(n2);
        DataOutputStream dataOutputStream = new DataOutputStream(new RDFileOutputStream(this, n2));
        if (byArray == null) {
            dataOutputStream.writeInt(1);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            byteBuffer.putInt(0, byteBuffer.getInt(0) + 1);
            dataOutputStream.write(byArray);
        }
        dataOutputStream.writeUTF(string2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.close();
    }

    public void create(int n2) throws Throwable {
        synchronized (this) {
            this.size = n2;
            n2 = (n2 - 4) / 1032;
            this.bbNode = ByteBuffer.allocate(n2 * 8);
            this.bbNode.order(ByteOrder.BIG_ENDIAN);
            this.bbBlocks = new byte[n2][];
            return;
        }
    }

    public void dumpToFile(String string2) throws Throwable {
        synchronized (this) {
            this.dumpToFile(string2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpToFile(String object, boolean bl) throws Throwable {
        synchronized (this) {
            Object object2 = new File((String)object);
            if (((File)object2).exists()) {
                if (!bl) {
                    throw new Throwable("file \"" + (String)object + "\" already exists");
                }
                ((File)object2).delete();
            }
            if (!((File)object2).getParentFile().exists()) {
                ((File)object2).getParentFile().mkdirs();
            }
            ((File)object2).createNewFile();
            object = new RandomAccessFile((String)object, "rw");
            object2 = ((RandomAccessFile)object).getChannel();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, 0L, 4L);
            mappedByteBuffer.order(ByteOrder.BIG_ENDIAN);
            mappedByteBuffer.putInt(this.size);
            mappedByteBuffer.force();
            int n2 = this.bbNode.limit();
            mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, 4L, n2);
            mappedByteBuffer.put(this.bbNode.array());
            mappedByteBuffer.force();
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n4 < this.bbNode.limit()) {
                    if (this.bbNode.get(n4) != 0) {
                        n3 = n4;
                    }
                } else {
                    n4 = 0;
                    n3 /= 8;
                    while (true) {
                        if (n4 > n3) {
                            ((RandomAccessFile)object).close();
                            return;
                        }
                        mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, n4 * 1024 + (n2 + 4), 1024L);
                        if (this.bbBlocks[n4] != null) {
                            mappedByteBuffer.put(this.bbBlocks[n4]);
                        }
                        mappedByteBuffer.force();
                        ++n4;
                    }
                }
                n4 += 8;
            }
        }
    }

    @Override
    public void format() throws Throwable {
        synchronized (this) {
            byte[] byArray = new byte[8];
            for (int i2 = 0; i2 < this.bbNode.limit(); i2 += 8) {
                this.bbNode.put(byArray);
            }
            this.bbNode.put(0, (byte)1);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getInputStream(String object) throws Throwable {
        Object var3_3 = null;
        synchronized (this) {
            int n2;
            block6: {
                n2 = this.pathToId(this.fixSlashes((String)object));
                if (n2 != -1) break block6;
                return var3_3;
            }
            object = var3_3;
            if (this.bbNode.get(n2 * 8 + 1) == 0) return object;
            object = new RDFileInputStream(this, n2);
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OutputStream getOutputStream(String object) throws Throwable {
        Object var3_3 = null;
        synchronized (this) {
            int n2;
            block6: {
                n2 = this.pathToId(this.fixSlashes((String)object));
                if (n2 != -1) break block6;
                return var3_3;
            }
            object = var3_3;
            if (this.bbNode.get(n2 * 8 + 1) == 0) return object;
            object = new RDFileOutputStream(this, n2);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFile(String string2) throws Throwable {
        synchronized (this) {
            string2 = this.fixSlashes(string2);
            int n2 = this.pathToId(string2);
            if (n2 == -1) {
                throw new Throwable("file \"" + string2 + "\" does not exist");
            }
            if ((n2 = (int)this.bbNode.get(n2 * 8 + 1)) == 0) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int length(String string2) throws Throwable {
        synchronized (this) {
            int n2;
            int n3;
            int n4;
            block12: {
                block11: {
                    string2 = this.fixSlashes(string2);
                    n4 = this.pathToId(string2);
                    if (n4 != -1) break block11;
                    return 0;
                }
                n3 = this.bbNode.get(n4 * 8 + 1);
                n2 = 0;
                if (n3 != 0) break block12;
                String[] stringArray = this.list(string2);
                if (stringArray == null) return 0;
                if (stringArray.length == 0) return 0;
                int n5 = stringArray.length;
                n3 = 0;
                while (true) {
                    n4 = n2;
                    if (n3 >= n5) return n4;
                    String string3 = stringArray[n3];
                    n2 += this.length(string2 + "/" + string3);
                    ++n3;
                    continue;
                    break;
                }
            }
            n2 = this.bbNode.getShort(n4 * 8 + 2);
            n3 = this.bbNode.getInt(n4 * 8 + 4);
            while (true) {
                n4 = n2;
                if (n3 == 0) return n4;
                n2 += this.bbNode.getShort(n3 * 8 + 2);
                n3 = this.bbNode.getInt(n3 * 8 + 4);
                continue;
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] list(String stringArray) throws Throwable {
        synchronized (this) {
            DataInputStream dataInputStream;
            block12: {
                int n2;
                block11: {
                    n2 = this.pathToId(this.fixSlashes((String)stringArray));
                    if (n2 != -1) break block11;
                    return null;
                }
                String[] stringArray2 = null;
                dataInputStream = null;
                stringArray = dataInputStream;
                if (this.bbNode.get(n2 * 8 + 1) != 0) return stringArray;
                byte[] byArray = this.readDirectoryData(n2);
                stringArray = dataInputStream;
                if (byArray == null) return stringArray;
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n3 = dataInputStream.readInt();
                stringArray = stringArray2;
                if (n3 <= 0) break block12;
                stringArray2 = new String[n3];
                n2 = 0;
                while (true) {
                    stringArray = stringArray2;
                    if (n2 >= n3) break;
                    stringArray2[n2] = dataInputStream.readUTF();
                    dataInputStream.readInt();
                    ++n2;
                    continue;
                    break;
                }
            }
            try {
                dataInputStream.close();
                return stringArray;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile(String object) throws Throwable {
        synchronized (this) {
            if (!new File((String)object).exists()) {
                throw new Throwable("file \"" + (String)object + "\" does not exist");
            }
            object = new RandomAccessFile((String)object, "rw");
            Object object2 = ((RandomAccessFile)object).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 4L);
            ((ByteBuffer)object2).order(ByteOrder.BIG_ENDIAN);
            int n2 = (((ByteBuffer)object2).getInt(0) - 4) / 1032;
            int n3 = n2 * 8;
            object2 = new byte[n3];
            ((RandomAccessFile)object).seek(4L);
            ((RandomAccessFile)object).readFully((byte[])object2);
            this.bbNode = ByteBuffer.wrap((byte[])object2);
            this.bbBlocks = new byte[n2][];
            n2 = 0;
            while (true) {
                if (n2 >= this.bbNode.limit()) {
                    ((RandomAccessFile)object).close();
                    return;
                }
                if (this.bbNode.get(n2) != 0) {
                    int n4 = n2 / 8;
                    this.bbBlocks[n4] = new byte[1024];
                    ((RandomAccessFile)object).seek(n4 * 1024 + (n3 + 4));
                    ((RandomAccessFile)object).readFully(this.bbBlocks[n4]);
                }
                n2 += 8;
            }
        }
    }

    /*
     * WARNING - combined exceptions agressively - possible behaviour change.
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mkdir(String stringArray) throws Throwable {
        synchronized (this) {
            int n2;
            stringArray = this.splitPath(this.fixSlashes((String)stringArray));
            int n3 = n2 = -1;
            boolean bl = true;
            while (true) {
                int n4;
                block7: {
                    block11: {
                        block9: {
                            String string2;
                            block10: {
                                int n5;
                                block8: {
                                    if (!bl || (bl = false)) break block8;
                                    if (stringArray == null) break block9;
                                    n5 = stringArray.length;
                                    n4 = 0;
                                }
                                n3 = n2;
                                if (n4 >= n5) break block9;
                                string2 = stringArray[n4];
                                if (!"/".equals(string2)) break block10;
                                if (this.readDirectoryData(0) == null) {
                                    this.bbNode.put(0, (byte)1);
                                    this.bbNode.put(1, (byte)0);
                                    this.bbNode.putShort(2, (short)0);
                                    this.bbNode.putInt(4, 0);
                                }
                                break block11;
                            }
                            n3 = n2;
                            if (n2 != -1 && (n3 = this.nameToId(n2, string2)) == -1) {
                                n3 = this.nextFreeId();
                                if (n3 != -1) {
                                    this.bbNode.put(n3 * 8, (byte)1);
                                    this.bbNode.put(n3 * 8 + 1, (byte)0);
                                    this.bbNode.putShort(n3 * 8 + 2, (short)0);
                                    this.bbNode.putInt(n3 * 8 + 4, 0);
                                    this.addFileToDirectory(n2, string2, n3);
                                    break block7;
                                } else {
                                    n3 = -1;
                                }
                            }
                            break block7;
                        }
                        if (n3 == -1) return false;
                        return true;
                    }
                    n3 = 0;
                }
                ++n4;
                n2 = n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mv(String string2, String string3) throws Throwable {
        synchronized (this) {
            int n2;
            int n3;
            int n4;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        string2 = this.fixSlashes(string2);
                                        boolean bl = string2.equals("/");
                                        if (!bl) break block10;
                                        return false;
                                    }
                                    n4 = this.pathToId(string2);
                                    if (n4 != -1) break block11;
                                    return false;
                                }
                                string3 = this.fixSlashes(string3);
                                if (!string3.equals("/")) break block12;
                                return false;
                            }
                            if (this.pathToId(string3) == -1) break block13;
                            return false;
                        }
                        n3 = string3.lastIndexOf(47);
                        if (n3 >= 0) break block14;
                        return false;
                    }
                    n2 = this.pathToId(this.fixSlashes(string3.substring(0, n3 + 1)));
                    if (n2 != -1) break block15;
                    return false;
                }
                string3 = string3.substring(n3 + 1);
                n3 = string2.lastIndexOf(47);
                if (n3 >= 0) break block16;
                return false;
            }
            this.removeFileFromDirectory(this.pathToId(this.fixSlashes(string2.substring(0, n3 + 1))), n4);
            this.addFileToDirectory(n2, string3, n4);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean newFile(String string2) throws Throwable {
        boolean bl = false;
        synchronized (this) {
            int n2;
            block8: {
                n2 = string2.lastIndexOf(47);
                if (n2 >= 0) break block8;
                return bl;
            }
            String string3 = string2.substring(n2 + 1);
            boolean bl2 = bl;
            if (string3.length() <= 0) return bl2;
            string2 = this.fixSlashes(string2.substring(0, n2 + 1));
            bl2 = bl;
            if (!this.mkdir(string2)) return bl2;
            n2 = this.pathToId(string2);
            bl2 = bl;
            if (this.nameToId(n2, string3) != -1) return bl2;
            int n3 = this.nextFreeId();
            bl2 = bl;
            if (n3 == -1) return bl2;
            this.bbNode.put(n3 * 8, (byte)1);
            this.bbNode.put(n3 * 8 + 1, (byte)1);
            this.bbNode.putShort(n3 * 8 + 2, (short)0);
            this.bbNode.putInt(n3 * 8 + 4, 0);
            this.addFileToDirectory(n2, string3, n3);
            return true;
        }
    }

    @Override
    protected int nextFreeId() {
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block4: {
                int n4;
                block3: {
                    n4 = n2;
                    if (n3 >= this.bbNode.limit()) break block3;
                    if (this.bbNode.get(n3) != 0) break block4;
                    n4 = n3 / 8;
                }
                return n4;
            }
            n3 += 8;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] readDirectoryData(int n2) throws Throwable {
        int n3 = n2 * 8;
        if (this.bbNode.get(n3) == 0) {
            return null;
        }
        if (this.bbNode.get(n3 + 1) != 0) return null;
        Object object = new RDFileInputStream(this, n2);
        Object object2 = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        n2 = ((InputStream)object).read(byArray);
        while (n2 > 0) {
            ((ByteArrayOutputStream)object2).write(byArray, 0, n2);
            n2 = ((InputStream)object).read(byArray);
        }
        ((InputStream)object).close();
        ((ByteArrayOutputStream)object2).close();
        object = object2 = (Object)((ByteArrayOutputStream)object2).toByteArray();
        if (((Object)object2).length != 0) return object;
        return null;
    }

    @Override
    protected void removeFileFromDirectory(int n2, int n3) throws Throwable {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.readDirectoryData(n2)));
        DataOutputStream dataOutputStream = new DataOutputStream(new RDFileOutputStream(this, n2));
        int n4 = dataInputStream.readInt();
        dataOutputStream.writeInt(n4 - 1);
        for (n2 = 0; n2 < n4; ++n2) {
            String string2 = dataInputStream.readUTF();
            int n5 = dataInputStream.readInt();
            if (n5 == n3) continue;
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeInt(n5);
        }
        dataInputStream.close();
        dataOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rm(String string2) throws Throwable {
        synchronized (this) {
            String string3 = this.fixSlashes(string2);
            if ("/".equals(string3)) {
                throw new Throwable("can not remove directory \"/\"");
            }
            int n2 = this.pathToId(string3);
            if (n2 != -1) {
                int n3;
                Object object;
                if (this.bbNode.get(n2 * 8 + 1) == 0 && (object = this.readDirectoryData(n2)) != null) {
                    object = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    n3 = ((DataInputStream)object).readInt();
                    ((FilterInputStream)object).close();
                    if (n3 > 0) {
                        throw new Throwable("directory \"" + string2 + "\" is not empty");
                    }
                }
                n3 = this.bbNode.getInt(n2 * 8 + 4);
                this.bbNode.put(n2 * 8, (byte)0);
                this.bbNode.put(n2 * 8 + 1, (byte)0);
                this.bbNode.putShort(n2 * 8 + 2, (short)0);
                this.bbNode.putInt(n2 * 8 + 4, 0);
                while (n3 != 0) {
                    n3 = this.bbNode.getInt(n3 * 8 + 4);
                    this.bbNode.put(n3 * 8, (byte)0);
                    this.bbNode.put(n3 * 8 + 1, (byte)0);
                    this.bbNode.putShort(n3 * 8 + 2, (short)0);
                    this.bbNode.putInt(n3 * 8 + 4, 0);
                }
                n3 = string3.lastIndexOf(47);
                if (n3 >= 0 && (n3 = this.pathToId(string2 = n3 == 0 ? "/" : string3.substring(0, n3))) != -1) {
                    this.removeFileFromDirectory(n3, n2);
                }
            }
            return;
        }
    }

    private static class RDFileInputStream
    extends InputStream {
        private ArrayList<ByteBuffer> bbs = new ArrayList();
        private int offset;

        private RDFileInputStream(RamDisk ramDisk, int n2) throws Throwable {
            ByteBuffer byteBuffer;
            short s2 = ramDisk.bbNode.getShort(n2 * 8 + 2);
            if (s2 > 0) {
                byteBuffer = ByteBuffer.wrap(ramDisk.bbBlocks[n2], 0, s2);
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                this.bbs.add(byteBuffer);
            }
            n2 = ramDisk.bbNode.getInt(n2 * 8 + 4);
            while (n2 != 0) {
                s2 = ramDisk.bbNode.getShort(n2 * 8 + 2);
                if (s2 > 0) {
                    byteBuffer = ByteBuffer.wrap(ramDisk.bbBlocks[n2], 0, s2);
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    this.bbs.add(byteBuffer);
                }
                n2 = ramDisk.bbNode.getInt(n2 * 8 + 4);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int read() throws IOException {
            if (!this.bbs.isEmpty()) {
                ByteBuffer byteBuffer = this.bbs.get(this.offset);
                while (true) {
                    if (byteBuffer.hasRemaining()) {
                        return byteBuffer.get() & 0xFF;
                    }
                    if (this.offset == this.bbs.size() - 1) break;
                    ++this.offset;
                    byteBuffer = this.bbs.get(this.offset);
                }
            }
            return -1;
        }
    }

    private static class RDFileOutputStream
    extends OutputStream {
        private ByteBuffer bb;
        private ArrayList<Integer> bbNextIds;
        private RamDisk disk;
        private int fid;

        public RDFileOutputStream(RamDisk ramDisk, int n2) throws Throwable {
            this.disk = ramDisk;
            this.fid = n2;
            if (ramDisk.bbBlocks[n2] == null) {
                ((RamDisk)ramDisk).bbBlocks[n2] = new byte[1024];
            }
            this.bb = ByteBuffer.wrap(ramDisk.bbBlocks[n2]);
            this.bb.order(ByteOrder.BIG_ENDIAN);
            this.bbNextIds = new ArrayList();
            n2 = ramDisk.bbNode.getInt(n2 * 8 + 4);
            while (n2 != 0) {
                this.bbNextIds.add(n2);
                n2 = ramDisk.bbNode.getInt(n2 * 8 + 4);
            }
        }

        @Override
        public void write(int n2) throws IOException {
            if (!this.bbNextIds.isEmpty()) {
                for (Integer n3 : this.bbNextIds) {
                    this.disk.bbNode.put(n3 * 8, (byte)0);
                    this.disk.bbNode.put(n3 * 8 + 1, (byte)0);
                    this.disk.bbNode.putShort(n3 * 8 + 2, (short)0);
                    this.disk.bbNode.putInt(n3 * 8 + 4, 0);
                }
                this.bbNextIds.clear();
                this.disk.bbNode.putShort(this.fid * 8 + 2, (short)0);
                this.disk.bbNode.putInt(this.fid * 8 + 4, 0);
            }
            if (!this.bb.hasRemaining()) {
                int n4 = this.disk.nextFreeId();
                if (n4 == -1) {
                    throw new IOException("Out of storage");
                }
                this.disk.bbNode.put(n4 * 8, (byte)1);
                this.disk.bbNode.putInt(this.fid * 8 + 4, n4);
                this.fid = n4;
                if (this.disk.bbBlocks[this.fid] == null) {
                    ((RamDisk)this.disk).bbBlocks[this.fid] = new byte[1024];
                }
                this.bb = ByteBuffer.wrap(this.disk.bbBlocks[this.fid]);
                this.bb.order(ByteOrder.BIG_ENDIAN);
            }
            this.bb.put((byte)n2);
            this.disk.bbNode.putShort(this.fid * 8 + 2, (short)this.bb.position());
        }
    }
}

