/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.virtualdisk;

import android.os.MemoryFile;
import com.mob.tools.virtualdisk.VirtualDisk;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class MemDisk
extends VirtualDisk {
    private static final int BLOCK_SIZE = 1024;
    private static final int NODE_SIZE = 8;
    private byte[] buff;
    private int dataOffset;
    private MemoryFile mf;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void addFileToDirectory(int n2, String string2, int n3) throws Throwable {
        byte[] byArray = this.readDirectoryData(n2);
        DataOutputStream dataOutputStream = new DataOutputStream(new MDFileOutputStream(this, n2));
        if (byArray == null) {
            dataOutputStream.writeInt(1);
        } else {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            n2 = dataInputStream.readInt();
            dataInputStream.close();
            dataOutputStream.writeInt(n2 + 1);
            dataOutputStream.write(byArray, 4, byArray.length - 4);
        }
        dataOutputStream.writeUTF(string2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.close();
    }

    public void close() throws Throwable {
        synchronized (this) {
            this.mf.close();
            return;
        }
    }

    public void create(int n2) throws Throwable {
        synchronized (this) {
            this.mf = new MemoryFile(System.currentTimeMillis() + ".md", n2);
            this.dataOffset = n2 / 1032 * 8;
            this.buff = new byte[1024];
            return;
        }
    }

    public void dumpToFile(String string2) throws Throwable {
        synchronized (this) {
            this.dumpToFile(string2, false);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dumpToFile(String object, boolean bl) throws Throwable {
        synchronized (this) {
            Object object2 = new File((String)object);
            if (((File)object2).exists()) {
                if (!bl) {
                    throw new Throwable("file \"" + (String)object + "\" already exists");
                }
                ((File)object2).delete();
            }
            if (!((File)object2).getParentFile().exists()) {
                ((File)object2).getParentFile().mkdirs();
            }
            ((File)object2).createNewFile();
            object = new RandomAccessFile((String)object, "rw");
            object2 = ((RandomAccessFile)object).getChannel();
            MappedByteBuffer mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, 0L, 4L);
            mappedByteBuffer.order(ByteOrder.BIG_ENDIAN);
            mappedByteBuffer.putInt(this.mf.length());
            mappedByteBuffer.force();
            mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, 4L, this.dataOffset);
            byte[] byArray = new byte[this.dataOffset];
            IOUtils.readRaw(0, this.mf, byArray);
            mappedByteBuffer.put(byArray);
            mappedByteBuffer.force();
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n3 < this.dataOffset) {
                    if (IOUtils.readByte(n3, this.mf, this.buff) != 0) {
                        n2 = n3;
                    }
                } else {
                    n3 = 0;
                    n2 /= 8;
                    while (true) {
                        if (n3 > n2) {
                            ((RandomAccessFile)object).close();
                            return;
                        }
                        mappedByteBuffer = ((FileChannel)object2).map(FileChannel.MapMode.READ_WRITE, this.dataOffset + 4 + n3 * 1024, 1024L);
                        IOUtils.readRaw(this.dataOffset + n3 * 1024, this.mf, this.buff);
                        mappedByteBuffer.put(this.buff);
                        mappedByteBuffer.force();
                        ++n3;
                    }
                }
                n3 += 8;
            }
        }
    }

    @Override
    public void format() throws Throwable {
        synchronized (this) {
            byte[] byArray = new byte[8];
            for (int i2 = 0; i2 < this.dataOffset; i2 += 8) {
                IOUtils.writeRaw(i2, byArray, 0, byArray.length, this.mf);
            }
            IOUtils.writeByte(0, (byte)1, this.mf, this.buff);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InputStream getInputStream(String object) throws Throwable {
        Object var3_3 = null;
        synchronized (this) {
            int n2;
            block6: {
                n2 = this.pathToId(this.fixSlashes((String)object));
                if (n2 != -1) break block6;
                return var3_3;
            }
            object = var3_3;
            if (IOUtils.readByte(n2 * 8 + 1, this.mf, this.buff) == 0) return object;
            object = new MDFileInputStream(this, n2);
            return object;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OutputStream getOutputStream(String object) throws Throwable {
        Object var3_3 = null;
        synchronized (this) {
            int n2;
            block6: {
                n2 = this.pathToId(this.fixSlashes((String)object));
                if (n2 != -1) break block6;
                return var3_3;
            }
            object = var3_3;
            if (IOUtils.readByte(n2 * 8 + 1, this.mf, this.buff) == 0) return object;
            object = new MDFileOutputStream(this, n2);
            return object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFile(String string2) throws Throwable {
        synchronized (this) {
            string2 = this.fixSlashes(string2);
            int n2 = this.pathToId(string2);
            if (n2 == -1) {
                throw new Throwable("file \"" + string2 + "\" does not exist");
            }
            if ((n2 = (int)IOUtils.readByte(n2 * 8 + 1, this.mf, this.buff)) == 0) return false;
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int length(String string2) throws Throwable {
        synchronized (this) {
            int n2;
            int n3;
            int n4;
            block12: {
                block11: {
                    string2 = this.fixSlashes(string2);
                    n4 = this.pathToId(string2);
                    if (n4 != -1) break block11;
                    return 0;
                }
                n3 = IOUtils.readByte(n4 * 8 + 1, this.mf, this.buff);
                n2 = 0;
                if (n3 != 0) break block12;
                String[] stringArray = this.list(string2);
                if (stringArray == null) return 0;
                if (stringArray.length == 0) return 0;
                int n5 = stringArray.length;
                n3 = 0;
                while (true) {
                    n4 = n2;
                    if (n3 >= n5) return n4;
                    String string3 = stringArray[n3];
                    n2 += this.length(string2 + "/" + string3);
                    ++n3;
                    continue;
                    break;
                }
            }
            n2 = IOUtils.readShort(n4 * 8 + 2, this.mf, this.buff);
            n3 = IOUtils.readInt(n4 * 8 + 4, this.mf, this.buff);
            while (true) {
                n4 = n2;
                if (n3 == 0) return n4;
                n2 += IOUtils.readShort(n3 * 8 + 2, this.mf, this.buff);
                n3 = IOUtils.readInt(n3 * 8 + 4, this.mf, this.buff);
                continue;
                break;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] list(String stringArray) throws Throwable {
        synchronized (this) {
            DataInputStream dataInputStream;
            block12: {
                int n2;
                block11: {
                    n2 = this.pathToId(this.fixSlashes((String)stringArray));
                    if (n2 != -1) break block11;
                    return null;
                }
                String[] stringArray2 = null;
                dataInputStream = null;
                stringArray = dataInputStream;
                if (IOUtils.readByte(n2 * 8 + 1, this.mf, this.buff) != 0) return stringArray;
                byte[] byArray = this.readDirectoryData(n2);
                stringArray = dataInputStream;
                if (byArray == null) return stringArray;
                dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                int n3 = dataInputStream.readInt();
                stringArray = stringArray2;
                if (n3 <= 0) break block12;
                stringArray2 = new String[n3];
                n2 = 0;
                while (true) {
                    stringArray = stringArray2;
                    if (n2 >= n3) break;
                    stringArray2[n2] = dataInputStream.readUTF();
                    dataInputStream.readInt();
                    ++n2;
                    continue;
                    break;
                }
            }
            try {
                dataInputStream.close();
                return stringArray;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile(String object) throws Throwable {
        synchronized (this) {
            if (!new File((String)object).exists()) {
                throw new Throwable("file \"" + (String)object + "\" does not exist");
            }
            object = new RandomAccessFile((String)object, "rw");
            Object object2 = ((RandomAccessFile)object).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 4L);
            ((ByteBuffer)object2).order(ByteOrder.BIG_ENDIAN);
            int n2 = ((ByteBuffer)object2).getInt(0);
            this.mf = new MemoryFile(System.currentTimeMillis() + ".md", n2);
            this.dataOffset = n2 / 1032 * 8;
            this.buff = new byte[1024];
            object2 = new byte[this.dataOffset];
            ((RandomAccessFile)object).seek(4L);
            ((RandomAccessFile)object).readFully((byte[])object2);
            IOUtils.writeRaw(0, (byte[])object2, 0, this.dataOffset, this.mf);
            n2 = 0;
            while (true) {
                if (n2 >= this.dataOffset) {
                    ((RandomAccessFile)object).close();
                    return;
                }
                if (IOUtils.readByte(n2, this.mf, this.buff) != 0) {
                    int n3 = n2 / 8;
                    ((RandomAccessFile)object).seek(this.dataOffset + 4 + n3 * 1024);
                    ((RandomAccessFile)object).readFully(this.buff);
                    IOUtils.writeRaw(this.dataOffset + n3 * 1024, this.buff, 0, 1024, this.mf);
                }
                n2 += 8;
            }
        }
    }

    /*
     * WARNING - combined exceptions agressively - possible behaviour change.
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mkdir(String stringArray) throws Throwable {
        synchronized (this) {
            int n2;
            stringArray = this.splitPath(this.fixSlashes((String)stringArray));
            int n3 = n2 = -1;
            boolean bl = true;
            while (true) {
                int n4;
                block7: {
                    block11: {
                        block9: {
                            String string2;
                            block10: {
                                int n5;
                                block8: {
                                    if (!bl || (bl = false)) break block8;
                                    if (stringArray == null) break block9;
                                    n5 = stringArray.length;
                                    n4 = 0;
                                }
                                n3 = n2;
                                if (n4 >= n5) break block9;
                                string2 = stringArray[n4];
                                if (!"/".equals(string2)) break block10;
                                if (this.readDirectoryData(0) == null) {
                                    IOUtils.writeByte(0, (byte)1, this.mf, this.buff);
                                    IOUtils.writeByte(1, (byte)0, this.mf, this.buff);
                                    IOUtils.writeShort(2, (short)0, this.mf, this.buff);
                                    IOUtils.writeInt(4, 0, this.mf, this.buff);
                                }
                                break block11;
                            }
                            n3 = n2;
                            if (n2 != -1 && (n3 = this.nameToId(n2, string2)) == -1) {
                                n3 = this.nextFreeId();
                                if (n3 != -1) {
                                    IOUtils.writeByte(n3 * 8, (byte)1, this.mf, this.buff);
                                    IOUtils.writeByte(n3 * 8 + 1, (byte)0, this.mf, this.buff);
                                    IOUtils.writeShort(n3 * 8 + 2, (short)0, this.mf, this.buff);
                                    IOUtils.writeInt(n3 * 8 + 4, 0, this.mf, this.buff);
                                    this.addFileToDirectory(n2, string2, n3);
                                    break block7;
                                } else {
                                    n3 = -1;
                                }
                            }
                            break block7;
                        }
                        if (n3 == -1) return false;
                        return true;
                    }
                    n3 = 0;
                }
                ++n4;
                n2 = n3;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mv(String string2, String string3) throws Throwable {
        synchronized (this) {
            int n2;
            int n3;
            int n4;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block10: {
                                        string2 = this.fixSlashes(string2);
                                        boolean bl = string2.equals("/");
                                        if (!bl) break block10;
                                        return false;
                                    }
                                    n4 = this.pathToId(string2);
                                    if (n4 != -1) break block11;
                                    return false;
                                }
                                string3 = this.fixSlashes(string3);
                                if (!string3.equals("/")) break block12;
                                return false;
                            }
                            if (this.pathToId(string3) == -1) break block13;
                            return false;
                        }
                        n3 = string3.lastIndexOf(47);
                        if (n3 >= 0) break block14;
                        return false;
                    }
                    n2 = this.pathToId(this.fixSlashes(string3.substring(0, n3 + 1)));
                    if (n2 != -1) break block15;
                    return false;
                }
                string3 = string3.substring(n3 + 1);
                n3 = string2.lastIndexOf(47);
                if (n3 >= 0) break block16;
                return false;
            }
            this.removeFileFromDirectory(this.pathToId(this.fixSlashes(string2.substring(0, n3 + 1))), n4);
            this.addFileToDirectory(n2, string3, n4);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean newFile(String string2) throws Throwable {
        boolean bl = false;
        synchronized (this) {
            int n2;
            block8: {
                n2 = string2.lastIndexOf(47);
                if (n2 >= 0) break block8;
                return bl;
            }
            String string3 = string2.substring(n2 + 1);
            boolean bl2 = bl;
            if (string3.length() <= 0) return bl2;
            string2 = this.fixSlashes(string2.substring(0, n2 + 1));
            bl2 = bl;
            if (!this.mkdir(string2)) return bl2;
            n2 = this.pathToId(string2);
            bl2 = bl;
            if (this.nameToId(n2, string3) != -1) return bl2;
            int n3 = this.nextFreeId();
            bl2 = bl;
            if (n3 == -1) return bl2;
            IOUtils.writeByte(n3 * 8, (byte)1, this.mf, this.buff);
            IOUtils.writeByte(n3 * 8 + 1, (byte)1, this.mf, this.buff);
            IOUtils.writeShort(n3 * 8 + 2, (short)0, this.mf, this.buff);
            IOUtils.writeInt(n3 * 8 + 4, 0, this.mf, this.buff);
            this.addFileToDirectory(n2, string3, n3);
            return true;
        }
    }

    @Override
    protected int nextFreeId() throws IOException {
        int n2 = -1;
        int n3 = 0;
        while (true) {
            block4: {
                int n4;
                block3: {
                    n4 = n2;
                    if (n3 >= this.dataOffset) break block3;
                    if (IOUtils.readByte(n3, this.mf, this.buff) != 0) break block4;
                    n4 = n3 / 8;
                }
                return n4;
            }
            n3 += 8;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected byte[] readDirectoryData(int n2) throws Throwable {
        int n3 = n2 * 8;
        if (IOUtils.readByte(n3, this.mf, this.buff) == 0) {
            return null;
        }
        if (IOUtils.readByte(n3 + 1, this.mf, this.buff) != 0) return null;
        Object object = new MDFileInputStream(this, n2);
        Object object2 = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        n2 = ((InputStream)object).read(byArray);
        while (n2 > 0) {
            ((ByteArrayOutputStream)object2).write(byArray, 0, n2);
            n2 = ((InputStream)object).read(byArray);
        }
        ((InputStream)object).close();
        ((ByteArrayOutputStream)object2).close();
        object = object2 = (Object)((ByteArrayOutputStream)object2).toByteArray();
        if (((Object)object2).length != 0) return object;
        return null;
    }

    @Override
    protected void removeFileFromDirectory(int n2, int n3) throws Throwable {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.readDirectoryData(n2)));
        DataOutputStream dataOutputStream = new DataOutputStream(new MDFileOutputStream(this, n2));
        int n4 = dataInputStream.readInt();
        dataOutputStream.writeInt(n4 - 1);
        for (n2 = 0; n2 < n4; ++n2) {
            String string2 = dataInputStream.readUTF();
            int n5 = dataInputStream.readInt();
            if (n5 == n3) continue;
            dataOutputStream.writeUTF(string2);
            dataOutputStream.writeInt(n5);
        }
        dataInputStream.close();
        dataOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void rm(String string2) throws Throwable {
        synchronized (this) {
            String string3 = this.fixSlashes(string2);
            if ("/".equals(string3)) {
                throw new Throwable("can not remove directory \"/\"");
            }
            int n2 = this.pathToId(string3);
            if (n2 != -1) {
                int n3;
                Object object;
                if (IOUtils.readByte(n2 * 8 + 1, this.mf, this.buff) == 0 && (object = this.readDirectoryData(n2)) != null) {
                    object = new DataInputStream(new ByteArrayInputStream((byte[])object));
                    n3 = ((DataInputStream)object).readInt();
                    ((FilterInputStream)object).close();
                    if (n3 > 0) {
                        throw new Throwable("directory \"" + string2 + "\" is not empty");
                    }
                }
                n3 = IOUtils.readInt(n2 * 8 + 4, this.mf, this.buff);
                IOUtils.writeByte(n2 * 8, (byte)0, this.mf, this.buff);
                IOUtils.writeByte(n2 * 8 + 1, (byte)0, this.mf, this.buff);
                IOUtils.writeShort(n2 * 8 + 2, (short)0, this.mf, this.buff);
                IOUtils.writeInt(n2 * 8 + 4, 0, this.mf, this.buff);
                while (n3 != 0) {
                    IOUtils.readInt(n3 * 8 + 4, this.mf, this.buff);
                    IOUtils.writeByte(n3 * 8, (byte)0, this.mf, this.buff);
                    IOUtils.writeByte(n3 * 8 + 1, (byte)0, this.mf, this.buff);
                    IOUtils.writeShort(n3 * 8 + 2, (short)0, this.mf, this.buff);
                    IOUtils.writeInt(n3 * 8 + 4, 0, this.mf, this.buff);
                }
                n3 = string3.lastIndexOf(47);
                if (n3 >= 0 && (n3 = this.pathToId(string2 = n3 == 0 ? "/" : string3.substring(0, n3))) != -1) {
                    this.removeFileFromDirectory(n3, n2);
                }
            }
            return;
        }
    }

    private static class IOUtils {
        private IOUtils() {
        }

        public static byte readByte(int n2, MemoryFile memoryFile, byte[] byArray) throws IOException {
            memoryFile.readBytes(byArray, n2, 0, 1);
            return byArray[0];
        }

        public static int readInt(int n2, MemoryFile memoryFile, byte[] byArray) throws IOException {
            memoryFile.readBytes(byArray, n2, 0, 4);
            return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }

        public static void readRaw(int n2, MemoryFile memoryFile, byte[] byArray) throws IOException {
            memoryFile.readBytes(byArray, n2, 0, byArray.length);
        }

        public static short readShort(int n2, MemoryFile memoryFile, byte[] byArray) throws IOException {
            memoryFile.readBytes(byArray, n2, 0, 2);
            return (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }

        public static void writeByte(int n2, byte by, MemoryFile memoryFile, byte[] byArray) throws IOException {
            byArray[0] = by;
            memoryFile.writeBytes(byArray, 0, n2, 1);
        }

        public static void writeInt(int n2, int n3, MemoryFile memoryFile, byte[] byArray) throws IOException {
            byArray[0] = (byte)(n3 >> 24);
            byArray[1] = (byte)(n3 >> 16);
            byArray[2] = (byte)(n3 >> 8);
            byArray[3] = (byte)n3;
            memoryFile.writeBytes(byArray, 0, n2, 4);
        }

        public static void writeRaw(int n2, byte[] byArray, int n3, int n4, MemoryFile memoryFile) throws IOException {
            memoryFile.writeBytes(byArray, n3, n2, n4);
        }

        public static void writeShort(int n2, short s2, MemoryFile memoryFile, byte[] byArray) throws IOException {
            byArray[0] = (byte)(s2 >> 8);
            byArray[1] = (byte)s2;
            memoryFile.writeBytes(byArray, 0, n2, 2);
        }
    }

    private static class MDFileInputStream
    extends InputStream {
        private ArrayList<int[]> bbs;
        private MemDisk disk;
        private int offset;

        private MDFileInputStream(MemDisk memDisk, int n2) throws Throwable {
            int n3;
            this.disk = memDisk;
            this.bbs = new ArrayList();
            short s2 = IOUtils.readShort(n2 * 8 + 2, memDisk.mf, memDisk.buff);
            if (s2 > 0) {
                n3 = memDisk.dataOffset;
                this.bbs.add(new int[]{n3 + n2 * 1024, s2, 0});
            }
            n2 = IOUtils.readInt(n2 * 8 + 4, memDisk.mf, memDisk.buff);
            while (n2 != 0) {
                s2 = IOUtils.readShort(n2 * 8 + 2, memDisk.mf, memDisk.buff);
                if (s2 > 0) {
                    n3 = memDisk.dataOffset;
                    this.bbs.add(new int[]{n3 + n2 * 1024, s2, 0});
                }
                n2 = IOUtils.readInt(n2 * 8 + 4, memDisk.mf, memDisk.buff);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int read() throws IOException {
            if (!this.bbs.isEmpty()) {
                int[] nArray = this.bbs.get(this.offset);
                while (true) {
                    if (nArray[2] < nArray[1]) {
                        byte by = IOUtils.readByte(nArray[0] + nArray[2], this.disk.mf, this.disk.buff);
                        nArray[2] = nArray[2] + 1;
                        return by & 0xFF;
                    }
                    if (this.offset == this.bbs.size() - 1) break;
                    ++this.offset;
                    nArray = this.bbs.get(this.offset);
                }
            }
            return -1;
        }
    }

    private static class MDFileOutputStream
    extends OutputStream {
        private ArrayList<Integer> bbNextIds;
        private MemDisk disk;
        private int fid;
        private int pos;

        public MDFileOutputStream(MemDisk memDisk, int n2) throws Throwable {
            this.disk = memDisk;
            this.fid = n2;
            this.bbNextIds = new ArrayList();
            n2 = IOUtils.readInt(n2 * 8 + 4, memDisk.mf, memDisk.buff);
            while (n2 != 0) {
                this.bbNextIds.add(n2);
                n2 = IOUtils.readInt(n2 * 8 + 4, memDisk.mf, memDisk.buff);
            }
        }

        @Override
        public void write(int n2) throws IOException {
            if (!this.bbNextIds.isEmpty()) {
                for (Integer n3 : this.bbNextIds) {
                    IOUtils.writeByte(n3 * 8, (byte)0, this.disk.mf, this.disk.buff);
                    IOUtils.writeByte(n3 * 8 + 1, (byte)0, this.disk.mf, this.disk.buff);
                    IOUtils.writeShort(n3 * 8 + 2, (short)0, this.disk.mf, this.disk.buff);
                    IOUtils.writeInt(n3 * 8 + 4, 0, this.disk.mf, this.disk.buff);
                }
                this.bbNextIds.clear();
                IOUtils.writeShort(this.fid * 8 + 2, (short)0, this.disk.mf, this.disk.buff);
                IOUtils.writeInt(this.fid * 8 + 4, 0, this.disk.mf, this.disk.buff);
            }
            if (this.pos >= 1024) {
                int n4 = this.disk.nextFreeId();
                if (n4 == -1) {
                    throw new IOException("Out of storage");
                }
                IOUtils.writeByte(n4 * 8, (byte)1, this.disk.mf, this.disk.buff);
                IOUtils.writeInt(this.fid * 8 + 4, n4, this.disk.mf, this.disk.buff);
                this.fid = n4;
                this.pos = 0;
            }
            IOUtils.writeByte(this.disk.dataOffset + this.fid * 1024 + this.pos, (byte)n2, this.disk.mf, this.disk.buff);
            ++this.pos;
            IOUtils.writeShort(this.fid * 8 + 2, (short)this.pos, this.disk.mf, this.disk.buff);
        }
    }
}

