/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import com.mob.tools.gui.CachePool;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ReflectHelper {
    private static CachePool<String, Constructor<?>> cachedConstr;
    private static CachePool<String, Method> cachedMethod;
    private static HashMap<String, Class<?>> classMap;
    private static HashSet<String> packageSet;

    static {
        packageSet = new HashSet();
        packageSet.add("java.lang");
        packageSet.add("java.io");
        packageSet.add("java.net");
        packageSet.add("java.util");
        packageSet.add("com.mob.tools");
        packageSet.add("com.mob.tools.gui");
        packageSet.add("com.mob.tools.log");
        packageSet.add("com.mob.tools.network");
        packageSet.add("com.mob.tools.utils");
        classMap = new HashMap();
        cachedMethod = new CachePool(25);
        cachedConstr = new CachePool(5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> getClass(String string2) {
        synchronized (ReflectHelper.class) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = classMap.get(string2);
            if (clazz != null) return clazz2;
            Iterator<String> iterator = packageSet.iterator();
            clazz2 = clazz;
            do {
                if (!iterator.hasNext()) return clazz2;
                clazz2 = iterator.next();
                try {
                    ReflectHelper.importClass((String)((Object)clazz2) + "." + string2);
                }
                catch (Throwable throwable) {}
                clazz2 = clazz = classMap.get(string2);
            } while (clazz == null);
            return clazz;
        }
    }

    public static <T> T getInstanceField(Object object, String string2) throws Throwable {
        T t2;
        try {
            t2 = ReflectHelper.onGetInstanceField(object, string2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFieldException) {
                throw throwable;
            }
            throw new Throwable("className: " + object.getClass() + ", fieldName: " + string2, throwable);
        }
        return t2;
    }

    public static <T> T getStaticField(String string2, String string3) throws Throwable {
        T t2;
        try {
            t2 = ReflectHelper.onGetStaticField(string2, string3);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFieldException) {
                throw throwable;
            }
            throw new Throwable("className: " + string2 + ", fieldName: " + string3, throwable);
        }
        return t2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Class<?>[] getTypes(Object[] objectArray) {
        Class[] classArray = new Class[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Class<?> clazz = objectArray[n2] == null ? null : objectArray[n2].getClass();
            classArray[n2] = clazz;
            ++n2;
        }
        return classArray;
    }

    public static void importClass(String string2) throws Throwable {
        ReflectHelper.importClass(null, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importClass(String string2, String string3) throws Throwable {
        synchronized (ReflectHelper.class) {
            String string4;
            if (string4.endsWith(".*")) {
                packageSet.add(string4.substring(0, string4.length() - 2));
            } else {
                Class<?> clazz = Class.forName(string4);
                string4 = string2;
                if (string2 == null) {
                    string4 = clazz.getSimpleName();
                }
                classMap.put(string4, clazz);
            }
            return;
        }
    }

    public static <T> T invokeInstanceMethod(Object object, String string2, Object ... object2) throws Throwable {
        try {
            object2 = ReflectHelper.onInvokeInstanceMethod(object, string2, object2);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchMethodException) {
                throw throwable;
            }
            throw new Throwable("className: " + object.getClass() + ", methodName: " + string2, throwable);
        }
        return (T)object2;
    }

    public static <T> T invokeStaticMethod(String string2, String string3, Object ... object) throws Throwable {
        try {
            object = ReflectHelper.onInvokeStaticMethod(string2, string3, object);
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchMethodException) {
                throw throwable;
            }
            throw new Throwable("className: " + string2 + ", methodName: " + string3, throwable);
        }
        return (T)object;
    }

    private static boolean matchParams(Class<?>[] classArray, Class<?>[] classArray2) {
        block3: {
            if (classArray.length != classArray2.length) break block3;
            boolean bl = true;
            int n2 = 0;
            while (true) {
                block5: {
                    boolean bl2;
                    block4: {
                        bl2 = bl;
                        if (n2 >= classArray.length) break block4;
                        if (classArray2[n2] == null || ReflectHelper.primitiveEquals(classArray[n2], classArray2[n2]) || classArray[n2].isAssignableFrom(classArray2[n2])) break block5;
                        bl2 = false;
                    }
                    return bl2;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Object newInstance(String string2, Object ... object) throws Throwable {
        try {
            object = ReflectHelper.onNewInstance(string2, object);
            return object;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchMethodException) {
                throw throwable;
            }
            throw new Throwable("className: " + string2 + ", methodName: <init>", throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T onGetInstanceField(Object object, String string2) throws Throwable {
        Object object2;
        Object object3 = new ArrayList();
        for (object2 = object.getClass(); object2 != null; object2 = ((Class)object2).getSuperclass()) {
            ((ArrayList)object3).add(object2);
        }
        Iterator iterator = ((ArrayList)object3).iterator();
        do {
            if (!iterator.hasNext()) {
                throw new NoSuchFieldException("className: " + object.getClass() + ", fieldName: " + string2);
            }
            object3 = (Class)iterator.next();
            object2 = null;
            try {
                object2 = object3 = ((Class)object3).getDeclaredField(string2);
            }
            catch (Throwable throwable) {}
        } while (object2 == null || Modifier.isStatic(((Field)object2).getModifiers()));
        ((Field)object2).setAccessible(true);
        return (T)((Field)object2).get(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T onGetStaticField(String string2, String string3) throws Throwable {
        Object object;
        Object object2 = new ArrayList();
        for (object = ReflectHelper.getClass(string2); object != null; object = ((Class)object).getSuperclass()) {
            ((ArrayList)object2).add(object);
        }
        Iterator iterator = ((ArrayList)object2).iterator();
        do {
            if (!iterator.hasNext()) {
                throw new NoSuchFieldException("className: " + string2 + ", fieldName: " + string3);
            }
            object2 = (Class)iterator.next();
            object = null;
            try {
                object = object2 = ((Class)object2).getDeclaredField(string3);
            }
            catch (Throwable throwable) {}
        } while (object == null || !Modifier.isStatic(((Field)object).getModifiers()));
        ((Field)object).setAccessible(true);
        return (T)((Field)object).get(null);
    }

    private static <T> T onInvokeInstanceMethod(Object object, String string2, Object ... objectArray) throws Throwable {
        Class clazz;
        String string3 = clazz.getName() + "#" + string2 + "#" + objectArray.length;
        Method[] methodArray = cachedMethod.get(string3);
        Class<?>[] classArray = ReflectHelper.getTypes(objectArray);
        if (methodArray != null && !Modifier.isStatic(methodArray.getModifiers()) && ReflectHelper.matchParams(methodArray.getParameterTypes(), classArray)) {
            methodArray.setAccessible(true);
            if (methodArray.getReturnType() == Void.TYPE) {
                methodArray.invoke(object, objectArray);
                return null;
            }
            return (T)methodArray.invoke(object, objectArray);
        }
        methodArray = new ArrayList();
        for (clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            methodArray.add(clazz);
        }
        clazz = methodArray.iterator();
        while (clazz.hasNext()) {
            for (Method method : ((Class)clazz.next()).getDeclaredMethods()) {
                if (!method.getName().equals(string2) || Modifier.isStatic(method.getModifiers()) || !ReflectHelper.matchParams(method.getParameterTypes(), classArray)) continue;
                cachedMethod.put(string3, method);
                method.setAccessible(true);
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke(object, objectArray);
                    return null;
                }
                return (T)method.invoke(object, objectArray);
            }
        }
        throw new NoSuchMethodException("className: " + object.getClass() + ", methodName: " + string2);
    }

    private static <T> T onInvokeStaticMethod(String string2, String string3, Object ... objectArray) throws Throwable {
        String string4 = string2 + "#" + string3 + "#" + objectArray.length;
        Class clazz = cachedMethod.get(string4);
        Class<?>[] classArray = ReflectHelper.getTypes(objectArray);
        if (clazz != null && Modifier.isStatic(((Method)((Object)clazz)).getModifiers()) && ReflectHelper.matchParams(((Method)((Object)clazz)).getParameterTypes(), classArray)) {
            ((Method)((Object)clazz)).setAccessible(true);
            if (((Method)((Object)clazz)).getReturnType() == Void.TYPE) {
                ((Method)((Object)clazz)).invoke(null, objectArray);
                return null;
            }
            return (T)((Method)((Object)clazz)).invoke(null, objectArray);
        }
        Method[] methodArray = new ArrayList();
        for (clazz = ReflectHelper.getClass(string2); clazz != null; clazz = clazz.getSuperclass()) {
            methodArray.add(clazz);
        }
        clazz = methodArray.iterator();
        while (clazz.hasNext()) {
            for (Method method : ((Class)clazz.next()).getDeclaredMethods()) {
                if (!method.getName().equals(string3) || !Modifier.isStatic(method.getModifiers()) || !ReflectHelper.matchParams(method.getParameterTypes(), classArray)) continue;
                cachedMethod.put(string4, method);
                method.setAccessible(true);
                if (method.getReturnType() == Void.TYPE) {
                    method.invoke(null, objectArray);
                    return null;
                }
                return (T)method.invoke(null, objectArray);
            }
        }
        throw new NoSuchMethodException("className: " + string2 + ", methodName: " + string3);
    }

    private static Object onNewInstance(String string2, Object ... objectArray) throws Throwable {
        String string3 = string2 + "#" + objectArray.length;
        Constructor<?>[] constructorArray = cachedConstr.get(string3);
        Class<?>[] classArray = ReflectHelper.getTypes(objectArray);
        if (constructorArray != null && ReflectHelper.matchParams(constructorArray.getParameterTypes(), classArray)) {
            constructorArray.setAccessible(true);
            return constructorArray.newInstance(objectArray);
        }
        for (Constructor<?> constructor : ReflectHelper.getClass(string2).getDeclaredConstructors()) {
            if (!ReflectHelper.matchParams(constructor.getParameterTypes(), classArray)) continue;
            cachedConstr.put(string3, constructor);
            constructor.setAccessible(true);
            return constructor.newInstance(objectArray);
        }
        throw new NoSuchMethodException("className: " + string2 + ", methodName: <init>");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void onSetInstanceField(Object object, String string2, Object object2) throws Throwable {
        Object object3;
        Object object4 = new ArrayList();
        for (object3 = object.getClass(); object3 != null; object3 = ((Class)object3).getSuperclass()) {
            ((ArrayList)object4).add(object3);
        }
        Iterator iterator = ((ArrayList)object4).iterator();
        do {
            if (!iterator.hasNext()) {
                throw new NoSuchFieldException("className: " + object.getClass() + ", fieldName: " + string2 + ", value: " + String.valueOf(object2));
            }
            object4 = (Class)iterator.next();
            object3 = null;
            try {
                object3 = object4 = ((Class)object4).getDeclaredField(string2);
            }
            catch (Throwable throwable) {}
        } while (object3 == null || Modifier.isStatic(((Field)object3).getModifiers()));
        ((Field)object3).setAccessible(true);
        ((Field)object3).set(object, object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void onSetStaticField(String string2, String string3, Object object) throws Throwable {
        Object object2;
        Object object3 = new ArrayList();
        for (object2 = ReflectHelper.getClass(string2); object2 != null; object2 = ((Class)object2).getSuperclass()) {
            ((ArrayList)object3).add(object2);
        }
        Iterator iterator = ((ArrayList)object3).iterator();
        do {
            if (!iterator.hasNext()) {
                throw new NoSuchFieldException("className: " + string2 + ", fieldName: " + string3 + ", value: " + String.valueOf(object));
            }
            object3 = (Class)iterator.next();
            object2 = null;
            try {
                object2 = object3 = ((Class)object3).getDeclaredField(string3);
            }
            catch (Throwable throwable) {}
        } while (object2 == null || !Modifier.isStatic(((Field)object2).getModifiers()));
        ((Field)object2).setAccessible(true);
        ((Field)object2).set(null, object);
    }

    private static boolean primitiveEquals(Class<?> clazz, Class<?> clazz2) {
        return clazz == Byte.TYPE && clazz2 == Byte.class || clazz == Short.TYPE && clazz2 == Short.class || clazz == Character.TYPE && clazz2 == Character.class || clazz == Integer.TYPE && clazz2 == Integer.class || clazz == Long.TYPE && clazz2 == Long.class || clazz == Float.TYPE && clazz2 == Float.class || clazz == Double.TYPE && clazz2 == Double.class || clazz == Boolean.TYPE && clazz2 == Boolean.class;
    }

    public static void setInstanceField(Object object, String string2, Object object2) throws Throwable {
        try {
            ReflectHelper.onSetInstanceField(object, string2, object2);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFieldException) {
                throw throwable;
            }
            throw new Throwable("className: " + object.getClass() + ", fieldName: " + string2 + ", value: " + String.valueOf(object2), throwable);
        }
    }

    public static void setStaticField(String string2, String string3, Object object) throws Throwable {
        try {
            ReflectHelper.onSetStaticField(string2, string3, object);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof NoSuchFieldException) {
                throw throwable;
            }
            throw new Throwable("className: " + string2 + ", fieldName: " + string3 + ", value: " + String.valueOf(object), throwable);
        }
    }

    public static interface ReflectRunnable {
        public Object run(Object var1);
    }
}

