/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mob.tools.MobLog;
import com.mob.tools.network.KVPair;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.DeviceHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class R {
    private static float density;
    private static int deviceWidth;
    private static Object rp;

    public static void clearCache(Context context) throws Throwable {
        R.deleteFileAndFolder(new File(R.getCachePath(context, null)));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String contentUriToPath(Context object, Uri uri) {
        void var1_5;
        if (var1_5 == null) return null;
        if (new File(var1_5.getPath()).exists()) {
            return var1_5.getPath();
        }
        Object var4_6 = null;
        Cursor cursor = null;
        Object object2 = cursor;
        try {
            void var0_3;
            if (Build.VERSION.SDK_INT >= 19) {
                Class<?> clazz = Class.forName("android.provider.DocumentsContract");
                Method method = clazz.getMethod("isDocumentUri", Context.class, Uri.class);
                method.setAccessible(true);
                object2 = cursor;
                if (Boolean.TRUE.equals(method.invoke(null, object, var1_5))) {
                    object2 = clazz.getMethod("getDocumentId", Uri.class);
                    ((Method)object2).setAccessible(true);
                    object2 = String.valueOf(((Method)object2).invoke(null, var1_5)).split(":")[1];
                    object2 = object.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data"}, "_id=?", new String[]{object2}, null);
                }
            }
            cursor = object2;
            if (object2 == null) {
                cursor = object.getContentResolver().query((Uri)var1_5, null, null, null, null);
            }
            if (cursor == null) return null;
            Object var0_1 = var4_6;
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndex("_data"));
            }
            cursor.close();
            return var0_3;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return null;
        }
    }

    public static void copyFile(FileInputStream fileInputStream, FileOutputStream fileOutputStream) throws Throwable {
        byte[] byArray = new byte[65536];
        int n2 = fileInputStream.read(byArray);
        while (n2 > 0) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyFile(String string2, String string3) {
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3) || !new File(string2).exists()) {
            return false;
        }
        try {
            R.copyFile(new FileInputStream(string2), new FileOutputStream(string3));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static int[] covertTimeInYears(long l2) {
        l2 = System.currentTimeMillis() - l2;
        if (l2 <= 0L) {
            return new int[]{0, 0};
        }
        if ((l2 /= 1000L) < 60L) {
            return new int[]{(int)l2, 0};
        }
        if ((l2 /= 60L) < 60L) {
            return new int[]{(int)l2, 1};
        }
        if ((l2 /= 60L) < 24L) {
            return new int[]{(int)l2, 2};
        }
        if ((l2 /= 24L) < 30L) {
            return new int[]{(int)l2, 3};
        }
        if ((l2 /= 30L) < 12L) {
            return new int[]{(int)l2, 4};
        }
        return new int[]{(int)(l2 / 12L), 5};
    }

    public static long dateStrToLong(String string2) {
        return new SimpleDateFormat("yyyy-MM-dd").parse(string2, new ParsePosition(0)).getTime();
    }

    public static long dateToLong(String object) {
        try {
            object = new Date((String)object);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            long l2 = calendar.getTimeInMillis();
            return l2;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return 0L;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bundle decodeUrl(String stringArray) {
        Bundle bundle = new Bundle();
        if (stringArray != null) {
            stringArray = stringArray.split("&");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String[] stringArray2 = stringArray[i2].split("=");
                if (stringArray2.length < 2 || stringArray2[1] == null) {
                    bundle.putString(URLDecoder.decode(stringArray2[0]), "");
                    continue;
                }
                bundle.putString(URLDecoder.decode(stringArray2[0]), URLDecoder.decode(stringArray2[1]));
            }
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteFileAndFolder(File file) throws Throwable {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null || stringArray.length <= 0) {
            file.delete();
            return;
        }
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                file.delete();
                return;
            }
            File file2 = new File(file, stringArray[n3]);
            if (file2.isDirectory()) {
                R.deleteFileAndFolder(file2);
            } else {
                file2.delete();
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void deleteFilesInFolder(File file) throws Throwable {
        if (file != null && file.exists()) {
            if (file.isFile()) {
                file.delete();
                return;
            }
            String[] stringArray = file.list();
            if (stringArray != null && stringArray.length > 0) {
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    File file2 = new File(file, stringArray[i2]);
                    if (file2.isDirectory()) {
                        R.deleteFilesInFolder(file2);
                        continue;
                    }
                    file2.delete();
                }
            }
        }
    }

    public static int designToDevice(Context context, float f2, int n2) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)n2 * density / f2 + 0.5f);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static int designToDevice(Context object, int n2, int n3) {
        void var1_2;
        void var2_3;
        if (deviceWidth == 0) {
            int[] nArray = R.getScreenSize(object);
            int n4 = nArray[0] < nArray[1] ? nArray[0] : nArray[1];
            deviceWidth = n4;
        }
        return (int)((float)var2_3 * (float)deviceWidth / (float)var1_2 + 0.5f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int digit(int n2, int n3) {
        int n4;
        if (n3 < 2) return -1;
        if (n3 > 36) {
            return -1;
        }
        int n5 = -1;
        if (48 <= n2 && n2 <= 57) {
            n4 = n2 - 48;
        } else if (97 <= n2 && n2 <= 122) {
            n4 = n2 - 97 + 10;
        } else {
            n4 = n5;
            if (65 <= n2) {
                n4 = n5;
                if (n2 <= 90) {
                    n4 = n2 - 65 + 10;
                }
            }
        }
        n2 = n4;
        if (n4 < n3) return n2;
        return -1;
    }

    public static int dipToPx(Context context, int n2) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)n2 * density + 0.5f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String encodeUrl(Bundle bundle) {
        if (bundle == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        Iterator iterator = bundle.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            Object object2 = object = bundle.get(string2);
            if (object == null) {
                object2 = "";
            }
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("&");
            }
            stringBuilder.append(Data.urlEncode(string2) + "=" + Data.urlEncode(String.valueOf(object2)));
        }
        return stringBuilder.toString();
    }

    public static String encodeUrl(ArrayList<KVPair<String>> object) {
        if (object == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        Iterator<KVPair<String>> iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (n2 > 0) {
                stringBuilder.append('&');
            }
            String string2 = ((KVPair)object).name;
            String string3 = (String)((KVPair)object).value;
            if (string2 == null) continue;
            object = string3;
            if (string3 == null) {
                object = "";
            }
            stringBuilder.append(Data.urlEncode(string2) + "=" + Data.urlEncode((String)object));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int getAnimRes(Context context, String string2) {
        return R.getResId(context, "anim", string2);
    }

    public static int getBitmapRes(Context context, String string2) {
        return R.getResId(context, "drawable", string2);
    }

    public static String getCachePath(Context object, String string2) {
        String string3 = object.getFilesDir().getAbsolutePath() + "/Mob/cache/";
        DeviceHelper deviceHelper = DeviceHelper.getInstance((Context)object);
        object = string3;
        if (deviceHelper.getSdcardState()) {
            object = deviceHelper.getSdcardPath() + "/Mob/" + deviceHelper.getPackageName() + "/cache/";
        }
        string3 = object;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string3 = (String)object + string2 + "/";
        }
        if (!((File)(object = new File(string3))).exists()) {
            ((File)object).mkdirs();
        }
        return string3;
    }

    public static String getCacheRoot(Context object) {
        Object object2 = object.getFilesDir().getAbsolutePath() + "/Mob/";
        DeviceHelper deviceHelper = DeviceHelper.getInstance(object);
        object = object2;
        if (deviceHelper.getSdcardState()) {
            object = deviceHelper.getSdcardPath() + "/Mob/";
        }
        if (!((File)(object2 = new File((String)object))).exists()) {
            ((File)object2).mkdirs();
        }
        return object;
    }

    public static int getColorRes(Context context, String string2) {
        return R.getResId(context, "color", string2);
    }

    public static long getFileSize(File file) throws Throwable {
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n2 = 0;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file2 = new File(file, stringArray[i2]);
                n2 = (int)((long)n2 + R.getFileSize(file2));
            }
            return n2;
        }
        return file.length();
    }

    public static long getFileSize(String string2) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return 0L;
        }
        return R.getFileSize(new File(string2));
    }

    public static int getIdRes(Context context, String string2) {
        return R.getResId(context, "id", string2);
    }

    public static String getImageCachePath(Context context) {
        return R.getCachePath(context, "images");
    }

    public static int getLayoutRes(Context context, String string2) {
        return R.getResId(context, "layout", string2);
    }

    public static int getPluralsRes(Context context, String string2) {
        return R.getResId(context, "plurals", string2);
    }

    public static int getRawRes(Context context, String string2) {
        return R.getResId(context, "raw", string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getResId(Context context, String string2, String string3) {
        Object object;
        int n2 = 0;
        if (context == null) return 0;
        if (TextUtils.isEmpty((CharSequence)string2)) return 0;
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return 0;
        }
        int n3 = n2;
        if (rp != null) {
            try {
                object = rp.getClass().getMethod("getResId", Context.class, String.class, String.class);
                ((Method)object).setAccessible(true);
                n3 = (Integer)((Method)object).invoke(rp, context, string2, string3);
            }
            catch (Throwable throwable) {
                MobLog.getInstance().d(throwable);
                n3 = n2;
            }
        }
        int n4 = n3;
        if (n3 > 0) return n4;
        object = context.getPackageName();
        if (TextUtils.isEmpty((CharSequence)object)) {
            return n3;
        }
        n2 = n3;
        if (n3 <= 0) {
            n2 = n3 = context.getResources().getIdentifier(string3, string2, (String)object);
            if (n3 <= 0) {
                n2 = context.getResources().getIdentifier(string3.toLowerCase(), string2, (String)object);
            }
        }
        n4 = n2;
        if (n2 > 0) return n4;
        System.err.println("failed to parse " + string2 + " resource \"" + string3 + "\"");
        return n2;
    }

    public static int getScreenHeight(Context context) {
        return R.getScreenSize(context)[1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] getScreenSize(Context context) {
        int n2;
        int n3;
        try {
            context = (WindowManager)context.getSystemService("window");
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            context = null;
        }
        if (context == null) {
            return new int[]{0, 0};
        }
        context = context.getDefaultDisplay();
        if (Build.VERSION.SDK_INT < 13) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            context.getMetrics(displayMetrics);
            return new int[]{displayMetrics.widthPixels, displayMetrics.heightPixels};
        }
        try {
            Point point = new Point();
            Method method = context.getClass().getMethod("getRealSize", Point.class);
            method.setAccessible(true);
            method.invoke((Object)context, point);
            n3 = point.x;
            n2 = point.y;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return new int[]{0, 0};
        }
        return new int[]{n3, n2};
    }

    public static int getScreenWidth(Context context) {
        return R.getScreenSize(context)[0];
    }

    public static int getStringArrayRes(Context context, String string2) {
        return R.getResId(context, "array", string2);
    }

    public static int getStringRes(Context context, String string2) {
        return R.getResId(context, "string", string2);
    }

    public static int getStyleRes(Context context, String string2) {
        return R.getResId(context, "style", string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int getTextLengthInWord(String object) {
        object = object == null ? (Object)new char[0] : (Object)((String)object).toCharArray();
        int n2 = 0;
        int n3 = 0;
        while (n3 < ((Object)object).length) {
            int n4 = object[n3] < 256 ? 1 : 2;
            n2 += n4;
            ++n3;
        }
        return n2;
    }

    private static Throwable invalidInt(String string2) throws Throwable {
        throw new Throwable("Invalid int: \"" + string2 + "\"");
    }

    public static Date longToDate(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        return calendar.getTime();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String longToTime(long l2, int n2) {
        String string2 = "yyyy-MM-dd kk:mm:ss";
        switch (n2) {
            case 12: {
                string2 = "yyyy-MM-dd kk:mm";
                return new SimpleDateFormat(string2).format(l2);
            }
            case 10: {
                string2 = "yyyy-MM-dd kk";
                return new SimpleDateFormat(string2).format(l2);
            }
            case 5: {
                string2 = "yyyy-MM-dd";
                return new SimpleDateFormat(string2).format(l2);
            }
            case 2: {
                string2 = "yyyy-MM";
                return new SimpleDateFormat(string2).format(l2);
            }
            case 1: {
                string2 = "yyyy";
                return new SimpleDateFormat(string2).format(l2);
            }
        }
        return new SimpleDateFormat(string2).format(l2);
    }

    public static int parseInt(String string2) throws Throwable {
        return R.parseInt(string2, 10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int parseInt(String string2, int n2) throws Throwable {
        if (n2 < 2 || n2 > 36) {
            throw new Throwable("Invalid radix: " + n2);
        }
        if (string2 == null) {
            throw R.invalidInt(string2);
        }
        int n3 = string2.length();
        int n4 = 0;
        if (n3 == 0) {
            throw R.invalidInt(string2);
        }
        boolean bl = string2.charAt(0) == '-';
        if (bl) {
            int n5;
            n4 = n5 = 0 + 1;
            if (n5 == n3) {
                throw R.invalidInt(string2);
            }
        }
        return R.parseInt(string2, n4, n2, bl);
    }

    private static int parseInt(String string2, int n2, int n3, boolean bl) throws Throwable {
        int n4 = Integer.MIN_VALUE / n3;
        int n5 = 0;
        int n6 = string2.length();
        int n7 = n2;
        n2 = n5;
        while (n7 < n6) {
            n5 = R.digit(string2.charAt(n7), n3);
            if (n5 == -1) {
                throw R.invalidInt(string2);
            }
            if (n4 > n2) {
                throw R.invalidInt(string2);
            }
            if ((n5 = n2 * n3 - n5) > n2) {
                throw R.invalidInt(string2);
            }
            n2 = n5;
            ++n7;
        }
        n3 = n2;
        if (!bl) {
            n3 = n2 = -n2;
            if (n2 < 0) {
                throw R.invalidInt(string2);
            }
        }
        return n3;
    }

    public static long parseLong(String string2) throws Throwable {
        return R.parseLong(string2, 10);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static long parseLong(String string2, int n2) throws Throwable {
        if (n2 < 2 || n2 > 36) {
            throw new Throwable("Invalid radix: " + n2);
        }
        if (string2 == null) {
            throw new Throwable("Invalid long: \"" + string2 + "\"");
        }
        int n3 = string2.length();
        int n4 = 0;
        if (n3 == 0) {
            throw new Throwable("Invalid long: \"" + string2 + "\"");
        }
        boolean bl = string2.charAt(0) == '-';
        if (bl) {
            int n5;
            n4 = n5 = 0 + 1;
            if (n5 == n3) {
                throw new Throwable("Invalid long: \"" + string2 + "\"");
            }
        }
        return R.parseLong(string2, n4, n2, bl);
    }

    private static long parseLong(String string2, int n2, int n3, boolean bl) throws Throwable {
        long l2;
        long l3 = Long.MIN_VALUE / (long)n3;
        long l4 = 0L;
        long l5 = string2.length();
        while ((long)n2 < l5) {
            int n4 = R.digit(string2.charAt(n2), n3);
            if (n4 == -1) {
                throw new Throwable("Invalid long: \"" + string2 + "\"");
            }
            if (l3 > l4) {
                throw new Throwable("Invalid long: \"" + string2 + "\"");
            }
            l2 = (long)n3 * l4 - (long)n4;
            if (l2 > l4) {
                throw new Throwable("Invalid long: \"" + string2 + "\"");
            }
            l4 = l2;
            ++n2;
        }
        l2 = l4;
        if (!bl) {
            l2 = l4 = -l4;
            if (l4 < 0L) {
                throw new Throwable("Invalid long: \"" + string2 + "\"");
            }
        }
        return l2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Uri pathToContentUri(Context context, String string2) {
        ContentValues contentValues = null;
        Cursor cursor = context.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_id"}, "_data=? ", new String[]{string2}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int n2 = cursor.getInt(cursor.getColumnIndex("_id"));
            return Uri.withAppendedPath((Uri)Uri.parse((String)"content://media/external/images/media"), (String)("" + n2));
        }
        if (!new File(string2).exists()) return contentValues;
        contentValues = new ContentValues();
        contentValues.put("_data", string2);
        string2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        return context.getContentResolver().insert((Uri)string2, contentValues);
    }

    public static int pxToDip(Context context, int n2) {
        if (density <= 0.0f) {
            density = context.getResources().getDisplayMetrics().density;
        }
        return (int)((float)n2 / density + 0.5f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObjectFromFile(String object) {
        block7: {
            if (TextUtils.isEmpty((CharSequence)object)) return null;
            try {
                object = new File((String)object);
            }
            catch (Throwable throwable) {}
            try {
                boolean bl = ((File)object).exists();
                if (!bl) {
                    return null;
                }
                break block7;
            }
            catch (Throwable throwable) {}
            {
                ((Throwable)object).printStackTrace();
                return null;
            }
        }
        if (object == null) return null;
        try {
            object = new ObjectInputStream(new GZIPInputStream(new FileInputStream((File)object)));
            Object object2 = ((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
            return object2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveObjectToFile(String object, Object object2) {
        block8: {
            if (TextUtils.isEmpty((CharSequence)object)) return false;
            try {
                object = new File((String)object);
            }
            catch (Throwable throwable) {}
            try {
                if (((File)object).exists()) {
                    ((File)object).delete();
                }
                if (!((File)object).getParentFile().exists()) {
                    ((File)object).getParentFile().mkdirs();
                }
                ((File)object).createNewFile();
                break block8;
            }
            catch (Throwable throwable) {}
            {
                ((Throwable)object).printStackTrace();
                return false;
            }
        }
        if (object == null) return false;
        try {
            object = new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream((File)object)));
            ((ObjectOutputStream)object).writeObject(object2);
            ((ObjectOutputStream)object).flush();
            ((ObjectOutputStream)object).close();
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    @Deprecated
    public static void setCacheRoot(String string2) {
    }

    public static void setResourceProvider(Object object) {
        try {
            if (object.getClass().getMethod("getResId", Context.class, String.class, String.class) != null) {
                rp = object;
            }
            return;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
            return;
        }
    }

    public static long strToDate(String string2) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string2, new ParsePosition(0)).getTime();
    }

    public static String toString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String toWordText(String object, int n2) {
        object = ((String)object).toCharArray();
        int n3 = n2 * 2;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = ((Object)object).length;
        n2 = 0;
        while (n2 < n4) {
            Object object2 = object[n2];
            int n5 = object2 < 256 ? 1 : 2;
            if ((n3 -= n5) < 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append((char)object2);
            ++n2;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bundle urlToBundle(String object) {
        int n2 = ((String)object).indexOf("://");
        object = n2 >= 0 ? "http://" + ((String)object).substring(n2 + 1) : "http://" + (String)object;
        try {
            object = new URL((String)object);
            Bundle bundle = R.decodeUrl(((URL)object).getQuery());
            bundle.putAll(R.decodeUrl(((URL)object).getRef()));
            return bundle;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return new Bundle();
        }
    }
}

