/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import java.util.ArrayList;

public class LocationHelper
implements LocationListener,
Handler.Callback {
    private int GPSTimeoutSec;
    private boolean gpsRequesting;
    private Handler handler;
    private LocationManager lm;
    private boolean networkRequesting;
    int networkTimeoutSec;
    private ArrayList<Float> res;

    public LocationHelper() {
        HandlerThread handlerThread = new HandlerThread("LocationUpdater");
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper(), (Handler.Callback)this);
        this.res = new ArrayList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onGPSTimeout() {
        this.lm.removeUpdates((LocationListener)this);
        this.gpsRequesting = false;
        if (!this.lm.isProviderEnabled("network")) {
            synchronized (this) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
            return;
        }
        this.networkRequesting = true;
        this.lm.requestLocationUpdates("network", 1000L, 0.0f, (LocationListener)this);
        if (this.networkTimeoutSec > 0) {
            this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRequest() {
        if (this.lm.isProviderEnabled("gps")) {
            this.gpsRequesting = true;
            this.lm.requestLocationUpdates("gps", 1000L, 0.0f, (LocationListener)this);
            if (this.GPSTimeoutSec <= 0) return;
            this.handler.sendEmptyMessageDelayed(1, (long)(this.GPSTimeoutSec * 1000));
            return;
        }
        if (!this.lm.isProviderEnabled("network")) {
            synchronized (this) {
                this.notifyAll();
            }
            this.handler.getLooper().quit();
            return;
        }
        this.networkRequesting = true;
        this.lm.requestLocationUpdates("network", 1000L, 0.0f, (LocationListener)this);
        if (this.networkTimeoutSec <= 0) return;
        this.handler.sendEmptyMessageDelayed(1, (long)(this.networkTimeoutSec * 1000));
    }

    public float[] getLocation(Context context) throws Throwable {
        return this.getLocation(context, 0);
    }

    public float[] getLocation(Context context, int n2) throws Throwable {
        return this.getLocation(context, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public float[] getLocation(Context context, int n2, int n3) throws Throwable {
        this.GPSTimeoutSec = n2;
        this.networkTimeoutSec = n3;
        this.lm = (LocationManager)context.getSystemService("location");
        if (this.lm == null) {
            return null;
        }
        // MONITORENTER : this
        this.handler.sendEmptyMessageDelayed(0, 50L);
        this.wait();
        // MONITOREXIT : this
        if (this.res.size() <= 0) return null;
        return new float[]{this.res.get(0).floatValue(), this.res.get(1).floatValue()};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleMessage(Message message) {
        if (message.what == 0) {
            this.onRequest();
            return false;
        }
        if (this.gpsRequesting) {
            this.onGPSTimeout();
            return false;
        }
        if (!this.networkRequesting) return false;
        this.lm.removeUpdates((LocationListener)this);
        synchronized (this) {
            this.notifyAll();
        }
        this.handler.getLooper().quit();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onLocationChanged(Location location) {
        synchronized (this) {
            this.lm.removeUpdates((LocationListener)this);
            if (location != null) {
                this.res.add(Float.valueOf((float)location.getLatitude()));
                this.res.add(Float.valueOf((float)location.getLongitude()));
            }
            this.notifyAll();
        }
        this.handler.getLooper().quit();
    }

    public void onProviderDisabled(String string2) {
    }

    public void onProviderEnabled(String string2) {
    }

    public void onStatusChanged(String string2, int n2, Bundle bundle) {
    }
}

