/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.mob.tools.MobLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class LocalDB {
    private File dbFile;
    private HashMap<String, Object> map;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commit() {
        if (this.map == null || this.dbFile == null) {
            return;
        }
        try {
            if (!this.dbFile.getParentFile().exists()) {
                this.dbFile.getParentFile().mkdirs();
            }
            HashMap<String, Object> hashMap = this.map;
            synchronized (hashMap) {
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return;
        }
        {
            OutputStream outputStream = new FileOutputStream(this.dbFile);
            if (((FileOutputStream)outputStream).getChannel().tryLock() != null) {
                outputStream = new ObjectOutputStream(outputStream);
                ((ObjectOutputStream)outputStream).writeObject(this.map);
                ((ObjectOutputStream)outputStream).flush();
                ((ObjectOutputStream)outputStream).close();
            } else {
                ((FileOutputStream)outputStream).close();
            }
            return;
        }
    }

    private Object get(String string2) {
        if (this.map == null) {
            return null;
        }
        return this.map.get(string2);
    }

    private void put(String string2, Object object) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(string2, object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean getBoolean(String object) {
        if ((object = this.get((String)object)) == null || !(object instanceof Boolean)) {
            return false;
        }
        return (Boolean)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public float getFloat(String object) {
        if ((object = this.get((String)object)) == null || !(object instanceof Integer)) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getInt(String object) {
        if ((object = this.get((String)object)) == null || !(object instanceof Integer)) {
            return 0;
        }
        return (Integer)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long getLong(String object) {
        if ((object = this.get((String)object)) == null || !(object instanceof Long)) {
            return 0L;
        }
        return (Long)object;
    }

    public Object getObject(String object) {
        block3: {
            try {
                object = this.getString((String)object);
                if (!TextUtils.isEmpty((CharSequence)object)) break block3;
                return null;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().w(throwable);
                return null;
            }
        }
        object = new ObjectInputStream(new ByteArrayInputStream(Base64.decode((String)object, (int)2)));
        Object object2 = ((ObjectInputStream)object).readObject();
        ((ObjectInputStream)object).close();
        return object2;
    }

    public String getString(String object) {
        if ((object = this.get((String)object)) == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    public void open(String object) {
        try {
            if (TextUtils.isEmpty((CharSequence)object)) {
                return;
            }
            this.dbFile = new File((String)object);
            if (this.dbFile.exists()) {
                object = new ObjectInputStream(new FileInputStream(this.dbFile));
                this.map = (HashMap)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
                return;
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
        }
    }

    public void putBoolean(String string2, Boolean bl) {
        this.put(string2, bl);
        this.commit();
    }

    public void putFloat(String string2, Float f2) {
        this.put(string2, f2);
        this.commit();
    }

    public void putInt(String string2, Integer n2) {
        this.put(string2, n2);
        this.commit();
    }

    public void putLong(String string2, Long l2) {
        this.put(string2, l2);
        this.commit();
    }

    public void putObject(String string2, Object object) {
        if (object == null) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            this.putString(string2, Base64.encodeToString((byte[])byteArrayOutputStream.toByteArray(), (int)2));
            return;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return;
        }
    }

    public void putString(String string2, String string3) {
        this.put(string2, string3);
        this.commit();
    }

    public void remove(String string2) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.remove(string2);
        this.commit();
    }
}

