/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.app.ActivityManager;
import android.app.UiModeManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.IBinder;
import android.os.Parcel;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.mob.tools.MobLog;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.LocationHelper;
import com.mob.tools.utils.R;
import com.mob.tools.utils.ReflectHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;

public class DeviceHelper {
    private static DeviceHelper deviceHelper;
    private Context context;

    private DeviceHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    public static DeviceHelper getInstance(Context context) {
        if (deviceHelper == null && context != null) {
            deviceHelper = new DeviceHelper(context);
        }
        return deviceHelper;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getLocalDeviceKey() throws Throwable {
        Object object;
        if (!(this.getSdcardState() && ((File)(object = new File(this.getSdcardPath(), "ShareSDK"))).exists() && ((File)(object = new File((File)object, ".dk"))).exists())) {
            return null;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream((File)object));
        Object object2 = objectInputStream.readObject();
        Object var2_4 = null;
        object = var2_4;
        if (object2 != null) {
            object = var2_4;
            if (object2 instanceof char[]) {
                object = String.valueOf((char[])object2);
            }
        }
        objectInputStream.close();
        return object;
    }

    private Object getSystemService(String object) {
        try {
            object = this.context.getSystemService((String)object);
            return object;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean is4GMobileNetwork() {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        return telephonyManager != null && telephonyManager.getNetworkType() == 13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFastMobileNetwork() {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return false;
        }
        switch (telephonyManager.getNetworkType()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return false;
            }
            default: {
                return false;
            }
            case 3: {
                return true;
            }
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 10: {
                return true;
            }
            case 9: {
                return true;
            }
            case 14: {
                return true;
            }
            case 12: {
                return true;
            }
            case 15: {
                return true;
            }
            case 13: 
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSystemApp(PackageInfo packageInfo) {
        boolean bl = false;
        boolean bl2 = (packageInfo.applicationInfo.flags & 1) == 1;
        boolean bl3 = (packageInfo.applicationInfo.flags & 0x80) == 1;
        if (bl2) return true;
        if (!bl3) return bl;
        return true;
    }

    private void saveLocalDeviceKey(String string2) throws Throwable {
        if (!this.getSdcardState()) {
            return;
        }
        Object object = new File(this.getSdcardPath(), "ShareSDK");
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        if (((File)(object = new File((File)object, ".dk"))).exists()) {
            ((File)object).delete();
        }
        object = new ObjectOutputStream(new FileOutputStream((File)object));
        ((ObjectOutputStream)object).writeObject(string2.toCharArray());
        ((ObjectOutputStream)object).flush();
        ((ObjectOutputStream)object).close();
    }

    public String Base64AES(String string2, String string3) {
        block4: {
            String string4 = null;
            try {
                string3 = string2 = Base64.encodeToString((byte[])Data.AES128Encode(string3, string2), (int)0);
                string4 = string2;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().w(throwable);
                return string4;
            }
            if (!string2.contains("\n")) break block4;
            string4 = string2;
            string3 = string2.replace("\n", "");
        }
        return string3;
    }

    public boolean checkPermission(String object) throws Throwable {
        int n2;
        if (Build.VERSION.SDK_INT >= 23) {
            block5: {
                ReflectHelper.importClass("android.content.Context");
                object = (Integer)ReflectHelper.invokeInstanceMethod(this.context, "checkSelfPermission", object);
                if (object != null) break block5;
                n2 = -1;
            }
            try {
                n2 = (Integer)object;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().w(throwable);
                n2 = -1;
            }
        } else {
            this.context.checkPermission((String)object, android.os.Process.myPid(), android.os.Process.myUid());
            n2 = this.context.getPackageManager().checkPermission((String)object, this.getPackageName());
        }
        return n2 == 0;
    }

    public String getAdvertisingID() {
        try {
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            GSConnection gSConnection = new GSConnection();
            this.context.bindService(intent, (ServiceConnection)gSConnection, 1);
            Object object = gSConnection.takeBinder();
            intent = Parcel.obtain();
            gSConnection = Parcel.obtain();
            intent.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
            object.transact(1, (Parcel)intent, (Parcel)gSConnection, 0);
            gSConnection.readException();
            object = gSConnection.readString();
            gSConnection.recycle();
            intent.recycle();
            MobLog.getInstance().i("getAdvertisingID === " + (String)object, new Object[0]);
            return object;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
            return null;
        }
    }

    public String getAndroidID() {
        String string2 = Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
        MobLog.getInstance().i("getAndroidID === " + string2, new Object[0]);
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getAppName() {
        String string2 = this.context.getApplicationInfo().name;
        if (string2 != null) {
            return string2;
        }
        int n2 = this.context.getApplicationInfo().labelRes;
        if (n2 <= 0) return String.valueOf(this.context.getApplicationInfo().nonLocalizedLabel);
        return this.context.getString(n2);
    }

    public int getAppVersion() {
        try {
            int n2 = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionCode;
            return n2;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
            return 0;
        }
    }

    public String getAppVersionName() {
        try {
            String string2 = this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionName;
            return string2;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
            return "1.0";
        }
    }

    public String getBluetoothName() {
        block4: {
            Object object = BluetoothAdapter.getDefaultAdapter();
            if (object == null) break block4;
            try {
                if (this.checkPermission("android.permission.BLUETOOTH")) {
                    object = object.getName();
                    return object;
                }
            }
            catch (Throwable throwable) {
                MobLog.getInstance().d(throwable);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String getBssid() {
        void var1_5;
        String string2;
        WifiInfo wifiInfo;
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        if (wifiManager == null || (wifiInfo = wifiManager.getConnectionInfo()) == null) {
            return null;
        }
        String string3 = string2 = wifiInfo.getBSSID();
        if (string2 == null) {
            return var1_5;
        }
        return var1_5;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String getCarrier() {
        String string2;
        void var1_3;
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return var1_3;
        }
        String string3 = string2 = telephonyManager.getSimOperator();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return var1_3;
        }
        return "-1";
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCarrierName() {
        void var2_3;
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return var2_3;
        }
        try {
            if (!this.checkPermission("android.permission.READ_PHONE_STATE")) return null;
            String string2 = telephonyManager.getSimOperatorName();
            boolean bl = TextUtils.isEmpty((CharSequence)string2);
            if (!bl) return var2_3;
            return null;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return null;
        }
    }

    public int getCellId() {
        block3: {
            TelephonyManager telephonyManager;
            if (!this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") || (telephonyManager = (TelephonyManager)this.getSystemService("phone")) == null) break block3;
            try {
                int n2 = ((GsmCellLocation)telephonyManager.getCellLocation()).getCid();
                return n2;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().d(throwable);
            }
        }
        return -1;
    }

    public int getCellLac() {
        block3: {
            TelephonyManager telephonyManager;
            if (!this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") || (telephonyManager = (TelephonyManager)this.getSystemService("phone")) == null) break block3;
            try {
                int n2 = ((GsmCellLocation)telephonyManager.getCellLocation()).getLac();
                return n2;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().d(throwable);
            }
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getCharAndNumr(int n2) {
        long l2 = System.currentTimeMillis();
        long l3 = SystemClock.elapsedRealtime();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l2 ^ l3);
        Random random = new Random();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(string2)) {
                stringBuffer.insert(n3 + 1, (char)(random.nextInt(26) + 97));
            } else {
                stringBuffer.insert(stringBuffer.length(), random.nextInt(10));
            }
            ++n3;
        }
        return stringBuffer.toString().substring(0, 40);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDetailNetworkTypeForStatic() {
        String string2 = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)string2)) return "none";
        if ("none".equals(string2)) {
            return "none";
        }
        if (string2.startsWith("wifi")) {
            return "wifi";
        }
        if (string2.startsWith("4g")) {
            return "4g";
        }
        if (string2.startsWith("3g")) {
            return "3g";
        }
        if (string2.startsWith("2g")) {
            return "2g";
        }
        String string3 = string2;
        if (!string2.startsWith("bluetooth")) return string3;
        return "bluetooth";
    }

    public String getDeviceData() {
        return this.Base64AES(this.getModel() + "|" + this.getOSVersionInt() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize(), this.getDeviceKey().substring(0, 15));
    }

    public String getDeviceDataNotAES() {
        return this.getModel() + "|" + this.getOSVersion() + "|" + this.getManufacturer() + "|" + this.getCarrier() + "|" + this.getScreenSize();
    }

    public String getDeviceId() {
        String string2;
        String string3 = string2 = this.getIMEI();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string3 = string2;
            if (Build.VERSION.SDK_INT >= 9) {
                string3 = this.getSerialno();
            }
        }
        return string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDeviceKey() {
        String string2;
        block11: {
            block10: {
                String string3;
                try {
                    string3 = this.getLocalDeviceKey();
                }
                catch (Throwable throwable) {
                    MobLog.getInstance().w(throwable);
                    string3 = null;
                }
                if (string3 != null) {
                    return string3;
                }
                try {
                    string3 = this.getMacAddress();
                    string2 = this.getDeviceId();
                    String string4 = this.getModel();
                    string3 = Data.byteToHex(Data.SHA1(string3 + ":" + string2 + ":" + string4));
                }
                catch (Throwable throwable) {
                    MobLog.getInstance().d(throwable);
                    string3 = null;
                }
                if (TextUtils.isEmpty((CharSequence)string3)) break block10;
                string2 = string3;
                if (string3.length() >= 40) break block11;
            }
            string2 = this.getCharAndNumr(40);
        }
        if (string2 == null) return string2;
        try {
            this.saveLocalDeviceKey(string2);
            return string2;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return string2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDeviceType() {
        UiModeManager uiModeManager = (UiModeManager)this.getSystemService("uimode");
        if (uiModeManager == null) return "UNDEFINED";
        switch (uiModeManager.getCurrentModeType()) {
            default: {
                return "UNDEFINED";
            }
            case 1: {
                return "NO_UI";
            }
            case 2: {
                return "DESK";
            }
            case 3: {
                return "CAR";
            }
            case 4: {
                return "TELEVISION";
            }
            case 5: {
                return "APPLIANCE";
            }
            case 6: 
        }
        return "WATCH";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIMEI() {
        String string2;
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        String string3 = string2 = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                string3 = telephonyManager.getDeviceId();
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            string3 = string2;
        }
        string2 = string3;
        if (!TextUtils.isEmpty((CharSequence)string3)) return string2;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIMSI() {
        String string2;
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        String string3 = string2 = null;
        try {
            if (this.checkPermission("android.permission.READ_PHONE_STATE")) {
                string3 = telephonyManager.getSubscriberId();
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            string3 = string2;
        }
        string2 = string3;
        if (!TextUtils.isEmpty((CharSequence)string3)) return string2;
        return null;
    }

    public String getIPAddress() {
        try {
            if (this.checkPermission("android.permission.INTERNET")) {
                Object object = NetworkInterface.getNetworkInterfaces();
                while (object.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration = object.nextElement().getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        InetAddress inetAddress = enumeration.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                        object = inetAddress.getHostAddress();
                        return object;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
        }
        return "0.0.0.0";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<HashMap<String, String>> getInstalledApp(boolean bl) {
        try {
            PackageManager packageManager = this.context.getPackageManager();
            PackageInfo packageInfo = packageManager.getInstalledPackages(0);
            ArrayList arrayList = new ArrayList();
            Iterator iterator = packageInfo.iterator();
            while (true) {
                packageInfo = arrayList;
                if (!iterator.hasNext()) return packageInfo;
                packageInfo = (PackageInfo)iterator.next();
                if (!bl && this.isSystemApp(packageInfo)) continue;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("pkg", packageInfo.packageName);
                hashMap.put("name", packageInfo.applicationInfo.loadLabel(packageManager).toString());
                hashMap.put("version", packageInfo.versionName);
                arrayList.add(hashMap);
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return new ArrayList<HashMap<String, String>>();
        }
    }

    public String getLine1Number() {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return "-1";
        }
        return telephonyManager.getLine1Number();
    }

    public float[] getLocation(int n2, int n3) {
        try {
            if (this.checkPermission("android.permission.ACCESS_FINE_LOCATION") && (LocationManager)this.getSystemService("location") != null) {
                float[] fArray = new LocationHelper().getLocation(this.context, n2, n3);
                return fArray;
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getMCC() {
        String string2;
        if ((TelephonyManager)this.getSystemService("phone") == null || (string2 = this.getIMSI()) == null || string2.length() < 3) {
            return null;
        }
        return string2.substring(0, 3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getMNC() {
        String string2;
        if ((TelephonyManager)this.getSystemService("phone") == null || (string2 = this.getIMSI()) == null || string2.length() < 5) {
            return null;
        }
        return string2.substring(3, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMacAddress() {
        String string2;
        Object object;
        String string3 = null;
        if (Build.VERSION.SDK_INT >= 23) {
            try {
                object = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("cat /sys/class/net/wlan0/address").getInputStream()));
                string2 = ((BufferedReader)object).readLine();
                ((BufferedReader)object).close();
            }
            catch (Throwable throwable) {
                string2 = null;
            }
            if (string2 != null) return string2;
        }
        object = (WifiManager)this.getSystemService("wifi");
        string2 = string3;
        if (object == null) return string2;
        object = object.getConnectionInfo();
        string2 = string3;
        if (object == null) {
            return string2;
        }
        string2 = string3 = object.getMacAddress();
        if (string3 != null) return string2;
        return null;
    }

    public String getManufacturer() {
        return Build.MANUFACTURER;
    }

    public String getMime() {
        return this.getIMEI();
    }

    public String getModel() {
        return Build.MODEL;
    }

    public String getNetworkOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return null;
        }
        return telephonyManager.getNetworkOperator();
    }

    public String getNetworkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        if (connectivityManager == null) {
            return "none";
        }
        try {
            if (!this.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
                return "none";
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return "none";
        }
        if ((connectivityManager = connectivityManager.getActiveNetworkInfo()) == null || !connectivityManager.isAvailable()) {
            return "none";
        }
        int n2 = connectivityManager.getType();
        switch (n2) {
            default: {
                return String.valueOf(n2);
            }
            case 1: {
                return "wifi";
            }
            case 0: {
                if (this.is4GMobileNetwork()) {
                    return "4G";
                }
                if (this.isFastMobileNetwork()) {
                    return "3G";
                }
                return "2G";
            }
            case 7: {
                return "bluetooth";
            }
            case 8: {
                return "dummy";
            }
            case 9: {
                return "ethernet";
            }
            case 6: 
        }
        return "wimax";
    }

    public String getNetworkTypeForStatic() {
        String string2 = this.getNetworkType().toLowerCase();
        if (TextUtils.isEmpty((CharSequence)string2) || "none".equals(string2)) {
            return "none";
        }
        if (string2.startsWith("4g") || string2.startsWith("3g") || string2.startsWith("2g")) {
            return "cell";
        }
        if (string2.startsWith("wifi")) {
            return "wifi";
        }
        return "other";
    }

    public String getOSCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getOSLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getOSVersion() {
        return String.valueOf(this.getOSVersionInt());
    }

    public int getOSVersionInt() {
        return Build.VERSION.SDK_INT;
    }

    public String getOSVersionName() {
        return Build.VERSION.RELEASE;
    }

    public String getPackageName() {
        return this.context.getPackageName();
    }

    public int getPlatformCode() {
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public JSONArray getRunningApp() {
        JSONArray jSONArray = new JSONArray();
        Object object = (ActivityManager)this.getSystemService("activity");
        if (object != null && (object = object.getRunningAppProcesses()) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                jSONArray.put((Object)((ActivityManager.RunningAppProcessInfo)object.next()).processName);
            }
        }
        return jSONArray;
    }

    public String getRunningAppStr() throws JSONException {
        JSONArray jSONArray = this.getRunningApp();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(String.valueOf(jSONArray.get(i2)));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String getSSID() {
        void var1_5;
        String string2;
        WifiInfo wifiInfo;
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        if (wifiManager == null || (wifiInfo = wifiManager.getConnectionInfo()) == null) {
            return null;
        }
        String string3 = string2 = wifiInfo.getSSID().replace("\"", "");
        if (string2 == null) {
            return var1_5;
        }
        return var1_5;
    }

    public String getScreenSize() {
        int[] nArray = R.getScreenSize(this.context);
        if (this.context.getResources().getConfiguration().orientation == 1) {
            return nArray[0] + "x" + nArray[1];
        }
        return nArray[1] + "x" + nArray[0];
    }

    public String getSdcardPath() {
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public boolean getSdcardState() {
        try {
            boolean bl = "mounted".equals(Environment.getExternalStorageState());
            return bl;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSerialno() {
        Object object = null;
        if (Build.VERSION.SDK_INT < 9) return object;
        try {
            object = Class.forName("android.os.SystemProperties");
            return (String)((Class)object).getMethod("get", String.class, String.class).invoke(object, "ro.serialno", "unknown");
        }
        catch (Throwable throwable) {
            MobLog.getInstance().d(throwable);
            return null;
        }
    }

    public String getSignMD5() {
        try {
            String string2 = Data.MD5(this.context.getPackageManager().getPackageInfo((String)this.getPackageName(), (int)64).signatures[0].toByteArray());
            return string2;
        }
        catch (Exception exception) {
            MobLog.getInstance().w(exception);
            return null;
        }
    }

    public String getSimSerialNumber() {
        TelephonyManager telephonyManager = (TelephonyManager)this.getSystemService("phone");
        if (telephonyManager == null) {
            return "-1";
        }
        return telephonyManager.getSimSerialNumber();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTopTaskPackageName() {
        try {
            boolean bl = this.checkPermission("android.permission.GET_TASKS");
            if (!bl) return null;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return null;
        }
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        try {
            if (Build.VERSION.SDK_INT > 20) return ((ActivityManager.RunningAppProcessInfo)activityManager.getRunningAppProcesses().get((int)0)).processName.split(":")[0];
            return ((ActivityManager.RunningTaskInfo)activityManager.getRunningTasks((int)1).get((int)0)).topActivity.getPackageName();
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
        }
        return null;
    }

    public void hideSoftInput(View view) {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            return;
        }
        ((InputMethodManager)object).hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public boolean isMainProcess(int n2) {
        Object object;
        block3: {
            Object var3_2 = null;
            object = (ActivityManager)this.getSystemService("activity");
            if (object.getRunningAppProcesses() == null) {
                return n2 <= 0;
            }
            if (n2 <= 0) {
                n2 = android.os.Process.myPid();
            }
            Iterator iterator = object.getRunningAppProcesses().iterator();
            do {
                object = var3_2;
                if (!iterator.hasNext()) break block3;
                object = (ActivityManager.RunningAppProcessInfo)iterator.next();
            } while (object.pid != n2);
            object = object.processName;
        }
        return this.getPackageName().equals(object);
    }

    public boolean isMainProcess(Context context, int n2) {
        return this.isMainProcess(n2);
    }

    public boolean isRooted() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap<String, String> ping(String string2, int n2, int n3) {
        float f2;
        float f3;
        float f4;
        int n4;
        int n5;
        Object object;
        block15: {
            ArrayList<Float> arrayList = new ArrayList<Float>();
            try {
                object = "ping -c " + n2 + " -s " + n3 + " " + string2;
                Process process = Runtime.getRuntime().exec((String)object);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                object = bufferedReader.readLine();
                while (object != null) {
                    if (((String)object).startsWith(n3 + 8 + " bytes from")) {
                        Object object2;
                        if (((String)object).endsWith("ms")) {
                            object2 = ((String)object).substring(0, ((String)object).length() - 2).trim();
                        } else {
                            object2 = object;
                            if (((String)object).endsWith("s")) {
                                object2 = ((String)object).substring(0, ((String)object).length() - 1).trim() + "000";
                            }
                        }
                        if ((n5 = ((String)object2).indexOf("time=")) > 0) {
                            object = ((String)object2).substring(n5 + 5).trim();
                            try {
                                arrayList.add(Float.valueOf(Float.parseFloat((String)object)));
                            }
                            catch (Throwable throwable) {
                                MobLog.getInstance().w(throwable);
                            }
                        }
                    }
                    object = bufferedReader.readLine();
                }
                process.waitFor();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            n5 = arrayList.size();
            n4 = arrayList.size();
            f4 = 0.0f;
            f3 = 0.0f;
            float f5 = 0.0f;
            f2 = 0.0f;
            float f6 = 0.0f;
            if (n5 <= 0) break block15;
            f3 = Float.MAX_VALUE;
            f2 = f5;
            f4 = f6;
            for (n3 = 0; n3 < n5; f4 += f6, ++n3) {
                f6 = ((Float)arrayList.get(n3)).floatValue();
                f5 = f3;
                if (f6 < f3) {
                    f5 = f6;
                }
                f3 = f2;
                if (f6 > f2) {
                    f3 = f6;
                }
                f2 = f3;
                f3 = f5;
            }
            f6 = f4 / (float)n5;
            f4 = f3;
            f3 = f2;
            f2 = f6;
        }
        object = new HashMap();
        ((HashMap)object).put("address", string2);
        ((HashMap)object).put("transmitted", String.valueOf(n2));
        ((HashMap)object).put("received", String.valueOf(n5));
        ((HashMap)object).put("loss", String.valueOf(n2 - n4));
        ((HashMap)object).put("min", String.valueOf(f4));
        ((HashMap)object).put("max", String.valueOf(f3));
        ((HashMap)object).put("avg", String.valueOf(f2));
        return object;
    }

    public void showSoftInput(View view) {
        Object object = this.getSystemService("input_method");
        if (object == null) {
            return;
        }
        ((InputMethodManager)object).toggleSoftInputFromWindow(view.getWindowToken(), 2, 0);
    }

    private class GSConnection
    implements ServiceConnection {
        boolean got = false;
        private final BlockingQueue<IBinder> iBinders = new LinkedBlockingQueue<IBinder>();

        private GSConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.iBinders.put(iBinder);
                return;
            }
            catch (Throwable throwable) {
                MobLog.getInstance().w(throwable);
                return;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder takeBinder() throws InterruptedException {
            if (this.got) {
                throw new IllegalStateException();
            }
            this.got = true;
            return this.iBinders.poll(1500L, TimeUnit.MILLISECONDS);
        }
    }
}

