/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.text.TextUtils;
import android.view.View;
import com.mob.tools.MobLog;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.utils.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;

public class BitmapHelper {
    public static Bitmap blur(Bitmap bitmap, int n2, int n3) {
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        n2 = (int)((float)n2 / (float)n3 + 0.5f);
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)((float)n4 / (float)n3 + 0.5f)), (int)((int)((float)n5 / (float)n3 + 0.5f)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.scale(1.0f / (float)n3, 1.0f / (float)n3);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        BitmapHelper.blur(bitmap2, n2, true);
        return bitmap2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Bitmap blur(Bitmap bitmap, int n2, boolean bl) {
        int n3;
        int n4;
        int[] nArray;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (!bl) {
            bitmap = bitmap.copy(bitmap.getConfig(), true);
        }
        if (n2 < 1) {
            return null;
        }
        int n14 = bitmap.getWidth();
        int n15 = bitmap.getHeight();
        int[] nArray2 = new int[n14 * n15];
        bitmap.getPixels(nArray2, 0, n14, 0, 0, n14, n15);
        int n16 = n14 - 1;
        int n17 = n15 - 1;
        int n18 = n14 * n15;
        int n19 = n2 + n2 + 1;
        int[] nArray3 = new int[n18];
        int[] nArray4 = new int[n18];
        int[] nArray5 = new int[n18];
        int[] nArray6 = new int[Math.max(n14, n15)];
        n18 = n19 + 1 >> 1;
        int n20 = n18 * n18;
        int[] nArray7 = new int[n20 * 256];
        for (n18 = 0; n18 < n20 * 256; ++n18) {
            nArray7[n18] = n18 / n20;
        }
        int n21 = 0;
        int n22 = 0;
        int[][] nArray8 = (int[][])Array.newInstance(Integer.TYPE, n19, 3);
        int n23 = n2 + 1;
        int n24 = 0;
        while (true) {
            if (n24 >= n15) break;
            n13 = 0;
            n12 = 0;
            n11 = 0;
            n20 = 0;
            n10 = 0;
            n9 = 0;
            n18 = 0;
            n8 = 0;
            n7 = 0;
            for (n6 = -n2; n6 <= n2; ++n6) {
                n5 = nArray2[Math.min(n16, Math.max(n6, 0)) + n21];
                nArray = nArray8[n6 + n2];
                nArray[0] = (0xFF0000 & n5) >> 16;
                nArray[1] = (0xFF00 & n5) >> 8;
                nArray[2] = n5 & 0xFF;
                n5 = n23 - Math.abs(n6);
                n11 += nArray[0] * n5;
                n12 += nArray[1] * n5;
                n13 += nArray[2] * n5;
                if (n6 > 0) {
                    n7 += nArray[0];
                    n8 += nArray[1];
                    n18 += nArray[2];
                    continue;
                }
                n9 += nArray[0];
                n10 += nArray[1];
                n20 += nArray[2];
            }
            n5 = n2;
            for (n6 = 0; n6 < n14; n7 -= nArray[0], n8 -= nArray[1], n18 -= nArray[2], ++n21, ++n6) {
                nArray3[n21] = nArray7[n11];
                nArray4[n21] = nArray7[n12];
                nArray5[n21] = nArray7[n13];
                nArray = nArray8[(n5 - n2 + n19) % n19];
                int n25 = nArray[0];
                n4 = nArray[1];
                n3 = nArray[2];
                if (n24 == 0) {
                    nArray6[n6] = Math.min(n6 + n2 + 1, n16);
                }
                int n26 = nArray2[nArray6[n6] + n22];
                nArray[0] = (0xFF0000 & n26) >> 16;
                nArray[1] = (0xFF00 & n26) >> 8;
                nArray[2] = n26 & 0xFF;
                n11 = n11 - n9 + (n7 += nArray[0]);
                n12 = n12 - n10 + (n8 += nArray[1]);
                n13 = n13 - n20 + (n18 += nArray[2]);
                n5 = (n5 + 1) % n19;
                nArray = nArray8[n5 % n19];
                n9 = n9 - n25 + nArray[0];
                n10 = n10 - n4 + nArray[1];
                n20 = n20 - n3 + nArray[2];
            }
            n22 += n14;
            ++n24;
        }
        n18 = 0;
        while (true) {
            if (n18 >= n14) {
                bitmap.setPixels(nArray2, 0, n14, 0, 0, n14, n15);
                return bitmap;
            }
            n9 = 0;
            n11 = 0;
            n22 = 0;
            n8 = 0;
            n13 = 0;
            n12 = 0;
            n20 = 0;
            n7 = 0;
            n10 = 0;
            n24 = -n2 * n14;
            for (n21 = -n2; n21 <= n2; ++n21) {
                n6 = Math.max(0, n24) + n18;
                nArray = nArray8[n21 + n2];
                nArray[0] = nArray3[n6];
                nArray[1] = nArray4[n6];
                nArray[2] = nArray5[n6];
                n5 = n23 - Math.abs(n21);
                n22 += nArray3[n6] * n5;
                n11 += nArray4[n6] * n5;
                n9 += nArray5[n6] * n5;
                if (n21 > 0) {
                    n10 += nArray[0];
                    n7 += nArray[1];
                    n20 += nArray[2];
                } else {
                    n12 += nArray[0];
                    n13 += nArray[1];
                    n8 += nArray[2];
                }
                n6 = n24;
                if (n21 < n17) {
                    n6 = n24 + n14;
                }
                n24 = n6;
            }
            n21 = n18;
            n6 = n2;
            for (n24 = 0; n24 < n15; n10 -= nArray[0], n7 -= nArray[1], n20 -= nArray[2], n21 += n14, ++n24) {
                nArray2[n21] = 0xFF000000 & nArray2[n21] | nArray7[n22] << 16 | nArray7[n11] << 8 | nArray7[n9];
                nArray = nArray8[(n6 - n2 + n19) % n19];
                n3 = nArray[0];
                n16 = nArray[1];
                n5 = nArray[2];
                if (n18 == 0) {
                    nArray6[n24] = Math.min(n24 + n23, n17) * n14;
                }
                n4 = n18 + nArray6[n24];
                nArray[0] = nArray3[n4];
                nArray[1] = nArray4[n4];
                nArray[2] = nArray5[n4];
                n22 = n22 - n12 + (n10 += nArray[0]);
                n11 = n11 - n13 + (n7 += nArray[1]);
                n9 = n9 - n8 + (n20 += nArray[2]);
                n6 = (n6 + 1) % n19;
                nArray = nArray8[n6];
                n12 = n12 - n3 + nArray[0];
                n13 = n13 - n16 + nArray[1];
                n8 = n8 - n5 + nArray[2];
            }
            ++n18;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean bytesStartWith(byte[] byArray, byte[] byArray2) {
        if (byArray != byArray2) {
            if (byArray == null || byArray2 == null) {
                return false;
            }
            if (byArray.length < byArray2.length) {
                return false;
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                return false;
            }
        }
        return true;
    }

    public static Bitmap captureView(View view, int n2, int n3) throws Throwable {
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bitmap));
        return bitmap;
    }

    public static Bitmap cropBitmap(Bitmap bitmap, int n2, int n3, int n4, int n5) throws Throwable {
        n4 = bitmap.getWidth() - n2 - n4;
        n5 = bitmap.getHeight() - n3 - n5;
        if (n4 == bitmap.getWidth() && n5 == bitmap.getHeight()) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n4, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        canvas.drawBitmap(bitmap, (float)(-n2), (float)(-n3), paint);
        return bitmap2;
    }

    public static String downloadBitmap(Context context, String string2) throws Throwable {
        return new NetworkHelper().downloadCache(context, string2, "images", true, null);
    }

    public static int[] fixRect(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        if ((float)nArray[0] / (float)nArray[1] > (float)nArray2[0] / (float)nArray2[1]) {
            nArray3[0] = nArray2[0];
            nArray3[1] = (int)((float)nArray[1] * (float)nArray2[0] / (float)nArray[0] + 0.5f);
            return nArray3;
        }
        nArray3[1] = nArray2[1];
        nArray3[0] = (int)((float)nArray[0] * (float)nArray2[1] / (float)nArray[1] + 0.5f);
        return nArray3;
    }

    public static int[] fixRect_2(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[2];
        if ((float)nArray[0] / (float)nArray[1] > (float)nArray2[0] / (float)nArray2[1]) {
            nArray3[1] = nArray2[1];
            nArray3[0] = (int)((float)nArray[0] * (float)nArray2[1] / (float)nArray[1] + 0.5f);
            return nArray3;
        }
        nArray3[0] = nArray2[0];
        nArray3[1] = (int)((float)nArray[1] * (float)nArray2[0] / (float)nArray[0] + 0.5f);
        return nArray3;
    }

    public static Bitmap getBitmap(Context context, String string2) throws Throwable {
        return BitmapHelper.getBitmap(BitmapHelper.downloadBitmap(context, string2));
    }

    public static Bitmap getBitmap(File object, int n2) throws Throwable {
        if (object == null || !((File)object).exists()) {
            return null;
        }
        object = new FileInputStream((File)object);
        Bitmap bitmap = BitmapHelper.getBitmap((InputStream)object, n2);
        ((FileInputStream)object).close();
        return bitmap;
    }

    public static Bitmap getBitmap(InputStream inputStream, int n2) {
        if (inputStream == null) {
            return null;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = Bitmap.Config.RGB_565;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = n2;
        return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
    }

    public static Bitmap getBitmap(String string2) throws Throwable {
        return BitmapHelper.getBitmap(string2, 1);
    }

    public static Bitmap getBitmap(String string2, int n2) throws Throwable {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return BitmapHelper.getBitmap(new File(string2), n2);
    }

    public static Bitmap.CompressFormat getBmpFormat(String string2) {
        String string3 = string2.toLowerCase();
        if (string3.endsWith("png") || string3.endsWith("gif")) {
            return Bitmap.CompressFormat.PNG;
        }
        if (string3.endsWith("jpg") || string3.endsWith("jpeg") || string3.endsWith("bmp") || string3.endsWith("tif")) {
            return Bitmap.CompressFormat.JPEG;
        }
        if ((string2 = BitmapHelper.getMime(string2)).endsWith("png") || string2.endsWith("gif")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static Bitmap.CompressFormat getBmpFormat(byte[] object) {
        block2: {
            block3: {
                String string2 = BitmapHelper.getMime(object);
                Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.JPEG;
                object = compressFormat;
                if (string2 == null) break block2;
                if (string2.endsWith("png")) break block3;
                object = compressFormat;
                if (!string2.endsWith("gif")) break block2;
            }
            object = Bitmap.CompressFormat.PNG;
        }
        return object;
    }

    private static String getMime(String object) {
        try {
            object = new FileInputStream((String)object);
            byte[] byArray = new byte[8];
            ((FileInputStream)object).read(byArray);
            ((FileInputStream)object).close();
            object = BitmapHelper.getMime(byArray);
            return object;
        }
        catch (Exception exception) {
            MobLog.getInstance().w(exception);
            return null;
        }
    }

    private static String getMime(byte[] byArray) {
        if (BitmapHelper.bytesStartWith(byArray, new byte[]{-1, -40, -1, -32}) || BitmapHelper.bytesStartWith(byArray, new byte[]{-1, -40, -1, -31})) {
            return "jpg";
        }
        if (BitmapHelper.bytesStartWith(byArray, new byte[]{-119, 80, 78, 71})) {
            return "png";
        }
        if (BitmapHelper.bytesStartWith(byArray, "GIF".getBytes())) {
            return "gif";
        }
        if (BitmapHelper.bytesStartWith(byArray, "BM".getBytes())) {
            return "bmp";
        }
        if (BitmapHelper.bytesStartWith(byArray, new byte[]{73, 73, 42}) || BitmapHelper.bytesStartWith(byArray, new byte[]{77, 77, 42})) {
            return "tif";
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBlackBitmap(Bitmap bitmap) throws Throwable {
        boolean bl = false;
        if (bitmap == null) return true;
        if (bitmap.isRecycled()) {
            return true;
        }
        int[] nArray = new int[bitmap.getWidth() * bitmap.getHeight()];
        bitmap.getPixels(nArray, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        boolean bl2 = false;
        int n2 = 0;
        while (true) {
            block6: {
                boolean bl3;
                block5: {
                    bl3 = bl2;
                    if (n2 >= nArray.length) break block5;
                    if ((nArray[n2] & 0xFFFFFF) == 0) break block6;
                    bl3 = true;
                }
                if (bl3) return bl;
                return true;
            }
            ++n2;
        }
    }

    public static int mixAlpha(int n2, int n3) {
        int n4 = n2 >>> 24;
        return 0xFF000000 | (n4 * ((0xFF0000 & n2) >>> 16) + (255 - n4) * ((0xFF0000 & n3) >>> 16)) / 255 << 16 | (n4 * ((0xFF00 & n2) >>> 8) + (255 - n4) * ((0xFF00 & n3) >>> 8)) / 255 << 8 | (n4 * (n2 & 0xFF) + (255 - n4) * (n3 & 0xFF)) / 255;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap roundBitmap(Bitmap bitmap, int n2, int n3, float f2, float f3, float f4, float f5) throws Throwable {
        int n4 = bitmap.getWidth();
        int n5 = bitmap.getHeight();
        Rect rect = new Rect(0, 0, n4, n5);
        Bitmap bitmap2 = n4 != n2 || n5 != n3 ? Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        Rect rect2 = new Rect(0, 0, n2, n3);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        float[] fArray = new float[]{f2, f2, f3, f3, f4, f4, f5, f5};
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)new RoundRectShape(fArray, new RectF(0.0f, 0.0f, 0.0f, 0.0f), fArray));
        shapeDrawable.setBounds(rect2);
        shapeDrawable.draw(canvas);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect2, paint);
        return bitmap2;
    }

    public static String saveBitmap(Context context, Bitmap bitmap) throws Throwable {
        return BitmapHelper.saveBitmap(context, bitmap, Bitmap.CompressFormat.JPEG, 80);
    }

    public static String saveBitmap(Context object, Bitmap bitmap, Bitmap.CompressFormat compressFormat, int n2) throws Throwable {
        Object object2 = R.getCachePath((Context)object, "images");
        object = ".jpg";
        if (compressFormat == Bitmap.CompressFormat.PNG) {
            object = ".png";
        }
        object = new File((String)object2, String.valueOf(System.currentTimeMillis()) + (String)object);
        object2 = new FileOutputStream((File)object);
        bitmap.compress(compressFormat, n2, (OutputStream)object2);
        ((OutputStream)object2).flush();
        ((FileOutputStream)object2).close();
        return ((File)object).getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String saveViewToImage(View view) throws Throwable {
        int n2;
        int n3;
        block3: {
            block2: {
                if (view == null) break block2;
                n3 = view.getWidth();
                n2 = view.getHeight();
                if (n3 > 0 && n2 > 0) break block3;
            }
            return null;
        }
        return BitmapHelper.saveViewToImage(view, n3, n2);
    }

    public static String saveViewToImage(View object, int n2, int n3) throws Throwable {
        Bitmap bitmap = BitmapHelper.captureView((View)object, n2, n3);
        if (bitmap == null || bitmap.isRecycled()) {
            return null;
        }
        object = new File(R.getCachePath(object.getContext(), "screenshot"), String.valueOf(System.currentTimeMillis()) + ".jpg");
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        return ((File)object).getAbsolutePath();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap scaleBitmapByHeight(Context context, int n2, int n3) throws Throwable {
        n2 = n3 != (context = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2)).getHeight() ? 1 : 0;
        Bitmap bitmap = BitmapHelper.scaleBitmapByHeight((Bitmap)context, n3);
        if (n2 != 0) {
            context.recycle();
        }
        return bitmap;
    }

    public static Bitmap scaleBitmapByHeight(Bitmap bitmap, int n2) throws Throwable {
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(bitmap.getWidth() * n2 / bitmap.getHeight()), (int)n2, (boolean)true);
    }
}

