/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.network;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class MultiPartInputStream
extends InputStream {
    private int curIs;
    private ArrayList<InputStream> isList = new ArrayList();

    MultiPartInputStream() {
    }

    private boolean isEmpty() {
        return this.isList == null || this.isList.size() <= 0;
    }

    public void addInputStream(InputStream inputStream) throws Throwable {
        this.isList.add(inputStream);
    }

    @Override
    public int available() throws IOException {
        if (this.isEmpty()) {
            return 0;
        }
        return this.isList.get(this.curIs).available();
    }

    @Override
    public void close() throws IOException {
        Iterator<InputStream> iterator = this.isList.iterator();
        while (iterator.hasNext()) {
            iterator.next().close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read() throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        int n2 = this.isList.get(this.curIs).read();
        while (true) {
            int n3 = n2;
            if (n2 >= 0) return n3;
            ++this.curIs;
            n3 = n2;
            if (this.curIs >= this.isList.size()) return n3;
            n2 = this.isList.get(this.curIs).read();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        int n4 = this.isList.get(this.curIs).read(byArray, n2, n3);
        while (true) {
            int n5 = n4;
            if (n4 >= 0) return n5;
            ++this.curIs;
            n5 = n4;
            if (this.curIs >= this.isList.size()) return n5;
            n4 = this.isList.get(this.curIs).read(byArray, n2, n3);
        }
    }

    @Override
    public long skip(long l2) throws IOException {
        throw new IOException();
    }
}

