/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.network;

import com.mob.tools.network.BufferedByteArrayOutputStream;
import com.mob.tools.network.HTTPPart;
import com.mob.tools.utils.Data;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ByteArrayPart
extends HTTPPart {
    private BufferedByteArrayOutputStream buffer;

    public ByteArrayPart append(byte[] byArray) throws Throwable {
        if (this.buffer == null) {
            this.buffer = new BufferedByteArrayOutputStream(byArray.length);
        }
        this.buffer.write(byArray);
        this.buffer.flush();
        return this;
    }

    @Override
    protected InputStream getInputStream() throws Throwable {
        if (this.buffer == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        byte[] byArray = this.buffer.getBuffer();
        if (byArray == null || this.buffer.size() <= 0) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(byArray, 0, this.buffer.size());
    }

    @Override
    protected long length() throws Throwable {
        if (this.buffer == null) {
            return 0L;
        }
        return this.buffer.size();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        byte[] byArray;
        if (this.buffer == null || (byArray = this.buffer.getBuffer()) == null) {
            return null;
        }
        return Data.byteToHex(byArray, 0, this.buffer.size());
    }
}

