/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.content.Context;
import com.mob.tools.MobLog;
import com.mob.tools.utils.R;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class NativeErrorHandler {
    private static final int MAX_LOG_SIZE = 100;
    private static final boolean enable;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        boolean bl = false;
        try {
            System.loadLibrary("neh");
            bl = true;
        }
        catch (Throwable throwable) {}
        enable = bl;
    }

    private static String getCachePath(Context object) {
        if (!((File)(object = new File(R.getCacheRoot((Context)object), "NativeCrashLogs"))).exists()) {
            ((File)object).mkdirs();
        }
        return ((File)object).getAbsolutePath();
    }

    private static native void nativePrepare(String var0);

    private static ArrayList<NativeCrashInfo> parseIndex(String object) throws Throwable {
        if (!((File)(object = new File((String)object, ".ncl"))).exists()) {
            return new ArrayList<NativeCrashInfo>();
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
        ArrayList<NativeCrashInfo> arrayList = new ArrayList<NativeCrashInfo>();
        object = bufferedReader.readLine();
        while (object != null) {
            String[] stringArray = ((String)object).split(",");
            if (stringArray.length < 2) continue;
            object = new NativeCrashInfo();
            ((NativeCrashInfo)object).time = R.parseLong(stringArray[0]);
            ((NativeCrashInfo)object).signal = R.parseInt(stringArray[1]);
            arrayList.add((NativeCrashInfo)object);
            object = bufferedReader.readLine();
        }
        bufferedReader.close();
        return arrayList;
    }

    private static String parseLog(String object, NativeCrashInfo iterator) throws Throwable {
        if (!((File)(object = new File((String)object, "." + ((NativeCrashInfo)((Object)iterator)).time))).exists()) {
            return "";
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream((File)object)));
        iterator = new LinkedList();
        object = bufferedReader.readLine();
        while (object != null) {
            ((LinkedList)((Object)iterator)).add(object);
            if (((LinkedList)((Object)iterator)).size() > 100) {
                ((LinkedList)((Object)iterator)).remove(0);
            }
            object = bufferedReader.readLine();
        }
        bufferedReader.close();
        object = new StringBuffer();
        iterator = ((AbstractSequentialList)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)object).append((String)iterator.next()).append('\n');
        }
        if (((StringBuffer)object).length() > 0) {
            return ((StringBuffer)object).substring(0, ((StringBuffer)object).length() - 1);
        }
        return "";
    }

    public static boolean prepare(Context object) {
        object = NativeErrorHandler.getCachePath(object);
        if (enable) {
            NativeErrorHandler.uploadCreashLog((String)object);
            NativeErrorHandler.nativePrepare((String)object);
        }
        return enable;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void uploadCreashLog(String string2) {
        try {
            Iterator<NativeCrashInfo> iterator = NativeErrorHandler.parseIndex(string2).iterator();
            while (iterator.hasNext()) {
                String string3 = NativeErrorHandler.parseLog(string2, iterator.next());
                MobLog.getInstance().nativeCrashLog(string3);
            }
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return;
        }
        {
            R.deleteFileAndFolder(new File(string2));
            return;
        }
    }

    private static class NativeCrashInfo {
        public int signal;
        public long time;

        private NativeCrashInfo() {
        }
    }
}

